/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class HumanoidModel<T extends LivingEntity>
extends AgeableListModel<T>
implements ArmedModel,
HeadedModel {
    public static final float OVERLAY_SCALE = 0.25f;
    public static final float HAT_OVERLAY_SCALE = 0.5f;
    public static final float LEGGINGS_OVERLAY_SCALE = -0.1f;
    private static final float DUCK_WALK_ROTATION = 0.005f;
    private static final float SPYGLASS_ARM_ROT_Y = 0.2617994f;
    private static final float SPYGLASS_ARM_ROT_X = 1.9198622f;
    private static final float SPYGLASS_ARM_CROUCH_ROT_X = 0.2617994f;
    private static final float HIGHEST_SHIELD_BLOCKING_ANGLE = -1.3962634f;
    private static final float LOWEST_SHIELD_BLOCKING_ANGLE = 0.43633232f;
    private static final float HORIZONTAL_SHIELD_MOVEMENT_LIMIT = 0.5235988f;
    public static final float TOOT_HORN_XROT_BASE = 1.4835298f;
    public static final float TOOT_HORN_YROT_BASE = 0.5235988f;
    public final ModelPart head;
    public final ModelPart hat;
    public final ModelPart body;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public ArmPose leftArmPose = ArmPose.EMPTY;
    public ArmPose rightArmPose = ArmPose.EMPTY;
    public boolean crouching;
    public float swimAmount;

    public HumanoidModel(ModelPart p_170677_) {
        this(p_170677_, RenderType::entityCutoutNoCull);
    }

    public HumanoidModel(ModelPart p_170679_, Function<ResourceLocation, RenderType> p_170680_) {
        super(p_170680_, true, 16.0f, 0.0f, 2.0f, 2.0f, 24.0f);
        this.head = p_170679_.getChild("head");
        this.hat = p_170679_.getChild("hat");
        this.body = p_170679_.getChild("body");
        this.rightArm = p_170679_.getChild("right_arm");
        this.leftArm = p_170679_.getChild("left_arm");
        this.rightLeg = p_170679_.getChild("right_leg");
        this.leftLeg = p_170679_.getChild("left_leg");
    }

    public static MeshDefinition createMesh(CubeDeformation p_170682_, float p_170683_) {
        MeshDefinition $$2 = new MeshDefinition();
        PartDefinition $$3 = $$2.getRoot();
        $$3.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170682_), PartPose.offset(0.0f, 0.0f + p_170683_, 0.0f));
        $$3.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170682_.extend(0.5f)), PartPose.offset(0.0f, 0.0f + p_170683_, 0.0f));
        $$3.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_170682_), PartPose.offset(0.0f, 0.0f + p_170683_, 0.0f));
        $$3.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset(-5.0f, 2.0f + p_170683_, 0.0f));
        $$3.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset(5.0f, 2.0f + p_170683_, 0.0f));
        $$3.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset(-1.9f, 12.0f + p_170683_, 0.0f));
        $$3.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset(1.9f, 12.0f + p_170683_, 0.0f));
        return $$2;
    }

    @Override
    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    @Override
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.hat);
    }

    @Override
    public void prepareMobModel(T p_102861_, float p_102862_, float p_102863_, float p_102864_) {
        this.swimAmount = ((LivingEntity)p_102861_).getSwimAmount(p_102864_);
        super.prepareMobModel(p_102861_, p_102862_, p_102863_, p_102864_);
    }

    @Override
    public void setupAnim(T p_102866_, float p_102867_, float p_102868_, float p_102869_, float p_102870_, float p_102871_) {
        boolean $$9;
        boolean $$6 = ((LivingEntity)p_102866_).getFallFlyingTicks() > 4;
        boolean $$7 = ((LivingEntity)p_102866_).isVisuallySwimming();
        this.head.yRot = p_102870_ * ((float)Math.PI / 180);
        this.head.xRot = $$6 ? -0.7853982f : (this.swimAmount > 0.0f ? ($$7 ? this.rotlerpRad(this.swimAmount, this.head.xRot, -0.7853982f) : this.rotlerpRad(this.swimAmount, this.head.xRot, p_102871_ * ((float)Math.PI / 180))) : p_102871_ * ((float)Math.PI / 180));
        this.body.yRot = 0.0f;
        this.rightArm.z = 0.0f;
        this.rightArm.x = -5.0f;
        this.leftArm.z = 0.0f;
        this.leftArm.x = 5.0f;
        float $$8 = 1.0f;
        if ($$6) {
            $$8 = (float)((Entity)p_102866_).getDeltaMovement().lengthSqr();
            $$8 /= 0.2f;
            $$8 *= $$8 * $$8;
        }
        if ($$8 < 1.0f) {
            $$8 = 1.0f;
        }
        this.rightArm.xRot = Mth.cos(p_102867_ * 0.6662f + (float)Math.PI) * 2.0f * p_102868_ * 0.5f / $$8;
        this.leftArm.xRot = Mth.cos(p_102867_ * 0.6662f) * 2.0f * p_102868_ * 0.5f / $$8;
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos(p_102867_ * 0.6662f) * 1.4f * p_102868_ / $$8;
        this.leftLeg.xRot = Mth.cos(p_102867_ * 0.6662f + (float)Math.PI) * 1.4f * p_102868_ / $$8;
        this.rightLeg.yRot = 0.005f;
        this.leftLeg.yRot = -0.005f;
        this.rightLeg.zRot = 0.005f;
        this.leftLeg.zRot = -0.005f;
        if (this.riding) {
            this.rightArm.xRot += -0.62831855f;
            this.leftArm.xRot += -0.62831855f;
            this.rightLeg.xRot = -1.4137167f;
            this.rightLeg.yRot = 0.31415927f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = -0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        }
        this.rightArm.yRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        boolean bl = $$9 = ((LivingEntity)p_102866_).getMainArm() == HumanoidArm.RIGHT;
        if (((LivingEntity)p_102866_).isUsingItem()) {
            boolean $$10;
            boolean bl2 = $$10 = ((LivingEntity)p_102866_).getUsedItemHand() == InteractionHand.MAIN_HAND;
            if ($$10 == $$9) {
                this.poseRightArm(p_102866_);
            } else {
                this.poseLeftArm(p_102866_);
            }
        } else {
            boolean $$11;
            boolean bl3 = $$11 = $$9 ? this.leftArmPose.isTwoHanded() : this.rightArmPose.isTwoHanded();
            if ($$9 != $$11) {
                this.poseLeftArm(p_102866_);
                this.poseRightArm(p_102866_);
            } else {
                this.poseRightArm(p_102866_);
                this.poseLeftArm(p_102866_);
            }
        }
        this.setupAttackAnimation(p_102866_, p_102869_);
        if (this.crouching) {
            this.body.xRot = 0.5f;
            this.rightArm.xRot += 0.4f;
            this.leftArm.xRot += 0.4f;
            this.rightLeg.z = 4.0f;
            this.leftLeg.z = 4.0f;
            this.rightLeg.y = 12.2f;
            this.leftLeg.y = 12.2f;
            this.head.y = 4.2f;
            this.body.y = 3.2f;
            this.leftArm.y = 5.2f;
            this.rightArm.y = 5.2f;
        } else {
            this.body.xRot = 0.0f;
            this.rightLeg.z = 0.0f;
            this.leftLeg.z = 0.0f;
            this.rightLeg.y = 12.0f;
            this.leftLeg.y = 12.0f;
            this.head.y = 0.0f;
            this.body.y = 0.0f;
            this.leftArm.y = 2.0f;
            this.rightArm.y = 2.0f;
        }
        if (this.rightArmPose != ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart(this.rightArm, p_102869_, 1.0f);
        }
        if (this.leftArmPose != ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart(this.leftArm, p_102869_, -1.0f);
        }
        if (this.swimAmount > 0.0f) {
            float $$15;
            float $$12 = p_102867_ % 26.0f;
            HumanoidArm $$13 = this.getAttackArm(p_102866_);
            float $$14 = $$13 == HumanoidArm.RIGHT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            float f = $$15 = $$13 == HumanoidArm.LEFT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            if (!((LivingEntity)p_102866_).isUsingItem()) {
                if ($$12 < 14.0f) {
                    this.leftArm.xRot = this.rotlerpRad($$15, this.leftArm.xRot, 0.0f);
                    this.rightArm.xRot = Mth.lerp($$14, this.rightArm.xRot, 0.0f);
                    this.leftArm.yRot = this.rotlerpRad($$15, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp($$14, this.rightArm.yRot, (float)Math.PI);
                    this.leftArm.zRot = this.rotlerpRad($$15, this.leftArm.zRot, (float)Math.PI + 1.8707964f * this.quadraticArmUpdate($$12) / this.quadraticArmUpdate(14.0f));
                    this.rightArm.zRot = Mth.lerp($$14, this.rightArm.zRot, (float)Math.PI - 1.8707964f * this.quadraticArmUpdate($$12) / this.quadraticArmUpdate(14.0f));
                } else if ($$12 >= 14.0f && $$12 < 22.0f) {
                    float $$16 = ($$12 - 14.0f) / 8.0f;
                    this.leftArm.xRot = this.rotlerpRad($$15, this.leftArm.xRot, 1.5707964f * $$16);
                    this.rightArm.xRot = Mth.lerp($$14, this.rightArm.xRot, 1.5707964f * $$16);
                    this.leftArm.yRot = this.rotlerpRad($$15, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp($$14, this.rightArm.yRot, (float)Math.PI);
                    this.leftArm.zRot = this.rotlerpRad($$15, this.leftArm.zRot, 5.012389f - 1.8707964f * $$16);
                    this.rightArm.zRot = Mth.lerp($$14, this.rightArm.zRot, 1.2707963f + 1.8707964f * $$16);
                } else if ($$12 >= 22.0f && $$12 < 26.0f) {
                    float $$17 = ($$12 - 22.0f) / 4.0f;
                    this.leftArm.xRot = this.rotlerpRad($$15, this.leftArm.xRot, 1.5707964f - 1.5707964f * $$17);
                    this.rightArm.xRot = Mth.lerp($$14, this.rightArm.xRot, 1.5707964f - 1.5707964f * $$17);
                    this.leftArm.yRot = this.rotlerpRad($$15, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp($$14, this.rightArm.yRot, (float)Math.PI);
                    this.leftArm.zRot = this.rotlerpRad($$15, this.leftArm.zRot, (float)Math.PI);
                    this.rightArm.zRot = Mth.lerp($$14, this.rightArm.zRot, (float)Math.PI);
                }
            }
            float $$18 = 0.3f;
            float $$19 = 0.33333334f;
            this.leftLeg.xRot = Mth.lerp(this.swimAmount, this.leftLeg.xRot, 0.3f * Mth.cos(p_102867_ * 0.33333334f + (float)Math.PI));
            this.rightLeg.xRot = Mth.lerp(this.swimAmount, this.rightLeg.xRot, 0.3f * Mth.cos(p_102867_ * 0.33333334f));
        }
        this.hat.copyFrom(this.head);
    }

    private void poseRightArm(T p_102876_) {
        switch (this.rightArmPose.ordinal()) {
            case 0: {
                this.rightArm.yRot = 0.0f;
                break;
            }
            case 2: {
                this.poseBlockingArm(this.rightArm, true);
                break;
            }
            case 1: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.31415927f;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case 4: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - (float)Math.PI;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case 3: {
                this.rightArm.yRot = -0.1f + this.head.yRot;
                this.leftArm.yRot = 0.1f + this.head.yRot + 0.4f;
                this.rightArm.xRot = -1.5707964f + this.head.xRot;
                this.leftArm.xRot = -1.5707964f + this.head.xRot;
                break;
            }
            case 5: {
                AnimationUtils.animateCrossbowCharge(this.rightArm, this.leftArm, p_102876_, true);
                break;
            }
            case 6: {
                AnimationUtils.animateCrossbowHold(this.rightArm, this.leftArm, this.head, true);
                break;
            }
            case 9: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.62831855f;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case 7: {
                this.rightArm.xRot = Mth.clamp(this.head.xRot - 1.9198622f - (((Entity)p_102876_).isCrouching() ? 0.2617994f : 0.0f), -2.4f, 3.3f);
                this.rightArm.yRot = this.head.yRot - 0.2617994f;
                break;
            }
            case 8: {
                this.rightArm.xRot = Mth.clamp(this.head.xRot, -1.2f, 1.2f) - 1.4835298f;
                this.rightArm.yRot = this.head.yRot - 0.5235988f;
            }
        }
    }

    private void poseLeftArm(T p_102879_) {
        switch (this.leftArmPose.ordinal()) {
            case 0: {
                this.leftArm.yRot = 0.0f;
                break;
            }
            case 2: {
                this.poseBlockingArm(this.leftArm, false);
                break;
            }
            case 1: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.31415927f;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case 4: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - (float)Math.PI;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case 3: {
                this.rightArm.yRot = -0.1f + this.head.yRot - 0.4f;
                this.leftArm.yRot = 0.1f + this.head.yRot;
                this.rightArm.xRot = -1.5707964f + this.head.xRot;
                this.leftArm.xRot = -1.5707964f + this.head.xRot;
                break;
            }
            case 5: {
                AnimationUtils.animateCrossbowCharge(this.rightArm, this.leftArm, p_102879_, false);
                break;
            }
            case 6: {
                AnimationUtils.animateCrossbowHold(this.rightArm, this.leftArm, this.head, false);
                break;
            }
            case 9: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.62831855f;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case 7: {
                this.leftArm.xRot = Mth.clamp(this.head.xRot - 1.9198622f - (((Entity)p_102879_).isCrouching() ? 0.2617994f : 0.0f), -2.4f, 3.3f);
                this.leftArm.yRot = this.head.yRot + 0.2617994f;
                break;
            }
            case 8: {
                this.leftArm.xRot = Mth.clamp(this.head.xRot, -1.2f, 1.2f) - 1.4835298f;
                this.leftArm.yRot = this.head.yRot + 0.5235988f;
            }
        }
    }

    private void poseBlockingArm(ModelPart p_304530_, boolean p_304416_) {
        p_304530_.xRot = p_304530_.xRot * 0.5f - 0.9424779f + Mth.clamp(this.head.xRot, -1.3962634f, 0.43633232f);
        p_304530_.yRot = (p_304416_ ? -30.0f : 30.0f) * ((float)Math.PI / 180) + Mth.clamp(this.head.yRot, -0.5235988f, 0.5235988f);
    }

    protected void setupAttackAnimation(T p_102858_, float p_102859_) {
        if (this.attackTime <= 0.0f) {
            return;
        }
        HumanoidArm $$2 = this.getAttackArm(p_102858_);
        ModelPart $$3 = this.getArm($$2);
        float $$4 = this.attackTime;
        this.body.yRot = Mth.sin(Mth.sqrt($$4) * ((float)Math.PI * 2)) * 0.2f;
        if ($$2 == HumanoidArm.LEFT) {
            this.body.yRot *= -1.0f;
        }
        this.rightArm.z = Mth.sin(this.body.yRot) * 5.0f;
        this.rightArm.x = -Mth.cos(this.body.yRot) * 5.0f;
        this.leftArm.z = -Mth.sin(this.body.yRot) * 5.0f;
        this.leftArm.x = Mth.cos(this.body.yRot) * 5.0f;
        this.rightArm.yRot += this.body.yRot;
        this.leftArm.yRot += this.body.yRot;
        this.leftArm.xRot += this.body.yRot;
        $$4 = 1.0f - this.attackTime;
        $$4 *= $$4;
        $$4 *= $$4;
        $$4 = 1.0f - $$4;
        float $$5 = Mth.sin($$4 * (float)Math.PI);
        float $$6 = Mth.sin(this.attackTime * (float)Math.PI) * -(this.head.xRot - 0.7f) * 0.75f;
        $$3.xRot -= $$5 * 1.2f + $$6;
        $$3.yRot += this.body.yRot * 2.0f;
        $$3.zRot += Mth.sin(this.attackTime * (float)Math.PI) * -0.4f;
    }

    protected float rotlerpRad(float p_102836_, float p_102837_, float p_102838_) {
        float $$3 = (p_102838_ - p_102837_) % ((float)Math.PI * 2);
        if ($$3 < (float)(-Math.PI)) {
            $$3 += (float)Math.PI * 2;
        }
        if ($$3 >= (float)Math.PI) {
            $$3 -= (float)Math.PI * 2;
        }
        return p_102837_ + p_102836_ * $$3;
    }

    private float quadraticArmUpdate(float p_102834_) {
        return -65.0f * p_102834_ + p_102834_ * p_102834_;
    }

    @Override
    public void copyPropertiesTo(HumanoidModel<T> p_102873_) {
        super.copyPropertiesTo(p_102873_);
        p_102873_.leftArmPose = this.leftArmPose;
        p_102873_.rightArmPose = this.rightArmPose;
        p_102873_.crouching = this.crouching;
        p_102873_.head.copyFrom(this.head);
        p_102873_.hat.copyFrom(this.hat);
        p_102873_.body.copyFrom(this.body);
        p_102873_.rightArm.copyFrom(this.rightArm);
        p_102873_.leftArm.copyFrom(this.leftArm);
        p_102873_.rightLeg.copyFrom(this.rightLeg);
        p_102873_.leftLeg.copyFrom(this.leftLeg);
    }

    public void setAllVisible(boolean p_102880_) {
        this.head.visible = p_102880_;
        this.hat.visible = p_102880_;
        this.body.visible = p_102880_;
        this.rightArm.visible = p_102880_;
        this.leftArm.visible = p_102880_;
        this.rightLeg.visible = p_102880_;
        this.leftLeg.visible = p_102880_;
    }

    @Override
    public void translateToHand(HumanoidArm p_102854_, PoseStack p_102855_) {
        this.getArm(p_102854_).translateAndRotate(p_102855_);
    }

    protected ModelPart getArm(HumanoidArm p_102852_) {
        if (p_102852_ == HumanoidArm.LEFT) {
            return this.leftArm;
        }
        return this.rightArm;
    }

    @Override
    public ModelPart getHead() {
        return this.head;
    }

    private HumanoidArm getAttackArm(T p_102857_) {
        HumanoidArm $$1 = ((LivingEntity)p_102857_).getMainArm();
        return ((LivingEntity)p_102857_).swingingArm == InteractionHand.MAIN_HAND ? $$1 : $$1.getOpposite();
    }

    public static enum ArmPose {
        EMPTY(false),
        ITEM(false),
        BLOCK(false),
        BOW_AND_ARROW(true),
        THROW_SPEAR(false),
        CROSSBOW_CHARGE(true),
        CROSSBOW_HOLD(true),
        SPYGLASS(false),
        TOOT_HORN(false),
        BRUSH(false);

        private final boolean twoHanded;

        private ArmPose(boolean p_102896_) {
            this.twoHanded = p_102896_;
        }

        public boolean isTwoHanded() {
            return this.twoHanded;
        }
    }
}

