/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.mojang.math.Transformation;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockMath;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class FaceBakery {
    public static final int VERTEX_INT_SIZE = 8;
    private static final float RESCALE_22_5 = 1.0f / (float)Math.cos(0.3926991f) - 1.0f;
    private static final float RESCALE_45 = 1.0f / (float)Math.cos(0.7853981852531433) - 1.0f;
    public static final int VERTEX_COUNT = 4;
    private static final int COLOR_INDEX = 3;
    public static final int UV_INDEX = 4;

    public BakedQuad bakeQuad(Vector3f p_253895_, Vector3f p_253976_, BlockElementFace p_111603_, TextureAtlasSprite p_111604_, Direction p_111605_, ModelState p_111606_, @Nullable BlockElementRotation p_111607_, boolean p_111608_) {
        BlockFaceUV $$8 = p_111603_.uv();
        if (p_111606_.isUvLocked()) {
            $$8 = FaceBakery.recomputeUVs(p_111603_.uv(), p_111605_, p_111606_.getRotation());
        }
        float[] $$9 = new float[$$8.uvs.length];
        System.arraycopy($$8.uvs, 0, $$9, 0, $$9.length);
        float $$10 = p_111604_.uvShrinkRatio();
        float $$11 = ($$8.uvs[0] + $$8.uvs[0] + $$8.uvs[2] + $$8.uvs[2]) / 4.0f;
        float $$12 = ($$8.uvs[1] + $$8.uvs[1] + $$8.uvs[3] + $$8.uvs[3]) / 4.0f;
        $$8.uvs[0] = Mth.lerp($$10, $$8.uvs[0], $$11);
        $$8.uvs[2] = Mth.lerp($$10, $$8.uvs[2], $$11);
        $$8.uvs[1] = Mth.lerp($$10, $$8.uvs[1], $$12);
        $$8.uvs[3] = Mth.lerp($$10, $$8.uvs[3], $$12);
        int[] $$13 = this.makeVertices($$8, p_111604_, p_111605_, this.setupShape(p_253895_, p_253976_), p_111606_.getRotation(), p_111607_, p_111608_);
        Direction $$14 = FaceBakery.calculateFacing($$13);
        System.arraycopy($$9, 0, $$8.uvs, 0, $$9.length);
        if (p_111607_ == null) {
            this.recalculateWinding($$13, $$14);
        }
        return new BakedQuad($$13, p_111603_.tintIndex(), $$14, p_111604_, p_111608_);
    }

    public static BlockFaceUV recomputeUVs(BlockFaceUV p_111582_, Direction p_111583_, Transformation p_111584_) {
        float $$21;
        float $$20;
        float $$17;
        float $$16;
        Matrix4f $$3 = BlockMath.getUVLockTransform(p_111584_, p_111583_).getMatrix();
        float $$4 = p_111582_.getU(p_111582_.getReverseIndex(0));
        float $$5 = p_111582_.getV(p_111582_.getReverseIndex(0));
        Vector4f $$6 = $$3.transform(new Vector4f($$4 / 16.0f, $$5 / 16.0f, 0.0f, 1.0f));
        float $$7 = 16.0f * $$6.x();
        float $$8 = 16.0f * $$6.y();
        float $$9 = p_111582_.getU(p_111582_.getReverseIndex(2));
        float $$10 = p_111582_.getV(p_111582_.getReverseIndex(2));
        Vector4f $$11 = $$3.transform(new Vector4f($$9 / 16.0f, $$10 / 16.0f, 0.0f, 1.0f));
        float $$12 = 16.0f * $$11.x();
        float $$13 = 16.0f * $$11.y();
        if (Math.signum($$9 - $$4) == Math.signum($$12 - $$7)) {
            float $$14 = $$7;
            float $$15 = $$12;
        } else {
            $$16 = $$12;
            $$17 = $$7;
        }
        if (Math.signum($$10 - $$5) == Math.signum($$13 - $$8)) {
            float $$18 = $$8;
            float $$19 = $$13;
        } else {
            $$20 = $$13;
            $$21 = $$8;
        }
        float $$22 = (float)Math.toRadians(p_111582_.rotation);
        Matrix3f $$23 = new Matrix3f((Matrix4fc)$$3);
        Vector3f $$24 = $$23.transform(new Vector3f(Mth.cos($$22), Mth.sin($$22), 0.0f));
        int $$25 = Math.floorMod(-((int)Math.round(Math.toDegrees(Math.atan2($$24.y(), $$24.x())) / 90.0)) * 90, 360);
        return new BlockFaceUV(new float[]{$$16, $$20, $$17, $$21}, $$25);
    }

    private int[] makeVertices(BlockFaceUV p_111574_, TextureAtlasSprite p_111575_, Direction p_111576_, float[] p_111577_, Transformation p_111578_, @Nullable BlockElementRotation p_111579_, boolean p_111580_) {
        int[] $$7 = new int[32];
        for (int $$8 = 0; $$8 < 4; ++$$8) {
            this.bakeVertex($$7, $$8, p_111576_, p_111574_, p_111577_, p_111575_, p_111578_, p_111579_, p_111580_);
        }
        return $$7;
    }

    private float[] setupShape(Vector3f p_254153_, Vector3f p_253934_) {
        float[] $$2 = new float[Direction.values().length];
        $$2[FaceInfo.Constants.MIN_X] = p_254153_.x() / 16.0f;
        $$2[FaceInfo.Constants.MIN_Y] = p_254153_.y() / 16.0f;
        $$2[FaceInfo.Constants.MIN_Z] = p_254153_.z() / 16.0f;
        $$2[FaceInfo.Constants.MAX_X] = p_253934_.x() / 16.0f;
        $$2[FaceInfo.Constants.MAX_Y] = p_253934_.y() / 16.0f;
        $$2[FaceInfo.Constants.MAX_Z] = p_253934_.z() / 16.0f;
        return $$2;
    }

    private void bakeVertex(int[] p_111621_, int p_111622_, Direction p_111623_, BlockFaceUV p_111624_, float[] p_111625_, TextureAtlasSprite p_111626_, Transformation p_111627_, @Nullable BlockElementRotation p_111628_, boolean p_111629_) {
        FaceInfo.VertexInfo $$9 = FaceInfo.fromFacing(p_111623_).getVertexInfo(p_111622_);
        Vector3f $$10 = new Vector3f(p_111625_[$$9.xFace], p_111625_[$$9.yFace], p_111625_[$$9.zFace]);
        this.applyElementRotation($$10, p_111628_);
        this.applyModelRotation($$10, p_111627_);
        this.fillVertex(p_111621_, p_111622_, $$10, p_111626_, p_111624_);
    }

    private void fillVertex(int[] p_111615_, int p_111616_, Vector3f p_254291_, TextureAtlasSprite p_111618_, BlockFaceUV p_111619_) {
        int $$5 = p_111616_ * 8;
        p_111615_[$$5] = Float.floatToRawIntBits(p_254291_.x());
        p_111615_[$$5 + 1] = Float.floatToRawIntBits(p_254291_.y());
        p_111615_[$$5 + 2] = Float.floatToRawIntBits(p_254291_.z());
        p_111615_[$$5 + 3] = -1;
        p_111615_[$$5 + 4] = Float.floatToRawIntBits(p_111618_.getU(p_111619_.getU(p_111616_) / 16.0f));
        p_111615_[$$5 + 4 + 1] = Float.floatToRawIntBits(p_111618_.getV(p_111619_.getV(p_111616_) / 16.0f));
    }

    /*
     * WARNING - void declaration
     */
    private void applyElementRotation(Vector3f p_254412_, @Nullable BlockElementRotation p_254150_) {
        void $$9;
        void $$8;
        if (p_254150_ == null) {
            return;
        }
        switch (p_254150_.axis()) {
            case X: {
                Vector3f $$2 = new Vector3f(1.0f, 0.0f, 0.0f);
                Vector3f $$3 = new Vector3f(0.0f, 1.0f, 1.0f);
                break;
            }
            case Y: {
                Vector3f $$4 = new Vector3f(0.0f, 1.0f, 0.0f);
                Vector3f $$5 = new Vector3f(1.0f, 0.0f, 1.0f);
                break;
            }
            case Z: {
                Vector3f $$6 = new Vector3f(0.0f, 0.0f, 1.0f);
                Vector3f $$7 = new Vector3f(1.0f, 1.0f, 0.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("There are only 3 axes");
            }
        }
        Quaternionf $$10 = new Quaternionf().rotationAxis(p_254150_.angle() * ((float)Math.PI / 180), (Vector3fc)$$8);
        if (p_254150_.rescale()) {
            if (Math.abs(p_254150_.angle()) == 22.5f) {
                $$9.mul(RESCALE_22_5);
            } else {
                $$9.mul(RESCALE_45);
            }
            $$9.add(1.0f, 1.0f, 1.0f);
        } else {
            $$9.set(1.0f, 1.0f, 1.0f);
        }
        this.rotateVertexBy(p_254412_, new Vector3f((Vector3fc)p_254150_.origin()), new Matrix4f().rotation((Quaternionfc)$$10), (Vector3f)$$9);
    }

    public void applyModelRotation(Vector3f p_254561_, Transformation p_253793_) {
        if (p_253793_ == Transformation.identity()) {
            return;
        }
        this.rotateVertexBy(p_254561_, new Vector3f(0.5f, 0.5f, 0.5f), p_253793_.getMatrix(), new Vector3f(1.0f, 1.0f, 1.0f));
    }

    private void rotateVertexBy(Vector3f p_253804_, Vector3f p_253835_, Matrix4f p_253730_, Vector3f p_254056_) {
        Vector4f $$4 = p_253730_.transform(new Vector4f(p_253804_.x() - p_253835_.x(), p_253804_.y() - p_253835_.y(), p_253804_.z() - p_253835_.z(), 1.0f));
        $$4.mul((Vector4fc)new Vector4f((Vector3fc)p_254056_, 1.0f));
        p_253804_.set($$4.x() + p_253835_.x(), $$4.y() + p_253835_.y(), $$4.z() + p_253835_.z());
    }

    public static Direction calculateFacing(int[] p_111613_) {
        Vector3f $$1 = new Vector3f(Float.intBitsToFloat(p_111613_[0]), Float.intBitsToFloat(p_111613_[1]), Float.intBitsToFloat(p_111613_[2]));
        Vector3f $$2 = new Vector3f(Float.intBitsToFloat(p_111613_[8]), Float.intBitsToFloat(p_111613_[9]), Float.intBitsToFloat(p_111613_[10]));
        Vector3f $$3 = new Vector3f(Float.intBitsToFloat(p_111613_[16]), Float.intBitsToFloat(p_111613_[17]), Float.intBitsToFloat(p_111613_[18]));
        Vector3f $$4 = new Vector3f((Vector3fc)$$1).sub((Vector3fc)$$2);
        Vector3f $$5 = new Vector3f((Vector3fc)$$3).sub((Vector3fc)$$2);
        Vector3f $$6 = new Vector3f((Vector3fc)$$5).cross((Vector3fc)$$4).normalize();
        if (!$$6.isFinite()) {
            return Direction.UP;
        }
        Direction $$7 = null;
        float $$8 = 0.0f;
        for (Direction $$9 : Direction.values()) {
            Vec3i $$10 = $$9.getNormal();
            Vector3f $$11 = new Vector3f((float)$$10.getX(), (float)$$10.getY(), (float)$$10.getZ());
            float $$12 = $$6.dot((Vector3fc)$$11);
            if (!($$12 >= 0.0f) || !($$12 > $$8)) continue;
            $$8 = $$12;
            $$7 = $$9;
        }
        if ($$7 == null) {
            return Direction.UP;
        }
        return $$7;
    }

    private void recalculateWinding(int[] p_111631_, Direction p_111632_) {
        int[] $$2 = new int[p_111631_.length];
        System.arraycopy(p_111631_, 0, $$2, 0, p_111631_.length);
        float[] $$3 = new float[Direction.values().length];
        $$3[FaceInfo.Constants.MIN_X] = 999.0f;
        $$3[FaceInfo.Constants.MIN_Y] = 999.0f;
        $$3[FaceInfo.Constants.MIN_Z] = 999.0f;
        $$3[FaceInfo.Constants.MAX_X] = -999.0f;
        $$3[FaceInfo.Constants.MAX_Y] = -999.0f;
        $$3[FaceInfo.Constants.MAX_Z] = -999.0f;
        for (int $$4 = 0; $$4 < 4; ++$$4) {
            int $$5 = 8 * $$4;
            float $$6 = Float.intBitsToFloat($$2[$$5]);
            float $$7 = Float.intBitsToFloat($$2[$$5 + 1]);
            float $$8 = Float.intBitsToFloat($$2[$$5 + 2]);
            if ($$6 < $$3[FaceInfo.Constants.MIN_X]) {
                $$3[FaceInfo.Constants.MIN_X] = $$6;
            }
            if ($$7 < $$3[FaceInfo.Constants.MIN_Y]) {
                $$3[FaceInfo.Constants.MIN_Y] = $$7;
            }
            if ($$8 < $$3[FaceInfo.Constants.MIN_Z]) {
                $$3[FaceInfo.Constants.MIN_Z] = $$8;
            }
            if ($$6 > $$3[FaceInfo.Constants.MAX_X]) {
                $$3[FaceInfo.Constants.MAX_X] = $$6;
            }
            if ($$7 > $$3[FaceInfo.Constants.MAX_Y]) {
                $$3[FaceInfo.Constants.MAX_Y] = $$7;
            }
            if (!($$8 > $$3[FaceInfo.Constants.MAX_Z])) continue;
            $$3[FaceInfo.Constants.MAX_Z] = $$8;
        }
        FaceInfo $$9 = FaceInfo.fromFacing(p_111632_);
        for (int $$10 = 0; $$10 < 4; ++$$10) {
            int $$11 = 8 * $$10;
            FaceInfo.VertexInfo $$12 = $$9.getVertexInfo($$10);
            float $$13 = $$3[$$12.xFace];
            float $$14 = $$3[$$12.yFace];
            float $$15 = $$3[$$12.zFace];
            p_111631_[$$11] = Float.floatToRawIntBits($$13);
            p_111631_[$$11 + 1] = Float.floatToRawIntBits($$14);
            p_111631_[$$11 + 2] = Float.floatToRawIntBits($$15);
            for (int $$16 = 0; $$16 < 4; ++$$16) {
                int $$17 = 8 * $$16;
                float $$18 = Float.intBitsToFloat($$2[$$17]);
                float $$19 = Float.intBitsToFloat($$2[$$17 + 1]);
                float $$20 = Float.intBitsToFloat($$2[$$17 + 2]);
                if (!Mth.equal($$13, $$18) || !Mth.equal($$14, $$19) || !Mth.equal($$15, $$20)) continue;
                p_111631_[$$11 + 4] = $$2[$$17 + 4];
                p_111631_[$$11 + 4 + 1] = $$2[$$17 + 4 + 1];
            }
        }
    }
}

