/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;

public class PathfindingRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private final Map<Integer, Path> pathMap = Maps.newHashMap();
    private final Map<Integer, Float> pathMaxDist = Maps.newHashMap();
    private final Map<Integer, Long> creationMap = Maps.newHashMap();
    private static final long TIMEOUT = 5000L;
    private static final float MAX_RENDER_DIST = 80.0f;
    private static final boolean SHOW_OPEN_CLOSED = true;
    private static final boolean SHOW_OPEN_CLOSED_COST_MALUS = false;
    private static final boolean SHOW_OPEN_CLOSED_NODE_TYPE_WITH_TEXT = false;
    private static final boolean SHOW_OPEN_CLOSED_NODE_TYPE_WITH_BOX = true;
    private static final boolean SHOW_GROUND_LABELS = true;
    private static final float TEXT_SCALE = 0.02f;

    public void addPath(int p_113612_, Path p_113613_, float p_113614_) {
        this.pathMap.put(p_113612_, p_113613_);
        this.creationMap.put(p_113612_, Util.getMillis());
        this.pathMaxDist.put(p_113612_, Float.valueOf(p_113614_));
    }

    @Override
    public void render(PoseStack p_113629_, MultiBufferSource p_113630_, double p_113631_, double p_113632_, double p_113633_) {
        if (this.pathMap.isEmpty()) {
            return;
        }
        long $$5 = Util.getMillis();
        for (Integer $$6 : this.pathMap.keySet()) {
            Path $$7 = this.pathMap.get($$6);
            float $$8 = this.pathMaxDist.get($$6).floatValue();
            PathfindingRenderer.renderPath(p_113629_, p_113630_, $$7, $$8, true, true, p_113631_, p_113632_, p_113633_);
        }
        for (Integer $$9 : this.creationMap.keySet().toArray(new Integer[0])) {
            if ($$5 - this.creationMap.get($$9) <= 5000L) continue;
            this.pathMap.remove($$9);
            this.creationMap.remove($$9);
        }
    }

    public static void renderPath(PoseStack p_270399_, MultiBufferSource p_270359_, Path p_270189_, float p_270841_, boolean p_270481_, boolean p_270748_, double p_270187_, double p_270252_, double p_270371_) {
        PathfindingRenderer.renderPathLine(p_270399_, p_270359_.getBuffer(RenderType.debugLineStrip(6.0)), p_270189_, p_270187_, p_270252_, p_270371_);
        BlockPos $$9 = p_270189_.getTarget();
        if (PathfindingRenderer.distanceToCamera($$9, p_270187_, p_270252_, p_270371_) <= 80.0f) {
            DebugRenderer.renderFilledBox(p_270399_, p_270359_, new AABB((float)$$9.getX() + 0.25f, (float)$$9.getY() + 0.25f, (double)$$9.getZ() + 0.25, (float)$$9.getX() + 0.75f, (float)$$9.getY() + 0.75f, (float)$$9.getZ() + 0.75f).move(-p_270187_, -p_270252_, -p_270371_), 0.0f, 1.0f, 0.0f, 0.5f);
            for (int $$10 = 0; $$10 < p_270189_.getNodeCount(); ++$$10) {
                Node $$11 = p_270189_.getNode($$10);
                if (!(PathfindingRenderer.distanceToCamera($$11.asBlockPos(), p_270187_, p_270252_, p_270371_) <= 80.0f)) continue;
                float $$12 = $$10 == p_270189_.getNextNodeIndex() ? 1.0f : 0.0f;
                float $$13 = $$10 == p_270189_.getNextNodeIndex() ? 0.0f : 1.0f;
                DebugRenderer.renderFilledBox(p_270399_, p_270359_, new AABB((float)$$11.x + 0.5f - p_270841_, (float)$$11.y + 0.01f * (float)$$10, (float)$$11.z + 0.5f - p_270841_, (float)$$11.x + 0.5f + p_270841_, (float)$$11.y + 0.25f + 0.01f * (float)$$10, (float)$$11.z + 0.5f + p_270841_).move(-p_270187_, -p_270252_, -p_270371_), $$12, 0.0f, $$13, 0.5f);
            }
        }
        Path.DebugData $$14 = p_270189_.debugData();
        if (p_270481_ && $$14 != null) {
            for (Node $$15 : $$14.closedSet()) {
                if (!(PathfindingRenderer.distanceToCamera($$15.asBlockPos(), p_270187_, p_270252_, p_270371_) <= 80.0f)) continue;
                DebugRenderer.renderFilledBox(p_270399_, p_270359_, new AABB((float)$$15.x + 0.5f - p_270841_ / 2.0f, (float)$$15.y + 0.01f, (float)$$15.z + 0.5f - p_270841_ / 2.0f, (float)$$15.x + 0.5f + p_270841_ / 2.0f, (double)$$15.y + 0.1, (float)$$15.z + 0.5f + p_270841_ / 2.0f).move(-p_270187_, -p_270252_, -p_270371_), 1.0f, 0.8f, 0.8f, 0.5f);
            }
            for (Node $$16 : $$14.openSet()) {
                if (!(PathfindingRenderer.distanceToCamera($$16.asBlockPos(), p_270187_, p_270252_, p_270371_) <= 80.0f)) continue;
                DebugRenderer.renderFilledBox(p_270399_, p_270359_, new AABB((float)$$16.x + 0.5f - p_270841_ / 2.0f, (float)$$16.y + 0.01f, (float)$$16.z + 0.5f - p_270841_ / 2.0f, (float)$$16.x + 0.5f + p_270841_ / 2.0f, (double)$$16.y + 0.1, (float)$$16.z + 0.5f + p_270841_ / 2.0f).move(-p_270187_, -p_270252_, -p_270371_), 0.8f, 1.0f, 1.0f, 0.5f);
            }
        }
        if (p_270748_) {
            for (int $$17 = 0; $$17 < p_270189_.getNodeCount(); ++$$17) {
                Node $$18 = p_270189_.getNode($$17);
                if (!(PathfindingRenderer.distanceToCamera($$18.asBlockPos(), p_270187_, p_270252_, p_270371_) <= 80.0f)) continue;
                DebugRenderer.renderFloatingText(p_270399_, p_270359_, String.valueOf((Object)$$18.type), (double)$$18.x + 0.5, (double)$$18.y + 0.75, (double)$$18.z + 0.5, -1, 0.02f, true, 0.0f, true);
                DebugRenderer.renderFloatingText(p_270399_, p_270359_, String.format(Locale.ROOT, "%.2f", Float.valueOf($$18.costMalus)), (double)$$18.x + 0.5, (double)$$18.y + 0.25, (double)$$18.z + 0.5, -1, 0.02f, true, 0.0f, true);
            }
        }
    }

    public static void renderPathLine(PoseStack p_270666_, VertexConsumer p_270602_, Path p_270511_, double p_270524_, double p_270163_, double p_270176_) {
        for (int $$6 = 0; $$6 < p_270511_.getNodeCount(); ++$$6) {
            Node $$7 = p_270511_.getNode($$6);
            if (PathfindingRenderer.distanceToCamera($$7.asBlockPos(), p_270524_, p_270163_, p_270176_) > 80.0f) continue;
            float $$8 = (float)$$6 / (float)p_270511_.getNodeCount() * 0.33f;
            int $$9 = $$6 == 0 ? 0 : Mth.hsvToRgb($$8, 0.9f, 0.9f);
            int $$10 = $$9 >> 16 & 0xFF;
            int $$11 = $$9 >> 8 & 0xFF;
            int $$12 = $$9 & 0xFF;
            p_270602_.addVertex(p_270666_.last(), (float)((double)$$7.x - p_270524_ + 0.5), (float)((double)$$7.y - p_270163_ + 0.5), (float)((double)$$7.z - p_270176_ + 0.5)).setColor($$10, $$11, $$12, 255);
        }
    }

    private static float distanceToCamera(BlockPos p_113635_, double p_113636_, double p_113637_, double p_113638_) {
        return (float)(Math.abs((double)p_113635_.getX() - p_113636_) + Math.abs((double)p_113635_.getY() - p_113637_) + Math.abs((double)p_113635_.getZ() - p_113638_));
    }
}

