/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class SelectorContents
implements ComponentContents {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<SelectorContents> CODEC = RecordCodecBuilder.mapCodec(p_337511_ -> p_337511_.group((App)Codec.STRING.fieldOf("selector").forGetter(SelectorContents::getPattern), (App)ComponentSerialization.CODEC.optionalFieldOf("separator").forGetter(SelectorContents::getSeparator)).apply((Applicative)p_337511_, SelectorContents::new));
    public static final ComponentContents.Type<SelectorContents> TYPE = new ComponentContents.Type<SelectorContents>(CODEC, "selector");
    private final String pattern;
    @Nullable
    private final EntitySelector selector;
    protected final Optional<Component> separator;

    public SelectorContents(String p_237464_, Optional<Component> p_237465_) {
        this.pattern = p_237464_;
        this.separator = p_237465_;
        this.selector = SelectorContents.parseSelector(p_237464_);
    }

    @Nullable
    private static EntitySelector parseSelector(String p_237472_) {
        EntitySelector $$1 = null;
        try {
            EntitySelectorParser $$2 = new EntitySelectorParser(new StringReader(p_237472_), true);
            $$1 = $$2.parse();
        }
        catch (CommandSyntaxException $$3) {
            LOGGER.warn("Invalid selector component: {}: {}", (Object)p_237472_, (Object)$$3.getMessage());
        }
        return $$1;
    }

    @Override
    public ComponentContents.Type<?> type() {
        return TYPE;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Nullable
    public EntitySelector getSelector() {
        return this.selector;
    }

    public Optional<Component> getSeparator() {
        return this.separator;
    }

    @Override
    public MutableComponent resolve(@Nullable CommandSourceStack p_237468_, @Nullable Entity p_237469_, int p_237470_) throws CommandSyntaxException {
        if (p_237468_ == null || this.selector == null) {
            return Component.empty();
        }
        Optional<MutableComponent> $$3 = ComponentUtils.updateForEntity(p_237468_, this.separator, p_237469_, p_237470_);
        return ComponentUtils.formatList(this.selector.findEntities(p_237468_), $$3, Entity::getDisplayName);
    }

    @Override
    public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> p_237476_, Style p_237477_) {
        return p_237476_.accept(p_237477_, this.pattern);
    }

    @Override
    public <T> Optional<T> visit(FormattedText.ContentConsumer<T> p_237474_) {
        return p_237474_.accept(this.pattern);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_237481_) {
        if (this == p_237481_) {
            return true;
        }
        if (!(p_237481_ instanceof SelectorContents)) return false;
        SelectorContents $$1 = (SelectorContents)p_237481_;
        if (!this.pattern.equals($$1.pattern)) return false;
        if (!this.separator.equals($$1.separator)) return false;
        return true;
    }

    public int hashCode() {
        int $$0 = this.pattern.hashCode();
        $$0 = 31 * $$0 + this.separator.hashCode();
        return $$0;
    }

    public String toString() {
        return "pattern{" + this.pattern + "}";
    }
}

