/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public abstract class VehicleEntity
extends Entity {
    protected static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.defineId(VehicleEntity.class, EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.defineId(VehicleEntity.class, EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.defineId(VehicleEntity.class, EntityDataSerializers.FLOAT);

    public VehicleEntity(EntityType<?> p_306130_, Level p_306167_) {
        super(p_306130_, p_306167_);
    }

    @Override
    public boolean hurt(DamageSource p_305898_, float p_305999_) {
        boolean $$2;
        if (this.level().isClientSide || this.isRemoved()) {
            return true;
        }
        if (this.isInvulnerableTo(p_305898_)) {
            return false;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.markHurt();
        this.setDamage(this.getDamage() + p_305999_ * 10.0f);
        this.gameEvent(GameEvent.ENTITY_DAMAGE, p_305898_.getEntity());
        boolean bl = $$2 = p_305898_.getEntity() instanceof Player && ((Player)p_305898_.getEntity()).getAbilities().instabuild;
        if (!$$2 && this.getDamage() > 40.0f || this.shouldSourceDestroy(p_305898_)) {
            this.destroy(p_305898_);
        } else if ($$2) {
            this.discard();
        }
        return true;
    }

    boolean shouldSourceDestroy(DamageSource p_312875_) {
        return false;
    }

    public void destroy(Item p_306235_) {
        this.kill();
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            return;
        }
        ItemStack $$1 = new ItemStack(p_306235_);
        $$1.set(DataComponents.CUSTOM_NAME, this.getCustomName());
        this.spawnAtLocation($$1);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326046_) {
        p_326046_.define(DATA_ID_HURT, 0);
        p_326046_.define(DATA_ID_HURTDIR, 1);
        p_326046_.define(DATA_ID_DAMAGE, Float.valueOf(0.0f));
    }

    public void setHurtTime(int p_306126_) {
        this.entityData.set(DATA_ID_HURT, p_306126_);
    }

    public void setHurtDir(int p_306138_) {
        this.entityData.set(DATA_ID_HURTDIR, p_306138_);
    }

    public void setDamage(float p_306297_) {
        this.entityData.set(DATA_ID_DAMAGE, Float.valueOf(p_306297_));
    }

    public float getDamage() {
        return this.entityData.get(DATA_ID_DAMAGE).floatValue();
    }

    public int getHurtTime() {
        return this.entityData.get(DATA_ID_HURT);
    }

    public int getHurtDir() {
        return this.entityData.get(DATA_ID_HURTDIR);
    }

    protected void destroy(DamageSource p_306223_) {
        this.destroy(this.getDropItem());
    }

    abstract Item getDropItem();
}

