/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;

public class BundleItem
extends Item {
    private static final int BAR_COLOR = Mth.color(0.4f, 0.4f, 1.0f);
    private static final int TOOLTIP_MAX_WEIGHT = 64;

    public BundleItem(Item.Properties p_150726_) {
        super(p_150726_);
    }

    public static float getFullnessDisplay(ItemStack p_150767_) {
        BundleContents $$1 = p_150767_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return $$1.weight().floatValue();
    }

    @Override
    public boolean overrideStackedOnOther(ItemStack p_150733_, Slot p_150734_, ClickAction p_150735_, Player p_150736_) {
        int $$9;
        if (p_150735_ != ClickAction.SECONDARY) {
            return false;
        }
        BundleContents $$4 = p_150733_.get(DataComponents.BUNDLE_CONTENTS);
        if ($$4 == null) {
            return false;
        }
        ItemStack $$5 = p_150734_.getItem();
        BundleContents.Mutable $$6 = new BundleContents.Mutable($$4);
        if ($$5.isEmpty()) {
            this.playRemoveOneSound(p_150736_);
            ItemStack $$7 = $$6.removeOne();
            if ($$7 != null) {
                ItemStack $$8 = p_150734_.safeInsert($$7);
                $$6.tryInsert($$8);
            }
        } else if ($$5.getItem().canFitInsideContainerItems() && ($$9 = $$6.tryTransfer(p_150734_, p_150736_)) > 0) {
            this.playInsertSound(p_150736_);
        }
        p_150733_.set(DataComponents.BUNDLE_CONTENTS, $$6.toImmutable());
        return true;
    }

    @Override
    public boolean overrideOtherStackedOnMe(ItemStack p_150742_, ItemStack p_150743_, Slot p_150744_, ClickAction p_150745_, Player p_150746_, SlotAccess p_150747_) {
        if (p_150745_ != ClickAction.SECONDARY || !p_150744_.allowModification(p_150746_)) {
            return false;
        }
        BundleContents $$6 = p_150742_.get(DataComponents.BUNDLE_CONTENTS);
        if ($$6 == null) {
            return false;
        }
        BundleContents.Mutable $$7 = new BundleContents.Mutable($$6);
        if (p_150743_.isEmpty()) {
            ItemStack $$8 = $$7.removeOne();
            if ($$8 != null) {
                this.playRemoveOneSound(p_150746_);
                p_150747_.set($$8);
            }
        } else {
            int $$9 = $$7.tryInsert(p_150743_);
            if ($$9 > 0) {
                this.playInsertSound(p_150746_);
            }
        }
        p_150742_.set(DataComponents.BUNDLE_CONTENTS, $$7.toImmutable());
        return true;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level p_150760_, Player p_150761_, InteractionHand p_150762_) {
        ItemStack $$3 = p_150761_.getItemInHand(p_150762_);
        if (BundleItem.dropContents($$3, p_150761_)) {
            this.playDropContentsSound(p_150761_);
            p_150761_.awardStat(Stats.ITEM_USED.get(this));
            return InteractionResultHolder.sidedSuccess($$3, p_150760_.isClientSide());
        }
        return InteractionResultHolder.fail($$3);
    }

    @Override
    public boolean isBarVisible(ItemStack p_150769_) {
        BundleContents $$1 = p_150769_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return $$1.weight().compareTo(Fraction.ZERO) > 0;
    }

    @Override
    public int getBarWidth(ItemStack p_150771_) {
        BundleContents $$1 = p_150771_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return Math.min(1 + Mth.mulAndTruncate($$1.weight(), 12), 13);
    }

    @Override
    public int getBarColor(ItemStack p_150773_) {
        return BAR_COLOR;
    }

    private static boolean dropContents(ItemStack p_150730_, Player p_150731_) {
        BundleContents $$2 = p_150730_.get(DataComponents.BUNDLE_CONTENTS);
        if ($$2 == null || $$2.isEmpty()) {
            return false;
        }
        p_150730_.set(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        if (p_150731_ instanceof ServerPlayer) {
            $$2.itemsCopy().forEach(p_330078_ -> p_150731_.drop((ItemStack)p_330078_, true));
        }
        return true;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack p_150775_) {
        if (p_150775_.has(DataComponents.HIDE_TOOLTIP) || p_150775_.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            return Optional.empty();
        }
        return Optional.ofNullable(p_150775_.get(DataComponents.BUNDLE_CONTENTS)).map(BundleTooltip::new);
    }

    @Override
    public void appendHoverText(ItemStack p_150749_, Item.TooltipContext p_339687_, List<Component> p_150751_, TooltipFlag p_150752_) {
        BundleContents $$4 = p_150749_.get(DataComponents.BUNDLE_CONTENTS);
        if ($$4 != null) {
            int $$5 = Mth.mulAndTruncate($$4.weight(), 64);
            p_150751_.add(Component.translatable("item.minecraft.bundle.fullness", $$5, 64).withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    public void onDestroyed(ItemEntity p_150728_) {
        BundleContents $$1 = p_150728_.getItem().get(DataComponents.BUNDLE_CONTENTS);
        if ($$1 == null) {
            return;
        }
        p_150728_.getItem().set(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        ItemUtils.onContainerDestroyed(p_150728_, $$1.itemsCopy());
    }

    private void playRemoveOneSound(Entity p_186343_) {
        p_186343_.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + p_186343_.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity p_186352_) {
        p_186352_.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + p_186352_.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity p_186354_) {
        p_186354_.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + p_186354_.level().getRandom().nextFloat() * 0.4f);
    }
}

