/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class DimensionDataStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, SavedData> cache = Maps.newHashMap();
    private final DataFixer fixerUpper;
    private final HolderLookup.Provider registries;
    private final File dataFolder;

    public DimensionDataStorage(File p_78149_, DataFixer p_78150_, HolderLookup.Provider p_324180_) {
        this.fixerUpper = p_78150_;
        this.dataFolder = p_78149_;
        this.registries = p_324180_;
    }

    private File getDataFile(String p_78157_) {
        return new File(this.dataFolder, p_78157_ + ".dat");
    }

    public <T extends SavedData> T computeIfAbsent(SavedData.Factory<T> p_294124_, String p_164864_) {
        T $$2 = this.get(p_294124_, p_164864_);
        if ($$2 != null) {
            return $$2;
        }
        SavedData $$3 = (SavedData)p_294124_.constructor().get();
        this.set(p_164864_, $$3);
        return (T)$$3;
    }

    @Nullable
    public <T extends SavedData> T get(SavedData.Factory<T> p_295091_, String p_164860_) {
        SavedData $$2 = this.cache.get(p_164860_);
        if ($$2 == null && !this.cache.containsKey(p_164860_)) {
            $$2 = this.readSavedData(p_295091_.deserializer(), p_295091_.type(), p_164860_);
            this.cache.put(p_164860_, $$2);
        }
        return (T)$$2;
    }

    @Nullable
    private <T extends SavedData> T readSavedData(BiFunction<CompoundTag, HolderLookup.Provider, T> p_324609_, DataFixTypes p_295832_, String p_164870_) {
        try {
            File $$3 = this.getDataFile(p_164870_);
            if ($$3.exists()) {
                CompoundTag $$4 = this.readTagFromDisk(p_164870_, p_295832_, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                return (T)((SavedData)p_324609_.apply($$4.getCompound("data"), this.registries));
            }
        }
        catch (Exception $$5) {
            LOGGER.error("Error loading saved data: {}", (Object)p_164870_, (Object)$$5);
        }
        return null;
    }

    public void set(String p_164856_, SavedData p_164857_) {
        this.cache.put(p_164856_, p_164857_);
    }

    /*
     * WARNING - void declaration
     */
    public CompoundTag readTagFromDisk(String p_78159_, DataFixTypes p_295038_, int p_78160_) throws IOException {
        File $$3 = this.getDataFile(p_78159_);
        try (FileInputStream $$4 = new FileInputStream($$3);){
            CompoundTag compoundTag;
            try (PushbackInputStream $$5 = new PushbackInputStream(new FastBufferedInputStream($$4), 2);){
                void $$9;
                if (this.isGzip($$5)) {
                    CompoundTag $$6 = NbtIo.readCompressed($$5, NbtAccounter.unlimitedHeap());
                } else {
                    try (DataInputStream $$7 = new DataInputStream($$5);){
                        CompoundTag $$8 = NbtIo.read($$7);
                    }
                }
                int $$10 = NbtUtils.getDataVersion((CompoundTag)$$9, 1343);
                compoundTag = p_295038_.update(this.fixerUpper, (CompoundTag)$$9, $$10, p_78160_);
            }
            return compoundTag;
        }
    }

    private boolean isGzip(PushbackInputStream p_78155_) throws IOException {
        int $$4;
        byte[] $$1 = new byte[2];
        boolean $$2 = false;
        int $$3 = p_78155_.read($$1, 0, 2);
        if ($$3 == 2 && ($$4 = ($$1[1] & 0xFF) << 8 | $$1[0] & 0xFF) == 35615) {
            $$2 = true;
        }
        if ($$3 != 0) {
            p_78155_.unread($$1, 0, $$3);
        }
        return $$2;
    }

    public void save() {
        this.cache.forEach((p_323449_, p_323450_) -> {
            if (p_323450_ != null) {
                p_323450_.save(this.getDataFile((String)p_323449_), this.registries);
            }
        });
    }
}

