/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.earlydisplay;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryUtil;

public class SimpleBufferBuilder
implements Closeable {
    private static final MemoryUtil.MemoryAllocator ALLOCATOR = MemoryUtil.getAllocator((boolean)false);
    private static final int[] VERTEX_ARRAYS = new int[Format.values().length];
    private static final int[] VERTEX_BUFFERS = new int[Format.values().length];
    private static final int[] VERTEX_BUFFER_LENGTHS = new int[Format.values().length];
    private static int elementBuffer = 0;
    private static int elementBufferVertexLength = 0;
    private long bufferAddr;
    private ByteBuffer buffer;
    private Format format;
    private Mode mode;
    private boolean building;
    private int elementIndex;
    private int index;
    private int vertices;

    public SimpleBufferBuilder(int capacity) {
        this.bufferAddr = ALLOCATOR.malloc((long)capacity);
        this.buffer = MemoryUtil.memByteBuffer((long)this.bufferAddr, (int)capacity);
    }

    public static void destroy() {
        GL32C.glDeleteBuffers((int[])VERTEX_BUFFERS);
        GL32C.glDeleteBuffers((int)elementBuffer);
        GL32C.glDeleteVertexArrays((int[])VERTEX_ARRAYS);
    }

    private static void ensureElementBufferLength(int vertices) {
        int oldQuads;
        int newElementBufferVertexLength;
        if (elementBufferVertexLength >= vertices) {
            return;
        }
        int newElementBuffer = GL32C.glGenBuffers();
        for (newElementBufferVertexLength = Math.max(1024, elementBufferVertexLength); newElementBufferVertexLength < vertices; newElementBufferVertexLength *= 2) {
        }
        int oldIndexCount = elementBufferVertexLength + elementBufferVertexLength / 2;
        int newIndexCount = newElementBufferVertexLength + newElementBufferVertexLength / 2;
        GL32C.glBindBuffer((int)34963, (int)newElementBuffer);
        GL32C.glBufferData((int)34963, (long)((long)newIndexCount * 4L), (int)35044);
        int mappingOffset = oldIndexCount * 4;
        int mappingSize = (newIndexCount - oldIndexCount) * 4;
        ByteBuffer mappedBuffer = GL32C.glMapBufferRange((int)34963, (long)mappingOffset, (long)mappingSize, (int)42);
        if (mappedBuffer == null) {
            throw new NullPointerException("OpenGL buffer mapping failed");
        }
        int quads = newElementBufferVertexLength / 4;
        for (int i = oldQuads = elementBufferVertexLength / 4; i < quads; ++i) {
            mappedBuffer.putInt(i * 4 + 0).putInt(i * 4 + 1).putInt(i * 4 + 2);
            mappedBuffer.putInt(i * 4 + 1).putInt(i * 4 + 3).putInt(i * 4 + 2);
        }
        GL32C.glUnmapBuffer((int)34963);
        if (elementBuffer != 0) {
            GL32C.glBindBuffer((int)36662, (int)elementBuffer);
            GL32C.glCopyBufferSubData((int)36662, (int)34963, (long)0L, (long)0L, (long)mappingOffset);
            GL32C.glBindBuffer((int)36662, (int)0);
        }
        GL32C.glBindBuffer((int)34963, (int)0);
        GL32C.glDeleteBuffers((int)elementBuffer);
        elementBuffer = newElementBuffer;
        elementBufferVertexLength = newElementBufferVertexLength;
    }

    public SimpleBufferBuilder begin(Format format, Mode mode) {
        if (this.bufferAddr == 0L) {
            throw new IllegalStateException("Buffer has been freed.");
        }
        if (this.building) {
            throw new IllegalStateException("Already building.");
        }
        this.format = format;
        this.mode = mode;
        this.building = true;
        this.elementIndex = 0;
        this.ensureSpace(format.stride);
        this.buffer.rewind();
        this.buffer.limit(this.buffer.capacity());
        return this;
    }

    public SimpleBufferBuilder pos(float x, float y) {
        if (!this.building) {
            throw new IllegalStateException("Not building.");
        }
        if (this.elementIndex == this.format.types.length) {
            throw new IllegalStateException("Expected endVertex");
        }
        if (this.format.types[this.elementIndex] != Element.POS) {
            throw new IllegalArgumentException("Expected " + String.valueOf((Object)this.format.types[this.elementIndex]));
        }
        this.buffer.putFloat(this.index + 0, x);
        this.buffer.putFloat(this.index + 4, y);
        this.index += this.format.types[this.elementIndex].width;
        ++this.elementIndex;
        return this;
    }

    public SimpleBufferBuilder tex(float u, float v) {
        if (!this.building) {
            throw new IllegalStateException("Not building.");
        }
        if (this.elementIndex == this.format.types.length) {
            throw new IllegalStateException("Expected endVertex");
        }
        if (this.format.types[this.elementIndex] != Element.TEX) {
            throw new IllegalArgumentException("Expected " + String.valueOf((Object)this.format.types[this.elementIndex]));
        }
        this.buffer.putFloat(this.index + 0, u);
        this.buffer.putFloat(this.index + 4, v);
        this.index += this.format.types[this.elementIndex].width;
        ++this.elementIndex;
        return this;
    }

    public SimpleBufferBuilder colour(float r, float g, float b, float a) {
        return this.colour((byte)(r * 255.0f), (byte)(g * 255.0f), (byte)(b * 255.0f), (byte)(a * 255.0f));
    }

    public SimpleBufferBuilder colour(int packedColor) {
        if (!this.building) {
            throw new IllegalStateException("Not building.");
        }
        if (this.elementIndex == this.format.types.length) {
            throw new IllegalStateException("Expected endVertex");
        }
        if (this.format.types[this.elementIndex] != Element.COLOR) {
            throw new IllegalArgumentException("Expected " + String.valueOf((Object)this.format.types[this.elementIndex]));
        }
        this.buffer.putInt(this.index + 0, packedColor);
        this.index += this.format.types[this.elementIndex].width;
        ++this.elementIndex;
        return this;
    }

    public SimpleBufferBuilder colour(byte r, byte g, byte b, byte a) {
        if (!this.building) {
            throw new IllegalStateException("Not building.");
        }
        if (this.elementIndex == this.format.types.length) {
            throw new IllegalStateException("Expected endVertex");
        }
        if (this.format.types[this.elementIndex] != Element.COLOR) {
            throw new IllegalArgumentException("Expected " + String.valueOf((Object)this.format.types[this.elementIndex]));
        }
        this.buffer.put(this.index + 0, r);
        this.buffer.put(this.index + 1, g);
        this.buffer.put(this.index + 2, b);
        this.buffer.put(this.index + 3, a);
        this.index += this.format.types[this.elementIndex].width;
        ++this.elementIndex;
        return this;
    }

    public SimpleBufferBuilder endVertex() {
        if (!this.building) {
            throw new IllegalStateException("Not building.");
        }
        if (this.elementIndex != this.format.types.length) {
            throw new IllegalStateException("Expected " + String.valueOf((Object)this.format.types[this.elementIndex]));
        }
        this.elementIndex = 0;
        ++this.vertices;
        this.ensureSpace(this.format.stride);
        return this;
    }

    private void ensureSpace(int newBytes) {
        int cap = this.buffer.capacity();
        if (this.index + newBytes > cap) {
            int newCap = Math.max(3 * cap / 2, 3 * newBytes / 2);
            this.bufferAddr = ALLOCATOR.realloc(this.bufferAddr, (long)newCap);
            this.buffer = MemoryUtil.memByteBuffer((long)this.bufferAddr, (int)newCap);
            this.buffer.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int finishAndUpload() {
        if (!this.building) {
            throw new IllegalStateException("Not building.");
        }
        try {
            int indices;
            if (this.elementIndex == this.format.types.length) {
                throw new IllegalStateException("Expected endVertex");
            }
            if (this.elementIndex != 0) {
                throw new IllegalStateException("Not finished building vertex, Expected: " + String.valueOf((Object)this.format.types[this.elementIndex]));
            }
            if (this.vertices == 0) {
                int n = 0;
                return n;
            }
            if (this.vertices % this.mode.vertices != 0) {
                throw new IllegalStateException("Does not contain vertices aligned to " + String.valueOf((Object)this.mode));
            }
            this.buffer.position(0);
            this.buffer.limit(this.index);
            int vbo = VERTEX_BUFFERS[this.format.ordinal()];
            int vboSize = VERTEX_BUFFER_LENGTHS[this.format.ordinal()];
            GL32C.glBindBuffer((int)34962, (int)vbo);
            if (vboSize < this.index) {
                int newVBOSize;
                for (newVBOSize = Math.max(1024, vboSize); newVBOSize < this.index; newVBOSize *= 2) {
                }
                GL32C.glBufferData((int)34962, (long)newVBOSize, (int)35048);
                SimpleBufferBuilder.VERTEX_BUFFER_LENGTHS[this.format.ordinal()] = newVBOSize;
            }
            GL32C.glBufferSubData((int)34962, (long)0L, (ByteBuffer)this.buffer);
            int n = indices = this.mode == Mode.TRIANGLES ? this.vertices : this.vertices + this.vertices / 2;
            if (this.mode == Mode.QUADS) {
                SimpleBufferBuilder.ensureElementBufferLength(this.vertices);
                GL32C.glBindBuffer((int)34963, (int)elementBuffer);
            }
            int n2 = indices;
            return n2;
        }
        finally {
            this.building = false;
            this.vertices = 0;
            this.index = 0;
        }
    }

    public void draw() {
        if (!this.building) {
            throw new IllegalStateException("Not building.");
        }
        int vao = VERTEX_ARRAYS[this.format.ordinal()];
        int vbo = VERTEX_BUFFERS[this.format.ordinal()];
        if (vao == 0) {
            assert (vbo == 0);
            vao = GL32C.glGenVertexArrays();
            vbo = GL32C.glGenBuffers();
            SimpleBufferBuilder.VERTEX_ARRAYS[this.format.ordinal()] = vao;
            SimpleBufferBuilder.VERTEX_BUFFERS[this.format.ordinal()] = vbo;
            GL32C.glBindVertexArray((int)vao);
            GL32C.glBindBuffer((int)34962, (int)vbo);
            this.format.bind();
            this.format.enable();
        }
        GL32C.glBindVertexArray((int)vao);
        int indices = this.finishAndUpload();
        if (this.mode == Mode.QUADS) {
            GL32C.glDrawElements((int)4, (int)indices, (int)5125, (long)0L);
        } else {
            GL32C.glDrawArrays((int)4, (int)0, (int)indices);
        }
        GL32C.glBindVertexArray((int)0);
    }

    @Override
    public void close() {
        ALLOCATOR.free(this.bufferAddr);
        this.bufferAddr = 0L;
    }

    static {
        Arrays.fill(VERTEX_ARRAYS, 0);
        Arrays.fill(VERTEX_BUFFERS, 0);
        Arrays.fill(VERTEX_BUFFER_LENGTHS, 0);
    }

    public static enum Format {
        POS(Element.POS),
        POS_TEX(Element.POS, Element.TEX),
        POS_COLOR(Element.POS, Element.COLOR),
        POS_TEX_COLOR(Element.POS, Element.TEX, Element.COLOR);

        private final Element[] types;
        public final int stride;

        private Format(Element ... types) {
            this.types = types;
            this.stride = Arrays.stream(types).mapToInt(e -> e.width).sum();
        }

        public void bind() {
            int offset = 0;
            for (int i = 0; i < this.types.length; ++i) {
                Element type = this.types[i];
                switch (type.glType) {
                    case 5126: {
                        GL32C.glVertexAttribPointer((int)i, (int)type.count, (int)5126, (boolean)false, (int)this.stride, (long)offset);
                        break;
                    }
                    case 5121: {
                        GL32C.glVertexAttribPointer((int)i, (int)type.count, (int)5121, (boolean)true, (int)this.stride, (long)offset);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown glType, I don't know how to bind this vertex element: " + String.valueOf((Object)type));
                    }
                }
                offset += type.width;
            }
        }

        public void enable() {
            for (int i = 0; i < this.types.length; ++i) {
                GL32C.glEnableVertexAttribArray((int)i);
            }
        }

        public void disable() {
            for (int i = 0; i < this.types.length; ++i) {
                GL32C.glDisableVertexAttribArray((int)i);
            }
        }
    }

    public static enum Mode {
        TRIANGLES(3),
        QUADS(4);

        public final int vertices;

        private Mode(int vertices) {
            this.vertices = vertices;
        }
    }

    public static enum Element {
        POS(5126, 2, 8),
        TEX(5126, 2, 8),
        COLOR(5121, 4, 4);

        public final int glType;
        public final int count;
        public final int width;

        private Element(int glType, int count, int width) {
            this.glType = glType;
            this.count = count;
            this.width = width;
        }
    }
}

