/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.neoforged.fml.ICrashReportHeader;
import net.neoforged.fml.ISystemReportExtender;
import org.slf4j.Logger;

public class CrashReportCallables {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<ISystemReportExtender> crashCallables = Collections.synchronizedList(new ArrayList());
    private static final List<ICrashReportHeader> HEADERS = Collections.synchronizedList(new ArrayList());

    public static void registerCrashCallable(ISystemReportExtender callable) {
        crashCallables.add(callable);
    }

    public static void registerCrashCallable(final String headerName, final Supplier<String> reportGenerator) {
        CrashReportCallables.registerCrashCallable(new ISystemReportExtender(){

            @Override
            public String getLabel() {
                return headerName;
            }

            @Override
            public String get() {
                return (String)reportGenerator.get();
            }
        });
    }

    public static void registerCrashCallable(final String headerName, final Supplier<String> reportGenerator, final BooleanSupplier active) {
        CrashReportCallables.registerCrashCallable(new ISystemReportExtender(){

            @Override
            public String getLabel() {
                return headerName;
            }

            @Override
            public String get() {
                return (String)reportGenerator.get();
            }

            @Override
            public boolean isActive() {
                try {
                    return active.getAsBoolean();
                }
                catch (Throwable t) {
                    LOGGER.warn("CrashCallable '{}' threw an exception while checking the active flag, disabling", (Object)headerName, (Object)t);
                    return false;
                }
            }
        });
    }

    public static void registerHeader(ICrashReportHeader header) {
        HEADERS.add(header);
    }

    public static List<ISystemReportExtender> allCrashCallables() {
        return List.copyOf(crashCallables);
    }

    public static Stream<String> getHeaders() {
        return HEADERS.stream().map(ICrashReportHeader::getHeader).filter(Objects::nonNull);
    }
}

