/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.javafmlmod;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class AutomaticEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Type AUTO_SUBSCRIBER = Type.getType(EventBusSubscriber.class);
    private static final Type MOD_TYPE = Type.getType(Mod.class);

    public static void inject(ModContainer mod, ModFileScanData scanData, Module layer) {
        if (scanData == null) {
            return;
        }
        LOGGER.debug(Logging.LOADING, "Attempting to inject @EventBusSubscriber classes into the eventbus for {}", (Object)mod.getModId());
        List<ModFileScanData.AnnotationData> ebsTargets = scanData.getAnnotations().stream().filter(annotationData -> AUTO_SUBSCRIBER.equals((Object)annotationData.annotationType())).collect(Collectors.toList());
        Map<String, String> modids = scanData.getAnnotations().stream().filter(annotationData -> MOD_TYPE.equals((Object)annotationData.annotationType())).collect(Collectors.toMap(a -> a.clazz().getClassName(), a -> (String)a.annotationData().get("value")));
        ebsTargets.forEach(ad -> {
            EnumSet<Dist> sides = AutomaticEventSubscriber.getSides(ad.annotationData().get("value"));
            String modId = (String)ad.annotationData().getOrDefault("modid", modids.getOrDefault(ad.clazz().getClassName(), mod.getModId()));
            if (Objects.equals(mod.getModId(), modId) && sides.contains(FMLEnvironment.dist)) {
                try {
                    LOGGER.debug(Logging.LOADING, "Scanning class {} for @SubscribeEvent-annotated methods", (Object)ad.clazz().getClassName());
                    Class<?> clazz = Class.forName(ad.clazz().getClassName(), true, layer.getClassLoader());
                    ArrayList<Method> modBusListeners = new ArrayList<Method>();
                    ArrayList<Method> gameBusListeners = new ArrayList<Method>();
                    for (Method method : clazz.getDeclaredMethods()) {
                        if (!method.isAnnotationPresent(SubscribeEvent.class)) continue;
                        if (!Modifier.isStatic(method.getModifiers())) {
                            throw new IllegalArgumentException("Method " + String.valueOf(method) + " annotated with @SubscribeEvent is not static");
                        }
                        if (method.getParameterCount() != 1 || !Event.class.isAssignableFrom(method.getParameterTypes()[0])) {
                            throw new IllegalArgumentException("Method " + String.valueOf(method) + " annotated with @SubscribeEvent must have only one parameter that is an Event subtype");
                        }
                        Class<?> eventType = method.getParameterTypes()[0];
                        if (IModBusEvent.class.isAssignableFrom(eventType)) {
                            modBusListeners.add(method);
                            continue;
                        }
                        gameBusListeners.add(method);
                    }
                    if (modBusListeners.isEmpty()) {
                        LOGGER.debug("Subscribing @EventBusSubscriber class {} to the game event bus", (Object)ad.clazz());
                        FMLLoader.getBindings().getGameBus().register(clazz);
                    } else if (gameBusListeners.isEmpty()) {
                        IEventBus modBus = mod.getEventBus();
                        if (modBus != null) {
                            LOGGER.debug("Subscribing @EventBusSubscriber class {} to the mod event bus of mod {}", (Object)ad.clazz(), (Object)mod.getModId());
                            modBus.register(clazz);
                        }
                    } else {
                        LOGGER.debug(Logging.LOADING, "Found mix of game bus and mod bus listeners in @EventBusSubscriber class {}, registering them separately", (Object)ad.clazz());
                        for (Method method : modBusListeners) {
                            IEventBus modBus = mod.getEventBus();
                            if (modBus == null) continue;
                            LOGGER.debug(Logging.LOADING, "Subscribing method {} to the event bus of mod {}", (Object)method, (Object)mod.getModId());
                            modBus.register((Object)method);
                        }
                        for (Method method : gameBusListeners) {
                            LOGGER.debug(Logging.LOADING, "Subscribing method {} to the game event bus", (Object)method);
                            FMLLoader.getBindings().getGameBus().register((Object)method);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.fatal(Logging.LOADING, "Failed to register class {} with @EventBusSubscriber annotation", (Object)ad.clazz(), (Object)e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static EnumSet<Dist> getSides(Object data) {
        if (data == null) {
            return EnumSet.allOf(Dist.class);
        }
        return ((List)data).stream().map(eh -> Dist.valueOf((String)eh.value())).collect(Collectors.toCollection(() -> EnumSet.noneOf(Dist.class)));
    }
}

