/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import com.google.common.base.Suppliers;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;

public class StringSubstitutor {
    private static final Supplier<Map<String, String>> globals = Suppliers.memoize(() -> {
        HashMap<String, String> globals = new HashMap<String, String>();
        globals.put("mcVersion", FMLLoader.versionInfo() == null ? null : FMLLoader.versionInfo().mcVersion());
        globals.put("neoForgeVersion", FMLLoader.versionInfo() == null ? null : FMLLoader.versionInfo().neoForgeVersion());
        return globals;
    });

    public static String replace(String in, ModFile file) {
        return new StrSubstitutor(StringSubstitutor.getStringLookup(file)).replace(in);
    }

    private static StrLookup<String> getStringLookup(final ModFile file) {
        return new StrLookup<String>(){

            public String lookup(String key) {
                String[] parts = key.split("\\.");
                if (parts.length == 1) {
                    return key;
                }
                String pfx = parts[0];
                if ("global".equals(pfx)) {
                    return globals.get().get(parts[1]);
                }
                if ("file".equals(pfx) && file != null) {
                    return String.valueOf(file.getSubstitutionMap().get().get(parts[1]));
                }
                return key;
            }
        };
    }
}

