/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.ITransformationService;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper;
import net.neoforged.neoforgespi.earlywindow.ImmediateWindowProvider;
import net.neoforged.neoforgespi.locating.IDependencyLocator;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IModFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransformerDiscovererConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformerDiscovererConstants.class);
    public static final Set<String> SERVICES = Set.of(ITransformationService.class.getName(), IModFileCandidateLocator.class.getName(), IModFileReader.class.getName(), IDependencyLocator.class.getName(), GraphicsBootstrapper.class.getName(), ImmediateWindowProvider.class.getName());

    private TransformerDiscovererConstants() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldLoadInServiceLayer(Collection<Path> paths) {
        JarContents contents = JarContents.of(paths);
        try {
            boolean bl = TransformerDiscovererConstants.shouldLoadInServiceLayer(contents);
            return bl;
        }
        finally {
            try {
                contents.close();
            }
            catch (IOException e) {
                LOGGER.error("Could not close JarContents {}", paths, (Object)e);
            }
        }
    }

    public static boolean shouldLoadInServiceLayer(Path path) {
        return TransformerDiscovererConstants.shouldLoadInServiceLayer(List.of(path));
    }

    public static boolean shouldLoadInServiceLayer(JarContents jarContents) {
        JarMetadata metadata = JarMetadata.from((JarContents)jarContents);
        return metadata.providers().stream().map(SecureJar.Provider::serviceName).anyMatch(SERVICES::contains);
    }
}

