/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class ConduitRenderer
implements BlockEntityRenderer<ConduitBlockEntity> {
    public static final Material SHELL_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("entity/conduit/base"));
    public static final Material ACTIVE_SHELL_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("entity/conduit/cage"));
    public static final Material WIND_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("entity/conduit/wind"));
    public static final Material VERTICAL_WIND_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("entity/conduit/wind_vertical"));
    public static final Material OPEN_EYE_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("entity/conduit/open_eye"));
    public static final Material CLOSED_EYE_TEXTURE = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("entity/conduit/closed_eye"));
    private final ModelPart eye;
    private final ModelPart wind;
    private final ModelPart shell;
    private final ModelPart cage;
    private final BlockEntityRenderDispatcher renderer;

    public ConduitRenderer(BlockEntityRendererProvider.Context p_173613_) {
        this.renderer = p_173613_.getBlockEntityRenderDispatcher();
        this.eye = p_173613_.bakeLayer(ModelLayers.CONDUIT_EYE);
        this.wind = p_173613_.bakeLayer(ModelLayers.CONDUIT_WIND);
        this.shell = p_173613_.bakeLayer(ModelLayers.CONDUIT_SHELL);
        this.cage = p_173613_.bakeLayer(ModelLayers.CONDUIT_CAGE);
    }

    public static LayerDefinition createEyeLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("eye", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public static LayerDefinition createWindLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("wind", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public static LayerDefinition createShellLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("shell", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    public static LayerDefinition createCageLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("shell", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    @Override
    public void render(ConduitBlockEntity p_112399_, float p_112400_, PoseStack p_112401_, MultiBufferSource p_112402_, int p_112403_, int p_112404_) {
        float f = (float)p_112399_.tickCount + p_112400_;
        if (!p_112399_.isActive()) {
            float f5 = p_112399_.getActiveRotation(0.0f);
            VertexConsumer vertexconsumer1 = SHELL_TEXTURE.buffer(p_112402_, RenderType::entitySolid);
            p_112401_.pushPose();
            p_112401_.translate(0.5f, 0.5f, 0.5f);
            p_112401_.mulPose(new Quaternionf().rotationY(f5 * ((float)Math.PI / 180)));
            this.shell.render(p_112401_, vertexconsumer1, p_112403_, p_112404_);
            p_112401_.popPose();
        } else {
            float f1 = p_112399_.getActiveRotation(p_112400_) * 57.295776f;
            float f2 = Mth.sin((float)(f * 0.1f)) / 2.0f + 0.5f;
            f2 = f2 * f2 + f2;
            p_112401_.pushPose();
            p_112401_.translate(0.5f, 0.3f + f2 * 0.2f, 0.5f);
            Vector3f vector3f = new Vector3f(0.5f, 1.0f, 0.5f).normalize();
            p_112401_.mulPose(new Quaternionf().rotationAxis(f1 * ((float)Math.PI / 180), (Vector3fc)vector3f));
            this.cage.render(p_112401_, ACTIVE_SHELL_TEXTURE.buffer(p_112402_, RenderType::entityCutoutNoCull), p_112403_, p_112404_);
            p_112401_.popPose();
            int i = p_112399_.tickCount / 66 % 3;
            p_112401_.pushPose();
            p_112401_.translate(0.5f, 0.5f, 0.5f);
            if (i == 1) {
                p_112401_.mulPose(new Quaternionf().rotationX(1.5707964f));
            } else if (i == 2) {
                p_112401_.mulPose(new Quaternionf().rotationZ(1.5707964f));
            }
            VertexConsumer vertexconsumer = (i == 1 ? VERTICAL_WIND_TEXTURE : WIND_TEXTURE).buffer(p_112402_, RenderType::entityCutoutNoCull);
            this.wind.render(p_112401_, vertexconsumer, p_112403_, p_112404_);
            p_112401_.popPose();
            p_112401_.pushPose();
            p_112401_.translate(0.5f, 0.5f, 0.5f);
            p_112401_.scale(0.875f, 0.875f, 0.875f);
            p_112401_.mulPose(new Quaternionf().rotationXYZ((float)Math.PI, 0.0f, (float)Math.PI));
            this.wind.render(p_112401_, vertexconsumer, p_112403_, p_112404_);
            p_112401_.popPose();
            Camera camera = this.renderer.camera;
            p_112401_.pushPose();
            p_112401_.translate(0.5f, 0.3f + f2 * 0.2f, 0.5f);
            p_112401_.scale(0.5f, 0.5f, 0.5f);
            float f3 = -camera.getYRot();
            p_112401_.mulPose(new Quaternionf().rotationYXZ(f3 * ((float)Math.PI / 180), camera.getXRot() * ((float)Math.PI / 180), (float)Math.PI));
            float f4 = 1.3333334f;
            p_112401_.scale(1.3333334f, 1.3333334f, 1.3333334f);
            this.eye.render(p_112401_, (p_112399_.isHunting() ? OPEN_EYE_TEXTURE : CLOSED_EYE_TEXTURE).buffer(p_112402_, RenderType::entityCutoutNoCull), p_112403_, p_112404_);
            p_112401_.popPose();
        }
    }

    public AABB getRenderBoundingBox(ConduitBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB(pos.getX(), (double)pos.getY() - 0.25, pos.getZ(), (double)pos.getX() + 1.0, (double)pos.getY() + 1.25, (double)pos.getZ() + 1.0);
    }
}

