/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.event;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.client.gui.GuiLayerManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class RegisterGuiLayersEvent
extends Event
implements IModBusEvent {
    private final List<GuiLayerManager.NamedLayer> layers;

    @ApiStatus.Internal
    public RegisterGuiLayersEvent(List<GuiLayerManager.NamedLayer> layers) {
        this.layers = layers;
    }

    public void registerBelowAll(ResourceLocation id, LayeredDraw.Layer layer) {
        this.register(Ordering.BEFORE, null, id, layer);
    }

    public void registerBelow(ResourceLocation other, ResourceLocation id, LayeredDraw.Layer layer) {
        this.register(Ordering.BEFORE, other, id, layer);
    }

    public void registerAbove(ResourceLocation other, ResourceLocation id, LayeredDraw.Layer layer) {
        this.register(Ordering.AFTER, other, id, layer);
    }

    public void registerAboveAll(ResourceLocation id, LayeredDraw.Layer layer) {
        this.register(Ordering.AFTER, null, id, layer);
    }

    public void replaceLayer(ResourceLocation id, LayeredDraw.Layer replacement) {
        this.wrapLayer(id, old -> replacement);
    }

    public void wrapLayer(ResourceLocation id, UnaryOperator<LayeredDraw.Layer> wrapper) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(wrapper);
        for (int i = 0; i < this.layers.size(); ++i) {
            GuiLayerManager.NamedLayer layer = this.layers.get(i);
            if (!layer.name().equals((Object)id)) continue;
            LayeredDraw.Layer wrapped = (LayeredDraw.Layer)wrapper.apply(layer.layer());
            Objects.requireNonNull(wrapped, "wrapping layer must not be null");
            this.layers.set(i, new GuiLayerManager.NamedLayer(id, wrapped));
            return;
        }
        throw new IllegalArgumentException("Attempted to wrap layer with id '" + String.valueOf(id) + "', which does not exist!");
    }

    private void register(Ordering ordering, @Nullable ResourceLocation other, ResourceLocation key, LayeredDraw.Layer layer) {
        int insertPosition;
        Objects.requireNonNull(key);
        for (GuiLayerManager.NamedLayer namedLayer : this.layers) {
            Preconditions.checkArgument((!namedLayer.name().equals((Object)key) ? 1 : 0) != 0, (Object)("Layer already registered: " + String.valueOf(key)));
        }
        if (other == null) {
            insertPosition = ordering == Ordering.BEFORE ? 0 : this.layers.size();
        } else {
            OptionalInt otherIndex = IntStream.range(0, this.layers.size()).filter(i -> this.layers.get(i).name().equals((Object)other)).findFirst();
            if (otherIndex.isEmpty()) {
                throw new IllegalArgumentException("Attempted to order against an unregistered layer " + String.valueOf(other) + ". Only order against vanilla's and your own.");
            }
            insertPosition = otherIndex.getAsInt() + (ordering == Ordering.BEFORE ? 0 : 1);
        }
        this.layers.add(insertPosition, new GuiLayerManager.NamedLayer(key, layer));
    }

    private static enum Ordering {
        BEFORE,
        AFTER;

    }
}

