/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.payload;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.common.util.FriendlyByteBufUtil;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record AdvancedAddEntityPayload(int entityId, byte[] customPayload) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AdvancedAddEntityPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"advanced_add_entity"));
    public static final StreamCodec<FriendlyByteBuf, AdvancedAddEntityPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, AdvancedAddEntityPayload::entityId, NeoForgeStreamCodecs.UNBOUNDED_BYTE_ARRAY, AdvancedAddEntityPayload::customPayload, AdvancedAddEntityPayload::new);

    public AdvancedAddEntityPayload(Entity e) {
        this(e.getId(), AdvancedAddEntityPayload.writeCustomData(e));
    }

    private static byte[] writeCustomData(Entity entity) {
        if (!(entity instanceof IEntityWithComplexSpawn)) {
            return new byte[0];
        }
        IEntityWithComplexSpawn additionalSpawnData = (IEntityWithComplexSpawn)entity;
        return FriendlyByteBufUtil.writeCustomData(additionalSpawnData::writeSpawnData, entity.registryAccess());
    }

    public CustomPacketPayload.Type<AdvancedAddEntityPayload> type() {
        return TYPE;
    }
}

