/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.payload;

import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public final class DinnerboneProtocolUtils {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final StreamCodec<FriendlyByteBuf, Set<ResourceLocation>> CHANNELS_CODEC = StreamCodec.of(DinnerboneProtocolUtils::writeChannels, DinnerboneProtocolUtils::readChannels);

    private DinnerboneProtocolUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static Set<ResourceLocation> readChannels(FriendlyByteBuf buf) {
        StringBuilder builder = new StringBuilder();
        HashSet<ResourceLocation> channels = new HashSet<ResourceLocation>();
        while (buf.isReadable()) {
            char c = (char)buf.readByte();
            if (c == '\u0000') {
                DinnerboneProtocolUtils.parseAndAddChannel(builder, channels);
                continue;
            }
            builder.append(c);
        }
        DinnerboneProtocolUtils.parseAndAddChannel(builder, channels);
        return channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseAndAddChannel(StringBuilder builder, Set<ResourceLocation> channels) {
        if (builder.isEmpty()) {
            return;
        }
        String channel = builder.toString();
        try {
            channels.add(ResourceLocation.parse((String)channel));
        }
        catch (Exception e) {
            LOGGER.error("Invalid channel: {}", (Object)channel, (Object)e);
        }
        finally {
            builder.setLength(0);
        }
    }

    private static void writeChannels(FriendlyByteBuf buf, Set<ResourceLocation> channels) {
        for (ResourceLocation channel : channels) {
            for (char c : channel.toString().toCharArray()) {
                buf.writeByte((int)c);
            }
            buf.writeByte(0);
        }
    }
}

