/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.freetype;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.freetype.FT_Vector;

public class FT_Outline
extends Struct<FT_Outline>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int N_CONTOURS;
    public static final int N_POINTS;
    public static final int POINTS;
    public static final int TAGS;
    public static final int CONTOURS;
    public static final int FLAGS;

    protected FT_Outline(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FT_Outline create(long address, @Nullable ByteBuffer container) {
        return new FT_Outline(address, container);
    }

    public FT_Outline(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FT_Outline.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public short n_contours() {
        return FT_Outline.nn_contours(this.address());
    }

    public short n_points() {
        return FT_Outline.nn_points(this.address());
    }

    @NativeType(value="FT_Vector *")
    public FT_Vector.Buffer points() {
        return FT_Outline.npoints(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer tags() {
        return FT_Outline.ntags(this.address());
    }

    @NativeType(value="short *")
    public ShortBuffer contours() {
        return FT_Outline.ncontours(this.address());
    }

    public int flags() {
        return FT_Outline.nflags(this.address());
    }

    public static FT_Outline malloc() {
        return new FT_Outline(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FT_Outline calloc() {
        return new FT_Outline(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FT_Outline create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FT_Outline(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FT_Outline create(long address) {
        return new FT_Outline(address, null);
    }

    @Nullable
    public static FT_Outline createSafe(long address) {
        return address == 0L ? null : new FT_Outline(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FT_Outline.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FT_Outline.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FT_Outline malloc(MemoryStack stack) {
        return new FT_Outline(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FT_Outline calloc(MemoryStack stack) {
        return new FT_Outline(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nn_contours(long struct) {
        return UNSAFE.getShort(null, struct + (long)N_CONTOURS);
    }

    public static short nn_points(long struct) {
        return UNSAFE.getShort(null, struct + (long)N_POINTS);
    }

    public static FT_Vector.Buffer npoints(long struct) {
        return FT_Vector.create(MemoryUtil.memGetAddress((long)(struct + (long)POINTS)), FT_Outline.nn_points(struct));
    }

    public static ByteBuffer ntags(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)TAGS)), (int)FT_Outline.nn_points(struct));
    }

    public static ShortBuffer ncontours(long struct) {
        return MemoryUtil.memShortBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)CONTOURS)), (int)FT_Outline.nn_contours(struct));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    static {
        Struct.Layout layout = FT_Outline.__struct((Struct.Member[])new Struct.Member[]{FT_Outline.__member((int)2), FT_Outline.__member((int)2), FT_Outline.__member((int)POINTER_SIZE), FT_Outline.__member((int)POINTER_SIZE), FT_Outline.__member((int)POINTER_SIZE), FT_Outline.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        N_CONTOURS = layout.offsetof(0);
        N_POINTS = layout.offsetof(1);
        POINTS = layout.offsetof(2);
        TAGS = layout.offsetof(3);
        CONTOURS = layout.offsetof(4);
        FLAGS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<FT_Outline, Buffer>
    implements NativeResource {
        private static final FT_Outline ELEMENT_FACTORY = FT_Outline.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected FT_Outline getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public short n_contours() {
            return FT_Outline.nn_contours(this.address());
        }

        public short n_points() {
            return FT_Outline.nn_points(this.address());
        }

        @NativeType(value="FT_Vector *")
        public FT_Vector.Buffer points() {
            return FT_Outline.npoints(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer tags() {
            return FT_Outline.ntags(this.address());
        }

        @NativeType(value="short *")
        public ShortBuffer contours() {
            return FT_Outline.ncontours(this.address());
        }

        public int flags() {
            return FT_Outline.nflags(this.address());
        }
    }
}

