/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launchwrapper;

import com.gtnewhorizons.retrofuturabootstrap.Main;
import com.gtnewhorizons.retrofuturabootstrap.RfbSystemClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.plugin.PluginLoader;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.launchwrapper.LogWrapper;

public class Launch {
    private static final String DEFAULT_TWEAK = "net.minecraft.launchwrapper.VanillaTweaker";
    public static File minecraftHome;
    public static File assetsDir;
    public static Map<String, Object> blackboard;
    public static LaunchClassLoader classLoader;
    private static final PrintStream originalSysErr;
    public static final String RFB$BLACKBOARD_TWEAK_CLASSES = "TweakClasses";
    public static final String RFB$BLACKBOARD_ARGUMENT_LIST = "ArgumentList";
    public static final String RFB$BLACKBOARD_TWEAKS = "Tweaks";

    private void launch(String[] args) throws Throwable {
        this.rfb$realLaunch(args);
    }

    public static void main(String[] args) throws Throwable {
        if (!(Launch.class.getClassLoader() instanceof ExtensibleClassLoader)) {
            throw new UnsupportedOperationException("RetroFuturaBootstrap requires launching using com.gtnewhorizons.retrofuturabootstrap.Main");
        }
        new Launch().launch(args);
    }

    private Launch() throws Throwable {
        LaunchClassLoader lcl;
        LogWrapper.configureLogging();
        blackboard = new HashMap<String, Object>();
        ExtensibleClassLoader parentLoader = (ExtensibleClassLoader)((Object)this.getClass().getClassLoader());
        if (parentLoader instanceof RfbSystemClassLoader) {
            lcl = (LaunchClassLoader)((RfbSystemClassLoader)parentLoader).getChildLoader();
            if (lcl == null) {
                lcl = new LaunchClassLoader(parentLoader.asURLClassLoader().getURLs());
                ((RfbSystemClassLoader)parentLoader).setChildLoader(lcl);
            }
        } else {
            lcl = new LaunchClassLoader(parentLoader.asURLClassLoader().getURLs());
        }
        classLoader = lcl;
        Main.launchLoader = lcl;
        Thread.currentThread().setContextClassLoader(lcl);
    }

    private void rfb$realLaunch(String[] args) throws Throwable {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec aVersion = parser.accepts("version").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec aGameDir = parser.accepts("gameDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec aAssetsDir = parser.accepts("assetsDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec aTweakClass = parser.accepts("tweakClass").withOptionalArg().ofType(String.class).defaultsTo((Object)DEFAULT_TWEAK, (Object[])new String[0]);
        NonOptionArgumentSpec aRemainder = parser.nonOptions().ofType(String.class);
        parser.allowsUnrecognizedOptions();
        OptionSet options = parser.parse(args);
        String version = (String)options.valueOf((OptionSpec)aVersion);
        File gameDir = (File)options.valueOf((OptionSpec)aGameDir);
        File assetsDir = (File)options.valueOf((OptionSpec)aAssetsDir);
        ArrayList tweakClasses = new ArrayList(options.valuesOf((OptionSpec)aTweakClass));
        List remainingArgs = options.valuesOf((OptionSpec)aRemainder);
        minecraftHome = gameDir;
        Launch.assetsDir = assetsDir;
        Main.initialGameVersion = version;
        Main.initialGameDir = gameDir != null ? gameDir : new File(".");
        Main.initialAssetsDir = assetsDir;
        if ((Main.cfgDumpLoadedClasses || Main.cfgDumpLoadedClassesPerTransformer) && Main.classDumpDirectory.get() == null) {
            Path gamePath = gameDir != null ? gameDir.toPath() : Paths.get("", new String[0]).toAbsolutePath();
            FileSystem fs = gamePath.getFileSystem();
            Path dumpPath = gamePath.resolve("RFB_CLASS_DUMP");
            try {
                Files.createDirectory(dumpPath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fae) {
                for (int i = 0; i < 1000; ++i) {
                    dumpPath = gamePath.resolve("RFB_CLASS_DUMP_" + i);
                    try {
                        Files.createDirectory(dumpPath, new FileAttribute[0]);
                        break;
                    }
                    catch (FileAlreadyExistsException e) {
                        continue;
                    }
                }
            }
            Main.classDumpDirectory.set(dumpPath);
        }
        blackboard.put(RFB$BLACKBOARD_TWEAK_CLASSES, tweakClasses);
        ArrayList argumentList = new ArrayList();
        blackboard.put(RFB$BLACKBOARD_ARGUMENT_LIST, argumentList);
        ArrayList<ITweaker> tweaks = new ArrayList<ITweaker>();
        blackboard.put(RFB$BLACKBOARD_TWEAKS, tweaks);
        PluginLoader.initializePlugins();
        HashSet<String> dedupTweakClasses = new HashSet<String>();
        ArrayList<ITweaker> allTweakers = new ArrayList<ITweaker>();
        ITweaker firstTweaker = null;
        while (!tweakClasses.isEmpty()) {
            Iterator iter = tweakClasses.iterator();
            while (iter.hasNext()) {
                try {
                    String tweakClass = (String)iter.next();
                    if (dedupTweakClasses.contains(tweakClass)) {
                        LogWrapper.rfb$logger.warn("Duplicate tweaker class {}", new Object[]{tweakClass});
                        iter.remove();
                        continue;
                    }
                    dedupTweakClasses.add(tweakClass);
                    int lastDot = tweakClass.lastIndexOf(46);
                    String tweakPackagePrefix = lastDot == -1 ? tweakClass : tweakClass.substring(0, lastDot);
                    classLoader.addClassLoaderExclusion(tweakPackagePrefix);
                    LogWrapper.rfb$logger.info("Constructing tweaker {}", new Object[]{tweakClass});
                    Class<?> tweakerClass = Class.forName(tweakClass, true, classLoader);
                    ITweaker tweaker = (ITweaker)tweakerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    tweaks.add(tweaker);
                    iter.remove();
                    if (firstTweaker != null) continue;
                    firstTweaker = tweaker;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            iter = tweaks.iterator();
            while (iter.hasNext()) {
                ITweaker tweaker = (ITweaker)iter.next();
                LogWrapper.rfb$logger.info("Installing tweaker {}", new Object[]{tweaker.getClass().getName()});
                tweaker.acceptOptions(remainingArgs, gameDir, assetsDir, version);
                tweaker.injectIntoClassLoader(classLoader);
                allTweakers.add(tweaker);
                iter.remove();
            }
        }
        for (ITweaker tweaker : allTweakers) {
            Collections.addAll(argumentList, tweaker.getLaunchArguments());
        }
        try {
            String launchTargetName = ((ITweaker)Objects.requireNonNull(firstTweaker, "No tweaker supplied")).getLaunchTarget();
            Class<?> launchTarget = Class.forName(launchTargetName, false, classLoader);
            Method mainM = launchTarget.getMethod("main", String[].class);
            mainM.invoke(null, new Object[]{argumentList.toArray(new String[0])});
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    static {
        originalSysErr = System.err;
    }
}

