/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import com.mojang.patchy.BlockedServers;
import com.mojang.patchy.BlockingICFB;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Map;

public final class Bootstrap
extends AbstractBootstrap<Bootstrap, Channel> {
    private static final InternalLogger logger;
    private volatile SocketAddress remoteAddress;

    public Bootstrap() {
    }

    private Bootstrap(Bootstrap bootstrap) {
        super((AbstractBootstrap)bootstrap);
        this.remoteAddress = bootstrap.remoteAddress;
    }

    public Bootstrap remoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public Bootstrap remoteAddress(String inetHost, int inetPort) {
        this.remoteAddress = new InetSocketAddress(inetHost, inetPort);
        return this;
    }

    public Bootstrap remoteAddress(InetAddress inetHost, int inetPort) {
        this.remoteAddress = new InetSocketAddress(inetHost, inetPort);
        return this;
    }

    public ChannelFuture connect() {
        this.validate();
        SocketAddress remoteAddress = this.remoteAddress;
        if (remoteAddress == null) {
            throw new IllegalStateException("remoteAddress not set");
        }
        return this.doConnect(remoteAddress, this.localAddress());
    }

    public ChannelFuture connect(String inetHost, int inetPort) {
        return this.connect(new InetSocketAddress(inetHost, inetPort));
    }

    public ChannelFuture connect(InetAddress inetHost, int inetPort) {
        return this.connect(new InetSocketAddress(inetHost, inetPort));
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        this.validate();
        return this.doConnect(remoteAddress, this.localAddress());
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        this.validate();
        return this.doConnect(remoteAddress, localAddress);
    }

    private ChannelFuture doConnect(final SocketAddress remoteAddress, final SocketAddress localAddress) {
        ChannelFuture future = this.checkAddress(remoteAddress);
        if (future != null) {
            return future;
        }
        final ChannelFuture regFuture = this.initAndRegister();
        final Channel channel = regFuture.channel();
        if (regFuture.cause() != null) {
            return regFuture;
        }
        final ChannelPromise promise = channel.newPromise();
        if (regFuture.isDone()) {
            Bootstrap.doConnect0(regFuture, channel, remoteAddress, localAddress, promise);
        } else {
            regFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    Bootstrap.doConnect0(regFuture, channel, remoteAddress, localAddress, promise);
                }
            });
        }
        return promise;
    }

    private static void doConnect0(final ChannelFuture regFuture, final Channel channel, final SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
        channel.eventLoop().execute(new Runnable(){

            @Override
            public void run() {
                if (regFuture.isSuccess()) {
                    if (localAddress == null) {
                        channel.connect(remoteAddress, promise);
                    } else {
                        channel.connect(remoteAddress, localAddress, promise);
                    }
                    promise.addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                } else {
                    promise.setFailure(regFuture.cause());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(Channel channel) throws Exception {
        Map options;
        ChannelPipeline p = channel.pipeline();
        p.addLast(new ChannelHandler[]{this.handler()});
        Map map = options = this.options();
        synchronized (map) {
            for (Map.Entry e : options.entrySet()) {
                try {
                    if (channel.config().setOption((ChannelOption)e.getKey(), e.getValue())) continue;
                    logger.warn("Unknown channel option: " + e);
                }
                catch (Throwable t) {
                    logger.warn("Failed to set a channel option: " + channel, t);
                }
            }
        }
        Map attrs = this.attrs();
        Map map2 = attrs;
        synchronized (map2) {
            for (Map.Entry e : attrs.entrySet()) {
                channel.attr((AttributeKey)e.getKey()).set(e.getValue());
            }
        }
    }

    public Bootstrap validate() {
        super.validate();
        if (this.handler() == null) {
            throw new IllegalStateException("handler not set");
        }
        return this;
    }

    public Bootstrap clone() {
        return new Bootstrap(this);
    }

    public String toString() {
        if (this.remoteAddress == null) {
            return super.toString();
        }
        StringBuilder buf = new StringBuilder(super.toString());
        buf.setLength(buf.length() - 1);
        buf.append(", remoteAddress: ");
        buf.append(this.remoteAddress);
        buf.append(')');
        return buf.toString();
    }

    ChannelFuture checkAddress(SocketAddress remoteAddress) {
        InetAddress address;
        if (remoteAddress instanceof InetSocketAddress && (BlockedServers.isBlockedServer((address = ((InetSocketAddress)remoteAddress).getAddress()).getHostAddress()) || BlockedServers.isBlockedServer(address.getHostName()))) {
            Channel channel = this.channelFactory().newChannel();
            channel.unsafe().closeForcibly();
            SocketException cause = new SocketException("Network is unreachable");
            cause.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
            return new DefaultChannelPromise(channel, (EventExecutor)GlobalEventExecutor.INSTANCE).setFailure((Throwable)cause);
        }
        return null;
    }

    static {
        BlockingICFB.install();
        logger = InternalLoggerFactory.getInstance(Bootstrap.class);
    }
}

