/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui;

import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.McoServer;
import com.mojang.realmsclient.dto.PlayerInfo;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.ActivityScreen;
import com.mojang.realmsclient.gui.EditOnlineWorldScreen;
import com.mojang.realmsclient.gui.InviteScreen;
import com.mojang.realmsclient.gui.LongConfirmationScreen;
import com.mojang.realmsclient.gui.ModifyMinigameWorldScreen;
import com.mojang.realmsclient.gui.MovableScrolledSelectionList;
import com.mojang.realmsclient.gui.RealmsConfirmResultListener;
import com.mojang.realmsclient.gui.RealmsConfirmScreen;
import com.mojang.realmsclient.gui.StartMinigameWorldScreen;
import com.mojang.realmsclient.gui.SubscriptionScreen;
import com.mojang.realmsclient.gui.WorldManagementScreen;
import java.io.IOException;
import java.util.Set;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.Tezzelator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ConfigureWorldScreen
extends RealmsScreen
implements RealmsConfirmResultListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TOGGLE_ON_ICON_LOCATION = "realms:textures/gui/realms/toggle_on_icon.png";
    private static final String TOGGLE_OFF_ICON_LOCATION = "realms:textures/gui/realms/toggle_off_icon.png";
    private static final String OFF_ICON_LOCATION = "realms:textures/gui/realms/off_icon.png";
    private static final String EXPIRED_ICON_LOCATION = "realms:textures/gui/realms/expired_icon.png";
    private static final String OP_ICON_LOCATION = "realms:textures/gui/realms/op_icon.png";
    private static final String USER_ICON_LOCATION = "realms:textures/gui/realms/user_icon.png";
    private static final String CROSS_ICON_LOCATION = "realms:textures/gui/realms/cross_icon.png";
    private String toolTip;
    private final RealmsScreen lastScreen;
    private McoServer serverData;
    private volatile long serverId;
    private InvitedSelectionList invitedSelectionList;
    private int column1_x;
    private int column_width;
    private int column2_x;
    private static final int BUTTON_OPEN_ID = 0;
    private static final int BUTTON_CLOSE_ID = 1;
    private static final int BUTTON_UNINVITE_ID = 3;
    private static final int BUTTON_EDIT_ID = 5;
    private static final int BUTTON_SUBSCRIPTION_ID = 7;
    private static final int BUTTON_MINIGAME_ID = 8;
    private static final int BUTTON_BACK_ID = 10;
    private static final int BUTTON_ACTIVITY_ID = 11;
    private static final int BUTTON_EDIT_WORLD_ID = 12;
    private int selectedInvitedIndex = -1;
    private String selectedInvited;
    private RealmsButton editButton;
    private RealmsButton minigameButton;
    private RealmsButton subscriptionButton;
    private RealmsButton editWorldButton;
    private RealmsButton activityButton;
    private boolean stateChanged;
    private boolean openButtonHovered = false;
    private boolean closeButtonHovered = false;
    private volatile Set<String> ops;

    public ConfigureWorldScreen(RealmsScreen lastScreen, long serverId) {
        this.lastScreen = lastScreen;
        this.serverId = serverId;
    }

    public void tick() {
        super.tick();
    }

    public void init() {
        this.getOwnWorld(this.serverId);
        this.column1_x = this.width() / 2 - 160;
        this.column_width = 150;
        this.column2_x = this.width() / 2 + 12;
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        this.editButton = ConfigureWorldScreen.newButton((int)5, (int)this.column2_x, (int)this.row(6), (int)this.column_width, (int)20, (String)ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.buttons.edit"));
        this.buttonsAdd(this.editButton);
        this.editWorldButton = ConfigureWorldScreen.newButton((int)12, (int)this.column2_x, (int)this.row(4), (int)this.column_width, (int)20, (String)ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.buttons.editworld"));
        this.buttonsAdd(this.editWorldButton);
        this.minigameButton = ConfigureWorldScreen.newButton((int)8, (int)this.column2_x, (int)this.row(2), (int)this.column_width, (int)20, (String)ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.buttons.startMiniGame"));
        this.buttonsAdd(this.minigameButton);
        this.subscriptionButton = ConfigureWorldScreen.newButton((int)7, (int)this.column2_x, (int)this.row(8), (int)this.column_width, (int)20, (String)ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.buttons.subscription"));
        this.buttonsAdd(this.subscriptionButton);
        this.activityButton = ConfigureWorldScreen.newButton((int)11, (int)this.column1_x, (int)this.row(12), (int)(this.column_width + 10), (int)20, (String)ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.buttons.activity"));
        this.buttonsAdd(this.activityButton);
        this.buttonsAdd(ConfigureWorldScreen.newButton((int)10, (int)(this.column2_x + this.column_width / 2 + 2), (int)this.row(12), (int)(this.column_width / 2 - 2), (int)20, (String)ConfigureWorldScreen.getLocalizedString((String)"gui.back")));
        this.invitedSelectionList = new InvitedSelectionList();
        this.editButton.active(false);
        this.editWorldButton.active(false);
        this.minigameButton.active(false);
        this.subscriptionButton.active(false);
        this.activityButton.active(false);
    }

    private void fetchOps() {
        new Thread(){

            @Override
            public void run() {
                RealmsClient client = RealmsClient.createRealmsClient();
                try {
                    ConfigureWorldScreen.this.ops = client.getOpsFor((long)((ConfigureWorldScreen)ConfigureWorldScreen.this).serverId).ops;
                }
                catch (RealmsServiceException e) {
                    LOGGER.error("Couldn't fetch ops");
                }
                catch (Exception e) {
                    LOGGER.error("Couldn't parse response of fetching ops");
                }
            }
        }.start();
    }

    private int row(int i) {
        return 40 + i * 13;
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == 10) {
            this.backButtonClicked();
        } else if (button.id() == 5) {
            Realms.setScreen((RealmsScreen)new EditOnlineWorldScreen(this, this.lastScreen, this.serverData.clone()));
        } else if (button.id() == 1) {
            String line2 = ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.close.question.line1");
            String line3 = ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.close.question.line2");
            Realms.setScreen((RealmsScreen)new LongConfirmationScreen(this, LongConfirmationScreen.Type.Info, line2, line3, 1));
        } else if (button.id() == 0) {
            this.openTheWorld();
        } else if (button.id() == 8) {
            if (this.serverData.worldType.equals((Object)McoServer.WorldType.MINIGAME)) {
                Realms.setScreen((RealmsScreen)new ModifyMinigameWorldScreen(this, this.serverData));
            } else {
                Realms.setScreen((RealmsScreen)new StartMinigameWorldScreen(this, this.serverData));
            }
        } else if (button.id() == 7) {
            Realms.setScreen((RealmsScreen)new SubscriptionScreen(this, this.serverData));
        } else if (button.id() == 11) {
            Realms.setScreen((RealmsScreen)new ActivityScreen(this, this.serverData.id));
        } else if (button.id() == 12) {
            Realms.setScreen((RealmsScreen)new WorldManagementScreen(this, this.lastScreen, this.serverData.clone()));
        }
    }

    public void keyPressed(char ch, int eventKey) {
        if (eventKey == 1) {
            this.backButtonClicked();
        }
    }

    private void backButtonClicked() {
        if (this.stateChanged) {
            ((RealmsMainScreen)this.lastScreen).removeSelection();
        }
        Realms.setScreen((RealmsScreen)this.lastScreen);
    }

    private void getOwnWorld(final long worldId) {
        new Thread(){

            @Override
            public void run() {
                RealmsClient client = RealmsClient.createRealmsClient();
                try {
                    ConfigureWorldScreen.this.serverData = client.getOwnWorld(worldId);
                    ConfigureWorldScreen.this.fetchOps();
                    ConfigureWorldScreen.this.editButton.active(!((ConfigureWorldScreen)ConfigureWorldScreen.this).serverData.expired);
                    ConfigureWorldScreen.this.minigameButton.active(!((ConfigureWorldScreen)ConfigureWorldScreen.this).serverData.expired);
                    ConfigureWorldScreen.this.subscriptionButton.active(true);
                    ConfigureWorldScreen.this.activityButton.active(true);
                    ConfigureWorldScreen.this.editWorldButton.active(true);
                    boolean isMinigame = ((ConfigureWorldScreen)ConfigureWorldScreen.this).serverData.worldType.equals((Object)McoServer.WorldType.MINIGAME);
                    if (isMinigame) {
                        ConfigureWorldScreen.this.minigameButton.msg(RealmsScreen.getLocalizedString((String)"mco.configure.world.buttons.modifyMiniGame"));
                        ConfigureWorldScreen.this.editButton.active(false);
                        ConfigureWorldScreen.this.editWorldButton.active(false);
                    }
                }
                catch (RealmsServiceException e) {
                    LOGGER.error("Couldn't get own world");
                }
                catch (IOException e) {
                    LOGGER.error("Couldn't parse response getting own world");
                }
            }
        }.start();
    }

    private void op() {
        RealmsClient client = RealmsClient.createRealmsClient();
        String selectedInvite = this.serverData.players.get(this.selectedInvitedIndex).getName();
        try {
            client.op(this.serverData.id, selectedInvite);
            this.fetchOps();
        }
        catch (RealmsServiceException e) {
            LOGGER.error("Couldn't op the user");
        }
    }

    private void deop() {
        RealmsClient client = RealmsClient.createRealmsClient();
        String selectedInvite = this.serverData.players.get(this.selectedInvitedIndex).getName();
        try {
            client.deop(this.serverData.id, selectedInvite);
            this.fetchOps();
        }
        catch (RealmsServiceException e) {
            LOGGER.error("Couldn't deop the user");
        }
    }

    private void openTheWorld() {
        RealmsClient client = RealmsClient.createRealmsClient();
        try {
            Boolean openResult = client.open(this.serverData.id);
            if (openResult.booleanValue()) {
                this.stateChanged = true;
                this.serverData.state = McoServer.State.OPEN;
                this.init();
            }
        }
        catch (RealmsServiceException e) {
            LOGGER.error("Couldn't open world");
        }
        catch (IOException e) {
            LOGGER.error("Could not parse response opening world");
        }
    }

    private void closeTheWorld() {
        RealmsClient client = RealmsClient.createRealmsClient();
        try {
            boolean closeResult = client.close(this.serverData.id);
            if (closeResult) {
                this.stateChanged = true;
                this.serverData.state = McoServer.State.CLOSED;
                this.init();
            }
        }
        catch (RealmsServiceException e) {
            LOGGER.error("Couldn't close world");
        }
        catch (IOException e) {
            LOGGER.error("Could not parse response closing world");
        }
    }

    private void uninvite() {
        if (this.selectedInvitedIndex >= 0 && this.selectedInvitedIndex < this.serverData.players.size()) {
            PlayerInfo playerInfo = this.serverData.players.get(this.selectedInvitedIndex);
            this.selectedInvited = playerInfo.getUuid();
            RealmsConfirmScreen confirmScreen = new RealmsConfirmScreen(this, "Question", ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.uninvite.question") + " '" + playerInfo.getName() + "'", 3);
            Realms.setScreen((RealmsScreen)confirmScreen);
        }
    }

    @Override
    public void confirmResult(boolean result, int id) {
        if (id == 3) {
            if (result) {
                RealmsClient client = RealmsClient.createRealmsClient();
                try {
                    client.uninvite(this.serverData.id, this.selectedInvited);
                }
                catch (RealmsServiceException e) {
                    LOGGER.error("Couldn't uninvite user");
                }
                this.deleteFromInvitedList(this.selectedInvitedIndex);
            }
            Realms.setScreen((RealmsScreen)new ConfigureWorldScreen(this.lastScreen, this.serverData.id));
        } else if (id == 1) {
            if (result) {
                this.closeTheWorld();
            }
            Realms.setScreen((RealmsScreen)this);
        }
    }

    private void deleteFromInvitedList(int selectedInvitedIndex) {
        this.serverData.players.remove(selectedInvitedIndex);
    }

    public void mouseClicked(int x, int y, int buttonNum) {
        if (this.closeButtonHovered && !this.serverData.expired) {
            this.openTheWorld();
        } else if (this.openButtonHovered && !this.serverData.expired) {
            String line2 = ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.close.question.line1");
            String line3 = ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.close.question.line2");
            Realms.setScreen((RealmsScreen)new LongConfirmationScreen(this, LongConfirmationScreen.Type.Info, line2, line3, 1));
        }
        super.mouseClicked(x, y, buttonNum);
    }

    public void render(int xm, int ym, float a) {
        this.toolTip = null;
        this.closeButtonHovered = false;
        this.openButtonHovered = false;
        this.renderBackground();
        if (this.invitedSelectionList != null) {
            this.invitedSelectionList.render(xm, ym, a);
        }
        this.drawCenteredString(ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.title"), this.width() / 2, 17, 0xFFFFFF);
        if (this.serverData != null && this.serverData.players != null) {
            this.drawString(ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.invited") + " (" + this.serverData.players.size() + "/20)", this.column1_x, this.row(1), 0xA0A0A0);
        } else {
            this.drawString(ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.invited"), this.column1_x, this.row(1), 0xA0A0A0);
        }
        super.render(xm, ym, a);
        if (this.serverData == null) {
            return;
        }
        String name = this.serverData.getName();
        int nameWidth = this.fontWidth(name);
        if (this.serverData.state == McoServer.State.OPEN) {
            this.drawCenteredString(name, this.width() / 2, 30, 0x7FFF7F);
        } else if (this.serverData.state == McoServer.State.CLOSED) {
            this.drawCenteredString(name, this.width() / 2, 30, 0xCCCCCC);
        } else {
            this.drawCenteredString(name, this.width() / 2, 30, 0x7FFF7F);
        }
        int statusX = this.width() / 2 - nameWidth / 2 - 13;
        this.drawServerStatus(statusX, 30, xm, ym);
        if (this.toolTip != null) {
            this.renderMousehoverTooltip(this.toolTip, xm, ym);
        }
    }

    protected void renderMousehoverTooltip(String msg, int x, int y) {
        if (msg == null) {
            return;
        }
        int rx = x + 12;
        int ry = y - 12;
        int width = this.fontWidth(msg);
        this.fillGradient(rx - 3, ry - 3, rx + width + 3, ry + 8 + 3, -1073741824, -1073741824);
        this.fontDrawShadow(msg, rx, ry, -1);
    }

    private void drawServerStatus(int x, int y, int xm, int ym) {
        if (this.serverData.expired) {
            this.drawExpired(x, y, xm, ym);
        } else if (this.serverData.state == McoServer.State.CLOSED) {
            this.drawClose(x, y, xm, ym);
        } else if (this.serverData.state == McoServer.State.OPEN) {
            this.drawOpen(x, y, xm, ym);
        } else if (this.serverData.state == McoServer.State.ADMIN_LOCK) {
            this.drawLocked(x, y, xm, ym);
        }
    }

    private void drawRemoveIcon(int x, int y, int xm, int ym) {
        ConfigureWorldScreen.bind((String)CROSS_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        RealmsScreen.blit((int)x, (int)y, (float)0.0f, (float)0.0f, (int)8, (int)7, (float)8.0f, (float)7.0f);
        GL11.glPopMatrix();
        if (xm >= x && xm <= x + 9 && ym >= y && ym <= y + 9) {
            this.toolTip = ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.invites.remove.tooltip");
        }
    }

    private void drawOpped(int x, int y, int xm, int ym) {
        ConfigureWorldScreen.bind((String)OP_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        RealmsScreen.blit((int)x, (int)y, (float)0.0f, (float)0.0f, (int)8, (int)8, (float)8.0f, (float)8.0f);
        GL11.glPopMatrix();
        if (xm >= x && xm <= x + 9 && ym >= y && ym <= y + 9) {
            this.toolTip = ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.invites.ops.tooltip");
        }
    }

    private void drawNormal(int x, int y, int xm, int ym) {
        ConfigureWorldScreen.bind((String)USER_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        RealmsScreen.blit((int)x, (int)y, (float)0.0f, (float)0.0f, (int)8, (int)8, (float)8.0f, (float)8.0f);
        GL11.glPopMatrix();
        if (xm >= x && xm <= x + 9 && ym >= y && ym <= y + 9) {
            this.toolTip = ConfigureWorldScreen.getLocalizedString((String)"mco.configure.world.invites.normal.tooltip");
        }
    }

    private void drawExpired(int x, int y, int xm, int ym) {
        ConfigureWorldScreen.bind((String)EXPIRED_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        RealmsScreen.blit((int)(x * 2), (int)(y * 2), (float)0.0f, (float)0.0f, (int)15, (int)15, (float)15.0f, (float)15.0f);
        GL11.glPopMatrix();
        if (xm >= x && xm <= x + 9 && ym >= y && ym <= y + 9) {
            this.toolTip = ConfigureWorldScreen.getLocalizedString((String)"mco.selectServer.expired");
        }
    }

    private void drawOpen(int x, int y, int xm, int ym) {
        ConfigureWorldScreen.bind((String)TOGGLE_ON_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        int xx = x - 12;
        RealmsScreen.blit((int)(xx * 2), (int)(y * 2), (float)0.0f, (float)0.0f, (int)32, (int)16, (float)32.0f, (float)16.0f);
        GL11.glPopMatrix();
        if (xm >= xx && xm <= xx + 16 && ym >= y && ym <= y + 8) {
            this.toolTip = ConfigureWorldScreen.getLocalizedString((String)"mco.selectServer.closeserver");
            this.openButtonHovered = true;
        }
    }

    private void drawClose(int x, int y, int xm, int ym) {
        ConfigureWorldScreen.bind((String)TOGGLE_OFF_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        int xx = x - 12;
        RealmsScreen.blit((int)(xx * 2), (int)(y * 2), (float)0.0f, (float)0.0f, (int)32, (int)16, (float)32.0f, (float)16.0f);
        GL11.glPopMatrix();
        if (xm >= xx && xm <= xx + 16 && ym >= y && ym <= y + 8) {
            this.toolTip = ConfigureWorldScreen.getLocalizedString((String)"mco.selectServer.openserver");
            this.closeButtonHovered = true;
        }
    }

    private void drawLocked(int x, int y, int xm, int ym) {
        ConfigureWorldScreen.bind((String)OFF_ICON_LOCATION);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        RealmsScreen.blit((int)(x * 2), (int)(y * 2), (float)0.0f, (float)0.0f, (int)15, (int)15, (float)15.0f, (float)15.0f);
        GL11.glPopMatrix();
        if (xm >= x && xm <= x + 9 && ym >= y && ym <= y + 9) {
            this.toolTip = ConfigureWorldScreen.getLocalizedString((String)"mco.selectServer.locked");
        }
    }

    private class InvitedSelectionList
    extends MovableScrolledSelectionList {
        public InvitedSelectionList() {
            super(ConfigureWorldScreen.this.column1_x, ConfigureWorldScreen.this.row(2), ConfigureWorldScreen.this.column_width + 10, ConfigureWorldScreen.this.row(13) - ConfigureWorldScreen.this.row(4), 13, "+");
        }

        @Override
        protected int getNumberOfItems() {
            return ConfigureWorldScreen.this.serverData == null ? 0 : ((ConfigureWorldScreen)ConfigureWorldScreen.this).serverData.players.size();
        }

        @Override
        protected void selectItem(int item, boolean doubleClick) {
            if (ConfigureWorldScreen.this.serverData == null) {
                return;
            }
            if (item >= ((ConfigureWorldScreen)ConfigureWorldScreen.this).serverData.players.size()) {
                return;
            }
            ConfigureWorldScreen.this.selectedInvitedIndex = item;
        }

        @Override
        protected boolean isSelectedItem(int item) {
            return item == ConfigureWorldScreen.this.selectedInvitedIndex;
        }

        @Override
        protected int getMaxPosition() {
            return this.getNumberOfItems() * 13;
        }

        @Override
        protected void renderBackground() {
        }

        @Override
        protected void renderItem(int i, int x, int y, int h, Tezzelator t) {
            if (ConfigureWorldScreen.this.serverData == null) {
                return;
            }
            if (i < ((ConfigureWorldScreen)ConfigureWorldScreen.this).serverData.players.size()) {
                this.renderInvitedItem(i, x, y, h, t);
            }
        }

        @Override
        public void itemClicked(int x, int y, int xm, int ym) {
            int dy = 1;
            int my = y + dy;
            if (xm >= this.x1 - 21 && xm <= this.x1 - 12 && ym >= my && ym <= my + 9) {
                if (ConfigureWorldScreen.this.selectedInvitedIndex >= 0 && ConfigureWorldScreen.this.selectedInvitedIndex < ((ConfigureWorldScreen)ConfigureWorldScreen.this).serverData.players.size()) {
                    String selectedPlayer = ((ConfigureWorldScreen)ConfigureWorldScreen.this).serverData.players.get(ConfigureWorldScreen.this.selectedInvitedIndex).getName();
                    if (ConfigureWorldScreen.this.ops != null) {
                        if (ConfigureWorldScreen.this.ops.contains(selectedPlayer)) {
                            ConfigureWorldScreen.this.deop();
                        } else {
                            ConfigureWorldScreen.this.op();
                        }
                    }
                }
            } else if (xm >= this.x1 - 33 && xm <= this.x1 - 24 && ym >= my && ym <= my + 9 && ConfigureWorldScreen.this.selectedInvitedIndex >= 0 && ConfigureWorldScreen.this.selectedInvitedIndex < ((ConfigureWorldScreen)ConfigureWorldScreen.this).serverData.players.size()) {
                ConfigureWorldScreen.this.uninvite();
            }
        }

        @Override
        protected void buttonClicked() {
            Realms.setScreen((RealmsScreen)new InviteScreen(ConfigureWorldScreen.this.lastScreen, ConfigureWorldScreen.this, ConfigureWorldScreen.this.serverData));
        }

        private void renderInvitedItem(int i, int x, int y, int h, Tezzelator t) {
            String invited = ((ConfigureWorldScreen)ConfigureWorldScreen.this).serverData.players.get(i).getName();
            ConfigureWorldScreen.this.drawString(invited, x + 2 + 12, y + 1, 0xFFFFFF);
            if (ConfigureWorldScreen.this.ops != null && ConfigureWorldScreen.this.ops.contains(invited)) {
                ConfigureWorldScreen.this.drawOpped(this.x1 - 20, y + 1, this.xm, this.ym);
            } else {
                ConfigureWorldScreen.this.drawNormal(this.x1 - 20, y + 1, this.xm, this.ym);
            }
            ConfigureWorldScreen.this.drawRemoveIcon(this.x1 - 32, y + 2, this.xm, this.ym);
            RealmsScreen.bindFace((String)invited);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RealmsScreen.blit((int)(x + 2), (int)(y + 1), (float)8.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)32.0f);
            RealmsScreen.blit((int)(x + 2), (int)(y + 1), (float)40.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)32.0f);
        }
    }
}

