/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.tile;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.helper.NbtHelper;
import de.katzenpapst.amunra.mob.entity.EntityMummyBoss;
import de.katzenpapst.amunra.mob.entity.IAmunRaBoss;
import de.katzenpapst.amunra.tile.ITileDungeonSpawner;
import de.katzenpapst.amunra.vec.Vector3int;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityBossDungeonSpawner
extends TileEntityAdvanced
implements ITileDungeonSpawner {
    protected Class<? extends IAmunRaBoss> bossClass = EntityMummyBoss.class;
    protected IAmunRaBoss boss;
    protected boolean spawned = false;
    protected boolean isBossDefeated = false;
    protected AxisAlignedBB roomArea = null;

    public List<Class<? extends EntityLiving>> getDisabledCreatures() {
        ArrayList<Class<? extends EntityLiving>> list = new ArrayList<Class<? extends EntityLiving>>();
        list.add(EntityEvolvedSkeleton.class);
        list.add(EntityEvolvedZombie.class);
        list.add(EntityEvolvedSpider.class);
        list.add(EntityEvolvedCreeper.class);
        return list;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.roomArea == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.boss != null && ((Entity)this.boss).field_70128_L) {
                this.boss = null;
                this.spawned = false;
            }
            List entitiesInRoom = this.field_145850_b.func_72872_a(EntityLivingBase.class, this.roomArea);
            int numPlayers = 0;
            boolean isBossInRoom = false;
            for (Entity ent : entitiesInRoom) {
                if (ent instanceof EntityPlayer) {
                    ++numPlayers;
                    continue;
                }
                if (this.bossClass.isInstance(ent)) {
                    IAmunRaBoss curBoss = (IAmunRaBoss)ent;
                    if (this.boss == null && curBoss.getSpawner() == this) {
                        this.boss = curBoss;
                        isBossInRoom = true;
                        continue;
                    }
                    if (this.boss == null || !this.boss.equals(curBoss)) continue;
                    isBossInRoom = true;
                    continue;
                }
                if (!this.getDisabledCreatures().contains(ent.getClass())) continue;
                ent.func_70106_y();
            }
            if (numPlayers > 0) {
                if (this.boss == null && !this.isBossDefeated && !this.spawned) {
                    try {
                        Constructor<? extends IAmunRaBoss> c = this.bossClass.getConstructor(World.class);
                        this.boss = c.newInstance(this.field_145850_b);
                        ((Entity)this.boss).func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.0, (double)this.field_145849_e + 0.5);
                        this.boss.setRoomArea(this.roomArea);
                        this.boss.setSpawner(this);
                        this.spawned = true;
                        isBossInRoom = true;
                        this.field_145850_b.func_72838_d((Entity)this.boss);
                    }
                    catch (Exception e) {
                        AmunRa.LOGGER.warn("Failed to spawn boss", (Throwable)e);
                    }
                }
            } else if (this.boss != null && !this.isBossDefeated && this.spawned) {
                this.boss.despawnBoss();
                this.boss = null;
                this.spawned = false;
            }
            if (!isBossInRoom && this.spawned && this.boss != null) {
                this.boss.despawnBoss();
                this.boss = null;
                this.spawned = false;
            }
        }
    }

    public void playSpawnSound(Entity entity) {
        this.field_145850_b.func_72956_a(entity, GalacticraftCore.TEXTURE_PREFIX + "ambience.scaryscape", 9.0f, 1.4f);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.spawned = compound.func_74767_n("spawned");
        this.isBossDefeated = compound.func_74767_n("defeated");
        try {
            this.bossClass = Class.forName(compound.func_74779_i("bossClass"));
        }
        catch (Exception e) {
            AmunRa.LOGGER.warn("Failed to parse bossClass from NBT data", (Throwable)e);
        }
        if (compound.func_74764_b("roomArea")) {
            this.roomArea = NbtHelper.readAABB(compound.func_74775_l("roomArea"));
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74757_a("spawned", this.spawned);
        compound.func_74757_a("defeated", this.isBossDefeated);
        if (this.roomArea != null) {
            compound.func_74782_a("roomArea", (NBTBase)NbtHelper.getAsNBT(this.roomArea));
        }
    }

    @Override
    public void setSpawnedBoss(IAmunRaBoss boss) {
        this.boss = boss;
    }

    @Override
    public IAmunRaBoss getSpawnedBoss() {
        return this.boss;
    }

    @Override
    public Vector3int getBlockPosition() {
        return new Vector3int(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public double getPacketRange() {
        return 0.0;
    }

    public int getPacketCooldown() {
        return 0;
    }

    public boolean isNetworkedTile() {
        return false;
    }

    @Override
    public AxisAlignedBB getRoomArea() {
        return this.roomArea;
    }

    @Override
    public void setRoomArea(AxisAlignedBB aabb) {
        this.roomArea = aabb.func_72329_c();
    }

    @Override
    public void onBossDefeated() {
        this.isBossDefeated = true;
        this.spawned = false;
        this.boss = null;
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void setBossClass(Class<? extends IAmunRaBoss> theClass) {
        this.bossClass = theClass;
    }
}

