/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.mapgen.village;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.block.ARBlocks;
import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.world.mapgen.BaseStructureComponent;
import de.katzenpapst.amunra.world.mapgen.BaseStructureStart;
import de.katzenpapst.amunra.world.mapgen.village.GridVillageComponent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class GridVillageStart
extends BaseStructureStart {
    protected BlockMetaPair pathMaterial = ARBlocks.blockBasaltRegolith;
    protected BlockMetaPair wallMaterial = ARBlocks.blockAluCrate;
    protected BlockMetaPair floorMaterial = ARBlocks.blockSmoothBasalt;
    protected BlockMetaPair fillMaterial = ARBlocks.blockBasaltBrick;
    protected int numGridElements = 0;
    protected int gridSize = 9;
    protected int gridSideLength = 0;
    protected final Map<Integer, GridVillageComponent> componentsByGrid = new HashMap<Integer, GridVillageComponent>();

    public GridVillageStart(World world, int chunkX, int chunkZ, Random rand) {
        super(world, chunkX, chunkZ, rand);
        int startBlockX = CoordHelper.chunkToMinBlock(chunkX) + this.startX;
        int startBlockZ = CoordHelper.chunkToMinBlock(chunkZ) + this.startZ;
        AmunRa.LOGGER.debug("Generating the Village at x={}, z={}", new Object[]{startBlockX, startBlockZ});
    }

    @Override
    public boolean generateChunk(int chunkX, int chunkZ, Block[] arrayOfIDs, byte[] arrayOfMeta) {
        super.generateChunk(chunkX, chunkZ, arrayOfIDs, arrayOfMeta);
        this.drawGrid(chunkX, chunkZ, arrayOfIDs, arrayOfMeta);
        this.drawGridComponents(chunkX, chunkZ, arrayOfIDs, arrayOfMeta);
        return true;
    }

    public void setComponents(List<BaseStructureComponent> components) {
        this.numGridElements = components.size();
        this.gridSideLength = (int)Math.ceil(Math.sqrt(this.numGridElements));
        int effectiveGridSize = this.gridSize + 3;
        int squareWidth = effectiveGridSize * this.gridSideLength;
        int startBlockX = CoordHelper.chunkToMinBlock(this.chunkX) + this.startX;
        int startBlockZ = CoordHelper.chunkToMinBlock(this.chunkZ) + this.startZ;
        this.structBB = new StructureBoundingBox();
        this.structBB.field_78897_a = startBlockX - (int)Math.floor(squareWidth / 2);
        this.structBB.field_78893_d = startBlockX + (int)Math.ceil(squareWidth / 2);
        this.structBB.field_78896_c = startBlockZ - (int)Math.floor(squareWidth / 2);
        this.structBB.field_78892_f = startBlockZ + (int)Math.ceil(squareWidth / 2);
        this.structBB.field_78895_b = 0;
        this.structBB.field_78894_e = 255;
        int totalGridElems = this.gridSideLength * this.gridSideLength;
        for (int i = this.numGridElements; i < totalGridElems; ++i) {
            components.add(GridVillageComponent.DUMMY);
        }
        Collections.shuffle(components, this.rand);
        int gridX = 0;
        int gridZ = 0;
        for (BaseStructureComponent comp : components) {
            if (comp == GridVillageComponent.DUMMY || !(comp instanceof GridVillageComponent)) continue;
            int index = gridX + (gridZ << 8);
            StructureBoundingBox componentBox = new StructureBoundingBox(this.structBB.field_78897_a + effectiveGridSize * gridX + 2, this.structBB.field_78896_c + effectiveGridSize * gridZ + 2, this.structBB.field_78897_a + effectiveGridSize * gridX + 1 + this.gridSize, this.structBB.field_78896_c + effectiveGridSize * gridZ + 1 + this.gridSize);
            componentBox.func_78883_b();
            comp.setStructureBoundingBox(componentBox);
            comp.setCoordMode(this.rand.nextInt(4));
            comp.setParent(this);
            this.componentsByGrid.put(index, (GridVillageComponent)comp);
            if ((gridX = (int)((byte)(gridX + 1))) < this.gridSideLength) continue;
            gridX = 0;
            gridZ = (byte)(gridZ + 1);
        }
    }

    public BlockMetaPair getPathMaterial() {
        return this.pathMaterial;
    }

    public void setPathMaterial(BlockMetaPair pathMaterial) {
        this.pathMaterial = pathMaterial;
    }

    public BlockMetaPair getWallMaterial() {
        return this.wallMaterial;
    }

    public void setWallMaterial(BlockMetaPair wallMaterial) {
        this.wallMaterial = wallMaterial;
    }

    public BlockMetaPair getFloorMaterial() {
        return this.floorMaterial;
    }

    public void setFloorMaterial(BlockMetaPair floorMaterial) {
        this.floorMaterial = floorMaterial;
    }

    public BlockMetaPair getFillMaterial() {
        return this.fillMaterial;
    }

    public void setFillMaterial(BlockMetaPair fillMaterial) {
        this.fillMaterial = fillMaterial;
    }

    protected void drawStuffInGrid(int chunkX, int chunkZ, int gridX, int gridZ, Block[] arrayOfIDs, byte[] arrayOfMeta) {
        int effectiveGridSize = this.gridSize + 3;
        int testX = this.structBB.field_78897_a + effectiveGridSize * gridX + 2;
        int testZ = this.structBB.field_78896_c + effectiveGridSize * gridZ + 2;
        for (int x = 0; x < this.gridSize; ++x) {
            for (int z = 0; z < this.gridSize; ++z) {
                int relX = CoordHelper.abs2rel(testX + x, chunkX);
                int relZ = CoordHelper.abs2rel(testZ + z, chunkZ);
                this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX, relZ, this.wallMaterial.getBlock(), this.wallMaterial.getMetadata());
            }
        }
    }

    protected void drawGrid(int chunkX, int chunkZ, Block[] arrayOfIDs, byte[] arrayOfMeta) {
        int effectiveGridSize = this.gridSize + 3;
        for (int x = this.structBB.field_78897_a; x < this.structBB.field_78893_d; ++x) {
            for (int z = this.structBB.field_78896_c; z < this.structBB.field_78892_f; ++z) {
                int testX = x - this.structBB.field_78897_a;
                int testZ = z - this.structBB.field_78896_c;
                boolean drawX = false;
                boolean drawZ = false;
                if (testX != 0 && testX % effectiveGridSize == 0) {
                    drawX = true;
                }
                if (testZ != 0 && testZ % effectiveGridSize == 0) {
                    drawZ = true;
                }
                if (!drawX && !drawZ) continue;
                int relX = CoordHelper.abs2rel(x, chunkX);
                int relZ = CoordHelper.abs2rel(z, chunkZ);
                if (drawX && drawZ) {
                    this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX - 1, relZ - 1, this.pathMaterial.getBlock(), this.pathMaterial.getMetadata());
                    this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX, relZ - 1, this.pathMaterial.getBlock(), this.pathMaterial.getMetadata());
                    this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX + 1, relZ - 1, this.pathMaterial.getBlock(), this.pathMaterial.getMetadata());
                    this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX - 1, relZ, this.pathMaterial.getBlock(), this.pathMaterial.getMetadata());
                    this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX, relZ, this.pathMaterial.getBlock(), this.pathMaterial.getMetadata());
                    this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX + 1, relZ, this.pathMaterial.getBlock(), this.pathMaterial.getMetadata());
                    this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX - 1, relZ + 1, this.pathMaterial.getBlock(), this.pathMaterial.getMetadata());
                    this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX, relZ + 1, this.pathMaterial.getBlock(), this.pathMaterial.getMetadata());
                    this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX + 1, relZ + 1, this.pathMaterial.getBlock(), this.pathMaterial.getMetadata());
                    continue;
                }
                if (drawX) {
                    this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX - 1, relZ, this.pathMaterial.getBlock(), this.pathMaterial.getMetadata());
                    this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX, relZ, this.pathMaterial.getBlock(), this.pathMaterial.getMetadata());
                    this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX + 1, relZ, this.pathMaterial.getBlock(), this.pathMaterial.getMetadata());
                    continue;
                }
                if (!drawZ) continue;
                this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX, relZ - 1, this.pathMaterial.getBlock(), this.pathMaterial.getMetadata());
                this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX, relZ, this.pathMaterial.getBlock(), this.pathMaterial.getMetadata());
                this.placeBlockOnGround(arrayOfIDs, arrayOfMeta, relX, relZ + 1, this.pathMaterial.getBlock(), this.pathMaterial.getMetadata());
            }
        }
    }

    protected void placeBlockOnGround(Block[] arrayOfIDs, byte[] arrayOfMeta, int relX, int relZ, Block block, int meta) {
        if (relX < 0 || relX >= 16 || relZ < 0 || relZ >= 16) {
            return;
        }
        int y = BaseStructureComponent.getHighestSolidBlock(arrayOfIDs, arrayOfMeta, relX, relZ);
        BaseStructureComponent.placeBlockRel(arrayOfIDs, arrayOfMeta, relX, y - 1, relZ, block, meta);
    }

    protected void drawGridComponents(int chunkX, int chunkZ, Block[] arrayOfIDs, byte[] arrayOfMeta) {
        StructureBoundingBox chunkBox = CoordHelper.getChunkBB(chunkX, chunkZ);
        for (int gridX = 0; gridX < this.gridSideLength; ++gridX) {
            for (int gridZ = 0; gridZ < this.gridSideLength; ++gridZ) {
                GridVillageComponent curComp;
                int index = gridX + (gridZ << 8);
                if (!this.componentsByGrid.containsKey(index) || !(curComp = this.componentsByGrid.get(index)).getStructureBoundingBox().func_78884_a(chunkBox)) continue;
                curComp.generateChunk(chunkX, chunkZ, arrayOfIDs, arrayOfMeta);
            }
        }
    }
}

