/*
 * Decompiled with CFR 0.152.
 */
package portablejim.bbw.core;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;
import portablejim.bbw.BetterBuildersWandsMod;
import portablejim.bbw.basics.EnumFluidLock;
import portablejim.bbw.basics.EnumLock;
import portablejim.bbw.basics.Point3d;
import portablejim.bbw.core.conversion.CustomMapping;
import portablejim.bbw.core.wands.IWand;
import portablejim.bbw.shims.IPlayerShim;
import portablejim.bbw.shims.IWorldShim;

public class WandWorker {
    private final IWand wand;
    private final IPlayerShim player;
    private final IWorldShim world;
    HashSet<Point3d> allCandidates = new HashSet();

    public WandWorker(IWand wand, IPlayerShim player, IWorldShim world) {
        this.wand = wand;
        this.player = player;
        this.world = world;
    }

    public ItemStack getProperItemStack(IWorldShim world, IPlayerShim player, Point3d blockPos) {
        int meta;
        Block block = world.getBlock(blockPos);
        CustomMapping customMapping = BetterBuildersWandsMod.instance.mappingManager.getMapping(block, meta = world.getMetadata(blockPos));
        if (customMapping != null) {
            return customMapping.getItems(world, blockPos);
        }
        String blockString = String.format("%s/%s", Block.field_149771_c.func_148750_c((Object)block), meta);
        if (!BetterBuildersWandsMod.instance.configValues.HARD_BLACKLIST_SET.contains(blockString)) {
            ItemStack exactItemstack = new ItemStack(block, 1, meta);
            if (Item.func_150898_a((Block)block) != null && player.countItems(exactItemstack, false) > 0) {
                return exactItemstack;
            }
            return this.getEquivalentItemStack(blockPos);
        }
        return null;
    }

    public ItemStack getEquivalentItemStack(Point3d blockPos) {
        Item dropped;
        Block block = this.world.getBlock(blockPos);
        int meta = this.world.getMetadata(blockPos);
        ItemStack stack = null;
        String blockString = String.format("%s/%s", Block.field_149771_c.func_148750_c((Object)block), meta);
        if (block.canSilkHarvest(this.world.getWorld(), this.player.getPlayer(), blockPos.x, blockPos.y, blockPos.z, meta)) {
            stack = BetterBuildersWandsMod.instance.blockCache.getStackedBlock(this.world, blockPos);
        } else if (!BetterBuildersWandsMod.instance.configValues.SOFT_BLACKLIST_SET.contains(blockString) && (dropped = block.func_149650_a(meta, new Random(), 0)) != null) {
            stack = new ItemStack(dropped, block.quantityDropped(meta, 0, new Random()), block.func_149692_a(meta));
        }
        return stack;
    }

    private boolean shouldContinue(Point3d currentCandidate, Block targetBlock, int targetMetadata, Block candidateSupportingBlock, int candidateSupportingMeta, AxisAlignedBB blockBB, EnumFluidLock fluidLock, boolean isNBTSensitive, TileEntity targetTile, TileEntity candidateSupportingTile) {
        if (!this.world.blockIsAir(currentCandidate)) {
            Block currrentCandidateBlock = this.world.getBlock(currentCandidate);
            if (fluidLock != EnumFluidLock.IGNORE || currrentCandidateBlock == null || !(currrentCandidateBlock instanceof IFluidBlock) && !(currrentCandidateBlock instanceof BlockLiquid)) {
                return false;
            }
        }
        if (currentCandidate.y >= 255) {
            return false;
        }
        if (!targetBlock.equals(candidateSupportingBlock)) {
            return false;
        }
        if (targetMetadata != candidateSupportingMeta) {
            return false;
        }
        if (!targetBlock.func_149742_c(this.world.getWorld(), currentCandidate.x, currentCandidate.y, currentCandidate.z)) {
            return false;
        }
        if (!targetBlock.func_149718_j(this.world.getWorld(), currentCandidate.x, currentCandidate.y, currentCandidate.z)) {
            return false;
        }
        if (!targetBlock.func_149705_a(this.world.getWorld(), currentCandidate.x, currentCandidate.y, currentCandidate.z, targetMetadata, new ItemStack(candidateSupportingBlock, 1, candidateSupportingMeta))) {
            return false;
        }
        if (isNBTSensitive) {
            if (targetTile == null || candidateSupportingTile == null) {
                return false;
            }
            NBTTagCompound targetNBT = new NBTTagCompound();
            NBTTagCompound candidateSupportingNBT = new NBTTagCompound();
            targetTile.func_145841_b(targetNBT);
            candidateSupportingTile.func_145841_b(candidateSupportingNBT);
            targetNBT.func_82580_o("x");
            targetNBT.func_82580_o("y");
            targetNBT.func_82580_o("z");
            candidateSupportingNBT.func_82580_o("x");
            candidateSupportingNBT.func_82580_o("y");
            candidateSupportingNBT.func_82580_o("z");
            if (!targetNBT.equals((Object)candidateSupportingNBT)) {
                return false;
            }
        }
        return !this.world.entitiesInBox(blockBB);
    }

    public LinkedList<Point3d> getBlockPositionList(Point3d blockLookedAt, ForgeDirection placeDirection, int maxBlocks, EnumLock directionLock, EnumLock faceLock, EnumFluidLock fluidLock, boolean isNBTSensitive) {
        LinkedList<Point3d> candidates = new LinkedList<Point3d>();
        LinkedList<Point3d> toPlace = new LinkedList<Point3d>();
        Block targetBlock = this.world.getBlock(blockLookedAt);
        int targetMetadata = this.world.getMetadata(blockLookedAt);
        TileEntity targetTile = this.world.getTile(blockLookedAt);
        Point3d startingPoint = blockLookedAt.move(placeDirection);
        int directionMaskInt = directionLock.mask;
        int faceMaskInt = faceLock.mask;
        if ((directionLock != EnumLock.HORIZONTAL && directionLock != EnumLock.VERTICAL || placeDirection != ForgeDirection.UP && placeDirection != ForgeDirection.DOWN) && (directionLock != EnumLock.NORTHSOUTH || placeDirection != ForgeDirection.NORTH && placeDirection != ForgeDirection.SOUTH) && (directionLock != EnumLock.EASTWEST || placeDirection != ForgeDirection.EAST && placeDirection != ForgeDirection.WEST)) {
            candidates.add(startingPoint);
        }
        AxisAlignedBB blockBB = targetBlock.func_149668_a(this.world.getWorld(), blockLookedAt.x, blockLookedAt.y, blockLookedAt.z);
        while (candidates.size() > 0 && toPlace.size() < maxBlocks) {
            Point3d currentCandidate = (Point3d)candidates.removeFirst();
            Point3d supportingPoint = currentCandidate.move(placeDirection.getOpposite());
            Block candidateSupportingBlock = this.world.getBlock(supportingPoint);
            int candidateSupportingMeta = this.world.getMetadata(supportingPoint);
            TileEntity candidateSupportingTile = this.world.getTile(supportingPoint);
            AxisAlignedBB candidateBB = blockBB;
            if (candidateBB != null) {
                candidateBB = candidateBB.func_72329_c().func_72317_d((double)(currentCandidate.x - blockLookedAt.x), (double)(currentCandidate.y - blockLookedAt.y), (double)(currentCandidate.z - blockLookedAt.z));
            }
            if (!this.shouldContinue(currentCandidate, targetBlock, targetMetadata, candidateSupportingBlock, candidateSupportingMeta, candidateBB, fluidLock, isNBTSensitive, targetTile, candidateSupportingTile) || !this.allCandidates.add(currentCandidate)) continue;
            toPlace.add(currentCandidate);
            switch (placeDirection) {
                case DOWN: 
                case UP: {
                    if ((faceMaskInt & 2) <= 0) break;
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.NORTH));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.EAST));
                    }
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.SOUTH));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.WEST));
                    }
                    if ((directionMaskInt & 1) <= 0 || (directionMaskInt & 4) <= 0) break;
                    candidates.add(currentCandidate.move(ForgeDirection.NORTH).move(ForgeDirection.EAST));
                    candidates.add(currentCandidate.move(ForgeDirection.NORTH).move(ForgeDirection.WEST));
                    candidates.add(currentCandidate.move(ForgeDirection.SOUTH).move(ForgeDirection.EAST));
                    candidates.add(currentCandidate.move(ForgeDirection.SOUTH).move(ForgeDirection.WEST));
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    if ((faceMaskInt & 1) <= 0) break;
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.UP));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.EAST));
                    }
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.DOWN));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.WEST));
                    }
                    if ((directionMaskInt & 2) <= 0 || (directionMaskInt & 4) <= 0) break;
                    candidates.add(currentCandidate.move(ForgeDirection.UP).move(ForgeDirection.EAST));
                    candidates.add(currentCandidate.move(ForgeDirection.UP).move(ForgeDirection.WEST));
                    candidates.add(currentCandidate.move(ForgeDirection.DOWN).move(ForgeDirection.EAST));
                    candidates.add(currentCandidate.move(ForgeDirection.DOWN).move(ForgeDirection.WEST));
                    break;
                }
                case WEST: 
                case EAST: {
                    if ((faceMaskInt & 4) <= 0) break;
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.UP));
                    }
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.NORTH));
                    }
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.DOWN));
                    }
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(ForgeDirection.SOUTH));
                    }
                    if ((directionMaskInt & 2) <= 0 || (directionMaskInt & 1) <= 0) break;
                    candidates.add(currentCandidate.move(ForgeDirection.UP).move(ForgeDirection.NORTH));
                    candidates.add(currentCandidate.move(ForgeDirection.UP).move(ForgeDirection.SOUTH));
                    candidates.add(currentCandidate.move(ForgeDirection.DOWN).move(ForgeDirection.NORTH));
                    candidates.add(currentCandidate.move(ForgeDirection.DOWN).move(ForgeDirection.SOUTH));
                }
            }
        }
        return toPlace;
    }

    public ArrayList<Point3d> placeBlocks(ItemStack wandItem, LinkedList<Point3d> blockPosList, Point3d originalBlock, ItemStack sourceItems, int side, float hitX, float hitY, float hitZ) {
        ArrayList<Point3d> placedBlocks = new ArrayList<Point3d>();
        for (Point3d blockPos : blockPosList) {
            boolean takeFromInventory;
            CustomMapping mapping = BetterBuildersWandsMod.instance.mappingManager.getMapping(this.world.getBlock(originalBlock), this.world.getMetadata(originalBlock));
            boolean blockPlaceSuccess = mapping != null ? this.world.setBlock(originalBlock, blockPos, mapping.getPlaceBlock(), mapping.getPlaceMeta(), mapping.shouldCopyTileNBT()) : this.world.copyBlock(originalBlock, blockPos);
            if (!blockPlaceSuccess) continue;
            Block block = this.world.getBlock(originalBlock);
            this.world.playPlaceAtBlock(blockPos, block);
            placedBlocks.add(blockPos);
            if (!this.player.isCreative()) {
                this.wand.placeBlock(wandItem, (EntityLivingBase)this.player.getPlayer());
            }
            if (!(takeFromInventory = this.player.useItem(sourceItems, mapping != null && mapping.shouldCopyTileNBT()))) {
                FMLLog.info((String)"BBW takeback: %s", (Object[])new Object[]{blockPos.toString()});
                this.world.setBlockToAir(blockPos);
                placedBlocks.remove(placedBlocks.size() - 1);
                continue;
            }
            block.func_149689_a(this.world.getWorld(), blockPos.x, blockPos.y, blockPos.z, (EntityLivingBase)this.player.getPlayer(), sourceItems);
        }
        return placedBlocks;
    }
}

