/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.misc;

import betterquesting.core.BetterQuesting;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;

public class URIHandlers {
    private static final Map<String, Predicate<URI>> handlers = new ConcurrentHashMap<String, Predicate<URI>>();

    private URIHandlers() {
    }

    public static synchronized void register(String scheme, Predicate<URI> handler) {
        if (handlers.containsKey(scheme)) {
            throw new IllegalArgumentException("duplicate handler");
        }
        handlers.put(scheme, handler);
    }

    public static Predicate<URI> get(String scheme) {
        return handlers.get(scheme);
    }

    static {
        URIHandlers.register("http", new HTTPHandler());
        URIHandlers.register("https", new HTTPHandler());
    }

    private static class HTTPHandler
    implements Predicate<URI> {
        private HTTPHandler() {
        }

        @Override
        public boolean test(final URI uri) {
            if (Minecraft.func_71410_x().field_71474_y.field_74358_q) {
                final GuiScreen oldScreen = Minecraft.func_71410_x().field_71462_r;
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiConfirmOpenLink(new GuiYesNoCallback(){

                    public void func_73878_a(boolean result, int id) {
                        if (result) {
                            HTTPHandler.openURL(uri);
                        }
                        Minecraft.func_71410_x().func_147108_a(oldScreen);
                    }
                }, uri.toString(), 0, false));
            } else {
                HTTPHandler.openURL(uri);
            }
            return true;
        }

        private static void openURL(URI p_146407_1_) {
            try {
                Class<?> oclass = Class.forName("java.awt.Desktop");
                Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                oclass.getMethod("browse", URI.class).invoke(object, p_146407_1_);
            }
            catch (Throwable throwable) {
                BetterQuesting.logger.error("Couldn't open link", throwable);
            }
        }
    }
}

