/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.content;

import betterquesting.api.storage.BQ_Settings;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public enum FormattingTag {
    NOTE("note"),
    WARNING("warn"),
    QUEST("quest"),
    BOLD("bold"),
    ITALIC("italic"),
    UNDERLINE("underline"),
    STRIKETHROUGH("strikethrough"),
    OBFUSCATED("obfuscated"),
    URL("url");

    public static final ImmutableMap<String, FormattingTag> NAME_TO_VALUE_MAP;
    private static final Pattern OPENING_TAG_PATTERN;
    private static final Pattern OPENING_TAG_PARAMS_PATTERN;
    private static final Pattern CLOSING_TAG_PATTERN;
    private static final String BQ_DARK_THEME = "betterquesting:dark";
    private static final String BQ_ENDER_THEME = "betterquesting:ender";
    private static final String BQ_OVERWORLD_THEME = "betterquesting:overworld";
    private static final String BQ_STRONGHOLD_THEME = "betterquesting:stronghold";
    private static final ImmutableMap<FormattingTag, String> DEFAULT_FORMATTING_STRING_MAP;
    private static final ImmutableTable<FormattingTag, String, String> THEME_FORMATTING_STRING_TABLE;
    private static final ImmutableMap<FormattingTag, String> TEXT_FORMATTING_STRING_MAP;
    private final String name;

    private FormattingTag(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getColourFormattingString() {
        return (String)Objects.firstNonNull((Object)((String)THEME_FORMATTING_STRING_TABLE.get((Object)this, (Object)BQ_Settings.curTheme)), (Object)((String)DEFAULT_FORMATTING_STRING_MAP.getOrDefault((Object)this, (Object)"")));
    }

    public String getTextFormattingString() {
        return (String)TEXT_FORMATTING_STRING_MAP.getOrDefault((Object)this, (Object)"");
    }

    public static Optional<TagInstance> parseOpeningTag(String text) {
        Matcher matcher = OPENING_TAG_PATTERN.matcher(text);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        FormattingTag tag = (FormattingTag)((Object)NAME_TO_VALUE_MAP.get((Object)matcher.group(1)));
        if (tag == null) {
            return Optional.empty();
        }
        ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
        String params = matcher.group(2);
        if (!params.isEmpty()) {
            matcher = OPENING_TAG_PARAMS_PATTERN.matcher(params);
            while (matcher.find()) {
                paramsBuilder.put((Object)matcher.group(1), (Object)matcher.group(2));
            }
        }
        return Optional.of(new TagInstance(tag, paramsBuilder.build()));
    }

    public static Optional<FormattingTag> parseClosingTag(String text) {
        Matcher matcher = CLOSING_TAG_PATTERN.matcher(text);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        return Optional.ofNullable((FormattingTag)((Object)NAME_TO_VALUE_MAP.get((Object)matcher.group(1))));
    }

    static {
        NAME_TO_VALUE_MAP = ImmutableMap.copyOf(Arrays.stream(FormattingTag.values()).collect(Collectors.toMap(FormattingTag::getName, Function.identity())));
        OPENING_TAG_PATTERN = Pattern.compile("\\[([0-9a-zA-Z]+)((?: [0-9a-zA-Z]+=[^ ]+)*)]");
        OPENING_TAG_PARAMS_PATTERN = Pattern.compile(" ([0-9a-zA-Z]+)=([^ ]+)");
        CLOSING_TAG_PATTERN = Pattern.compile("\\[/([0-9a-zA-Z]+)]");
        ImmutableMap.Builder defaultFormattingStringMapBuilder = ImmutableMap.builder();
        ImmutableTable.Builder themeFormattingStringTableBuilder = ImmutableTable.builder();
        ImmutableMap.Builder textFormattingStringMapBuilder = ImmutableMap.builder();
        defaultFormattingStringMapBuilder.put((Object)NOTE, (Object)"\u00a73");
        themeFormattingStringTableBuilder.put((Object)NOTE, (Object)BQ_ENDER_THEME, (Object)"\u00a7b");
        themeFormattingStringTableBuilder.put((Object)NOTE, (Object)BQ_OVERWORLD_THEME, (Object)"\u00a7b");
        themeFormattingStringTableBuilder.put((Object)NOTE, (Object)BQ_STRONGHOLD_THEME, (Object)"\u00a7b");
        defaultFormattingStringMapBuilder.put((Object)WARNING, (Object)"\u00a74");
        themeFormattingStringTableBuilder.put((Object)WARNING, (Object)BQ_DARK_THEME, (Object)"\u00a7c");
        themeFormattingStringTableBuilder.put((Object)WARNING, (Object)BQ_OVERWORLD_THEME, (Object)"\u00a7c");
        themeFormattingStringTableBuilder.put((Object)WARNING, (Object)BQ_STRONGHOLD_THEME, (Object)"\u00a7c");
        defaultFormattingStringMapBuilder.put((Object)QUEST, (Object)"\u00a72");
        themeFormattingStringTableBuilder.put((Object)QUEST, (Object)BQ_DARK_THEME, (Object)"\u00a7a");
        themeFormattingStringTableBuilder.put((Object)QUEST, (Object)BQ_OVERWORLD_THEME, (Object)"\u00a7a");
        themeFormattingStringTableBuilder.put((Object)QUEST, (Object)BQ_STRONGHOLD_THEME, (Object)"\u00a7a");
        defaultFormattingStringMapBuilder.put((Object)URL, (Object)"\u00a71");
        themeFormattingStringTableBuilder.put((Object)URL, (Object)BQ_DARK_THEME, (Object)"\u00a79");
        themeFormattingStringTableBuilder.put((Object)URL, (Object)BQ_OVERWORLD_THEME, (Object)"\u00a79");
        themeFormattingStringTableBuilder.put((Object)URL, (Object)BQ_STRONGHOLD_THEME, (Object)"\u00a79");
        textFormattingStringMapBuilder.put((Object)BOLD, (Object)"\u00a7l");
        textFormattingStringMapBuilder.put((Object)ITALIC, (Object)"\u00a7o");
        textFormattingStringMapBuilder.put((Object)UNDERLINE, (Object)"\u00a7n");
        textFormattingStringMapBuilder.put((Object)STRIKETHROUGH, (Object)"\u00a7m");
        textFormattingStringMapBuilder.put((Object)OBFUSCATED, (Object)"\u00a7k");
        textFormattingStringMapBuilder.put((Object)QUEST, (Object)"\u00a7n");
        textFormattingStringMapBuilder.put((Object)URL, (Object)"\u00a7n");
        DEFAULT_FORMATTING_STRING_MAP = defaultFormattingStringMapBuilder.build();
        THEME_FORMATTING_STRING_TABLE = themeFormattingStringTableBuilder.build();
        TEXT_FORMATTING_STRING_MAP = textFormattingStringMapBuilder.build();
    }

    public static class TagInstance {
        private final FormattingTag tag;
        private final ImmutableMap<String, String> params;

        private TagInstance(FormattingTag tag, ImmutableMap<String, String> params) {
            this.tag = tag;
            this.params = params;
        }

        public FormattingTag getTag() {
            return this.tag;
        }

        public ImmutableMap<String, String> getParams() {
            return this.params;
        }
    }
}

