/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.sigil;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.harvest.HarvestRegistry;
import WayofTime.alchemicalWizardry.api.items.interfaces.ArmourUpgrade;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.api.items.interfaces.IHolding;
import WayofTime.alchemicalWizardry.api.items.interfaces.ISigil;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class SigilHarvest
extends EnergyItems
implements IHolding,
ArmourUpgrade,
ISigil {
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon passiveIcon;

    public SigilHarvest() {
        this.field_77777_bU = 1;
        this.setEnergyUsed(AlchemicalWizardry.sigilHarvestCost);
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.harvestsigil.desc"));
        this.addBindingInformation(par1ItemStack, par3List);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:HarvestGoddessSigil_deactivated");
        this.activeIcon = iconRegister.func_94245_a("AlchemicalWizardry:HarvestGoddessSigil_activated");
        this.passiveIcon = iconRegister.func_94245_a("AlchemicalWizardry:HarvestGoddessSigil_deactivated");
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (IBindable.isActive(stack)) {
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        if (par1 == 1) {
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!IBindable.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.func_70093_af()) {
            return par1ItemStack;
        }
        this.toggleSigil(par1ItemStack, par2World, par3EntityPlayer);
        return par1ItemStack;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (!(par3Entity instanceof EntityPlayer) || par2World.field_72995_K) {
            return;
        }
        EntityPlayer par3EntityPlayer = (EntityPlayer)par3Entity;
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        if (IBindable.isActive(par1ItemStack)) {
            int range = 3;
            int verticalRange = 1;
            int posX = (int)Math.round(par3Entity.field_70165_t - 0.5);
            int posY = (int)par3Entity.field_70163_u;
            int posZ = (int)Math.round(par3Entity.field_70161_v - 0.5);
            for (int ix = posX - range; ix <= posX + range; ++ix) {
                for (int iz = posZ - range; iz <= posZ + range; ++iz) {
                    for (int iy = posY - verticalRange; iy <= posY + verticalRange; ++iy) {
                        HarvestRegistry.harvestBlock(par2World, ix, iy, iz);
                    }
                }
            }
        }
        this.checkPassiveDrain(par1ItemStack, par2World, par3EntityPlayer);
    }

    @Override
    public void onArmourUpdate(World world, EntityPlayer player, ItemStack thisItemStack) {
        if (world.field_72995_K) {
            return;
        }
        int range = 3;
        int verticalRange = 1;
        int posX = (int)Math.round(player.field_70165_t - 0.5);
        int posY = (int)player.field_70163_u;
        int posZ = (int)Math.round(player.field_70161_v - 0.5);
        for (int ix = posX - range; ix <= posX + range; ++ix) {
            for (int iz = posZ - range; iz <= posZ + range; ++iz) {
                for (int iy = posY - verticalRange; iy <= posY + verticalRange; ++iy) {
                    HarvestRegistry.harvestBlock(world, ix, iy, iz);
                }
            }
        }
    }

    @Override
    public boolean isUpgrade() {
        return true;
    }

    @Override
    public int getEnergyForTenSeconds() {
        return 500;
    }
}

