/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.manasteel;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISortableTool;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemManasteelShovel
extends ItemSpade
implements IManaUsingItem,
ISortableTool {
    private static final int MANA_PER_DAMAGE = 60;

    public ItemManasteelShovel() {
        this(BotaniaAPI.manasteelToolMaterial, "manasteelShovel");
    }

    public ItemManasteelShovel(Item.ToolMaterial mat, String name) {
        super(mat);
        this.func_77637_a(BotaniaCreativeTab.INSTANCE);
        this.func_77655_b(name);
    }

    public Item func_77655_b(String name) {
        GameRegistry.registerItem((Item)this, (String)name);
        return super.func_77655_b(name);
    }

    public String func_77657_g(ItemStack stack) {
        return super.func_77657_g(stack).replaceAll("item.", "item.botania:");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = IconHelper.forItem(register, (Item)this);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase victim, EntityLivingBase attacker) {
        ToolCommons.damageItem(stack, 1, attacker, 60);
        return true;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        if (block.func_149712_f(world, x, y, z) != 0.0f) {
            ToolCommons.damageItem(stack, 1, entity, 60);
        }
        return true;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float subX, float subY, float subZ) {
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            ToolCommons.damageItem(stack, 1, (EntityLivingBase)player, 60);
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (side != 0 && world.func_147439_a(x, y + 1, z).isAir((IBlockAccess)world, x, y + 1, z) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d)) {
            Block block1 = Blocks.field_150458_ak;
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block1.field_149762_H.func_150498_e(), (block1.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block1.field_149762_H.func_150494_d() * 0.8f);
            if (world.field_72995_K) {
                return true;
            }
            world.func_147449_b(x, y, z, block1);
            ToolCommons.damageItem(stack, 1, (EntityLivingBase)player, 60);
            return true;
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int invSlot, boolean isHeld) {
        if (!world.field_72995_K && entity instanceof EntityPlayer && stack.func_77960_j() > 0 && ManaItemHandler.requestManaExactForTool(stack, (EntityPlayer)entity, 120, true)) {
            stack.func_77964_b(stack.func_77960_j() - 1);
        }
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repairMaterial) {
        return repairMaterial.func_77973_b() == ModItems.manaResource && repairMaterial.func_77960_j() == 0 ? true : super.func_82789_a(stack, repairMaterial);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ISortableTool.ToolType getSortingType(ItemStack stack) {
        return ISortableTool.ToolType.SHOVEL;
    }

    @Override
    public int getSortingPriority(ItemStack stack) {
        return ToolCommons.getToolPriority(stack);
    }
}

