/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.definitions;

import java.util.ArrayList;
import java.util.List;
import stanhebben.zenscript.ZenTokener;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.definitions.ParsedFunctionArgument;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.statements.Statement;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeAny;
import stanhebben.zenscript.util.ZenPosition;

public class ParsedFunction {
    private final ZenPosition position;
    private final String name;
    private final List<ParsedFunctionArgument> arguments;
    private final ZenType returnType;
    private final Statement[] statements;
    private final String signature;

    public ParsedFunction(ZenPosition position, String name, List<ParsedFunctionArgument> arguments, ZenType returnType, Statement[] statements) {
        this.position = position;
        this.name = name;
        this.arguments = arguments;
        this.returnType = returnType;
        this.statements = statements;
        StringBuilder sig = new StringBuilder();
        sig.append("(");
        for (ParsedFunctionArgument argument : arguments) {
            sig.append(argument.getType().getSignature());
        }
        sig.append(")");
        sig.append(returnType.getSignature());
        this.signature = sig.toString();
    }

    public static ParsedFunction parse(ZenTokener parser, IEnvironmentGlobal environment) {
        Statement[] statements;
        parser.next();
        Token tName = parser.required(1, "identifier expected");
        parser.required(30, "( expected");
        ArrayList<ParsedFunctionArgument> arguments = new ArrayList<ParsedFunctionArgument>();
        if (parser.optional(31) == null) {
            Token argName = parser.required(1, "identifier expected");
            ZenType type = ZenTypeAny.INSTANCE;
            if (parser.optional(120) != null) {
                type = ZenType.read(parser, environment);
            }
            arguments.add(new ParsedFunctionArgument(argName.getValue(), type));
            while (parser.optional(11) != null) {
                Token argName2 = parser.required(1, "identifier expected");
                ZenType type2 = ZenTypeAny.INSTANCE;
                if (parser.optional(120) != null) {
                    type2 = ZenType.read(parser, environment);
                }
                arguments.add(new ParsedFunctionArgument(argName2.getValue(), type2));
            }
            parser.required(31, ") expected");
        }
        ZenType type = ZenTypeAny.INSTANCE;
        if (parser.optional(120) != null) {
            type = ZenType.read(parser, environment);
        }
        parser.required(5, "{ expected");
        if (parser.optional(6) != null) {
            statements = new Statement[]{};
        } else {
            ArrayList<Statement> statementsAL = new ArrayList<Statement>();
            while (parser.optional(6) == null) {
                statementsAL.add(Statement.read(parser, environment, type));
            }
            statements = statementsAL.toArray(new Statement[statementsAL.size()]);
        }
        return new ParsedFunction(tName.getPosition(), tName.getValue(), arguments, type, statements);
    }

    public ZenPosition getPosition() {
        return this.position;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public ZenType getReturnType() {
        return this.returnType;
    }

    public List<ParsedFunctionArgument> getArguments() {
        return this.arguments;
    }

    public ZenType[] getArgumentTypes() {
        ZenType[] result = new ZenType[this.arguments.size()];
        for (int i = 0; i < this.arguments.size(); ++i) {
            result[i] = this.arguments.get(i).getType();
        }
        return result;
    }

    public Statement[] getStatements() {
        return this.statements;
    }
}

