/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.liquid.AbstractEnderLiquidConduit;
import crazypants.enderio.conduit.liquid.AbstractLiquidConduit;
import crazypants.enderio.conduit.liquid.FluidFilter;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class EnderLiquidConduitNetwork
extends AbstractConduitNetwork<ILiquidConduit, AbstractEnderLiquidConduit> {
    private final AbstractEnderLiquidConduit.Type type;
    List<NetworkTank> tanks = new ArrayList<NetworkTank>();
    Map<NetworkTankKey, NetworkTank> tankMap = new HashMap<NetworkTankKey, NetworkTank>();
    Map<NetworkTank, TankIterator> iterators;
    boolean filling;

    public EnderLiquidConduitNetwork(AbstractEnderLiquidConduit.Type type) {
        super(AbstractEnderLiquidConduit.class, ILiquidConduit.class);
        this.type = type;
    }

    public void connectionChanged(AbstractEnderLiquidConduit con, ForgeDirection conDir) {
        NetworkTankKey key = new NetworkTankKey(con, conDir);
        NetworkTank tank = new NetworkTank(con, conDir);
        this.tanks.remove(tank);
        this.tankMap.remove(key);
        this.tanks.add(tank);
        this.tankMap.put(key, tank);
    }

    public boolean extractFrom(AbstractEnderLiquidConduit con, ForgeDirection conDir) {
        FluidStack drained;
        NetworkTank tank = this.getTank(con, conDir);
        if (tank == null || !tank.isValid()) {
            return false;
        }
        if (tank.externalTank.getTankInfo(conDir.getOpposite()) != null) {
            for (FluidTankInfo tankInfo : tank.externalTank.getTankInfo(conDir.getOpposite())) {
                int amountAccepted;
                if (tankInfo == null || tankInfo.fluid == null) continue;
                FluidStack tryDrain = tankInfo.fluid.copy();
                tryDrain.amount = this.type.getMaxExtractPerTick();
                FluidStack drained2 = tank.externalTank.drain(conDir.getOpposite(), tryDrain, false);
                if (drained2 == null || drained2.amount <= 0 || !this.matchedFilter(drained2, con, conDir, true) || !tryDrain.isFluidEqual(drained2) || (amountAccepted = this.fillFrom(tank, drained2.copy(), true)) <= 0) continue;
                tryDrain.amount = amountAccepted;
                drained2 = tank.externalTank.drain(conDir.getOpposite(), tryDrain, true);
                if (drained2 == null || drained2.amount <= 0) continue;
                return true;
            }
        }
        if ((drained = tank.externalTank.drain(conDir.getOpposite(), this.type.getMaxExtractPerTick(), false)) == null || drained.amount <= 0 || !this.matchedFilter(drained, con, conDir, true)) {
            return false;
        }
        int amountAccepted = this.fillFrom(tank, drained.copy(), true);
        if (amountAccepted <= 0) {
            return false;
        }
        drained = tank.externalTank.drain(conDir.getOpposite(), amountAccepted, true);
        return drained != null && drained.amount > 0;
    }

    private NetworkTank getTank(AbstractEnderLiquidConduit con, ForgeDirection conDir) {
        return this.tankMap.get(new NetworkTankKey(con, conDir));
    }

    public int fillFrom(AbstractEnderLiquidConduit con, ForgeDirection conDir, FluidStack resource, boolean doFill) {
        return this.fillFrom(this.getTank(con, conDir), resource, doFill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fillFrom(NetworkTank tank, FluidStack resource, boolean doFill) {
        if (this.filling) {
            return 0;
        }
        try {
            this.filling = true;
            if (resource == null || tank == null || !this.matchedFilter(resource, tank.con, tank.conDir, true)) {
                int n = 0;
                return n;
            }
            resource = resource.copy();
            resource.amount = Math.min(resource.amount, this.type.getMaxIoPerTick());
            int filled = 0;
            int remaining = resource.amount;
            TankIterator iterator = this.getIteratorForTank(tank).start();
            while (iterator.hasNext()) {
                NetworkTank target = iterator.next();
                if (target.equals(tank) || !target.con.getOutputColor(target.conDir).equals((Object)tank.con.getInputColor(tank.conDir)) || !target.acceptsOuput || !target.isValid() || !this.matchedFilter(resource, target.con, target.conDir, false)) continue;
                int vol = target.externalTank.fill(target.tankDir, resource.copy(), doFill);
                filled += vol;
                if ((remaining -= vol) <= 0) break;
                resource.amount = remaining;
            }
            if (!tank.con.isRoundRobin(tank.conDir)) {
                iterator.rewind();
            }
            int n = filled;
            return n;
        }
        finally {
            this.filling = false;
        }
    }

    private boolean matchedFilter(FluidStack drained, AbstractEnderLiquidConduit con, ForgeDirection conDir, boolean isInput) {
        if (drained == null || con == null || conDir == null) {
            return false;
        }
        FluidFilter filter = con.getFilter(conDir, isInput);
        if (filter == null || filter.isEmpty()) {
            return true;
        }
        return filter.matchesFilter(drained);
    }

    private TankIterator getIteratorForTank(NetworkTank tank) {
        TankIterator res;
        if (this.iterators == null) {
            this.iterators = new HashMap<NetworkTank, TankIterator>();
        }
        if ((res = this.iterators.get(tank)) == null) {
            res = new TankIterator();
            this.iterators.put(tank, res);
        }
        return res;
    }

    public FluidTankInfo[] getTankInfo(AbstractEnderLiquidConduit con, ForgeDirection conDir) {
        ArrayList<FluidTankInfo> res = new ArrayList<FluidTankInfo>(this.tanks.size());
        NetworkTank tank = this.getTank(con, conDir);
        for (NetworkTank target : this.tanks) {
            FluidTankInfo[] tTanks;
            if (target.equals(tank) || !target.isValid() || (tTanks = target.externalTank.getTankInfo(target.tankDir)) == null) continue;
            for (FluidTankInfo info : tTanks) {
                res.add(info);
            }
        }
        return res.toArray(new FluidTankInfo[res.size()]);
    }

    static class NetworkTankKey {
        ForgeDirection conDir;
        BlockCoord conduitLoc;

        public NetworkTankKey(AbstractEnderLiquidConduit con, ForgeDirection conDir) {
            this(con.getLocation(), conDir);
        }

        public NetworkTankKey(BlockCoord conduitLoc, ForgeDirection conDir) {
            this.conDir = conDir;
            this.conduitLoc = conduitLoc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.conDir == null ? 0 : this.conDir.hashCode());
            result = 31 * result + (this.conduitLoc == null ? 0 : this.conduitLoc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NetworkTankKey other = (NetworkTankKey)obj;
            if (this.conDir != other.conDir) {
                return false;
            }
            return !(this.conduitLoc == null ? other.conduitLoc != null : !this.conduitLoc.equals((Object)other.conduitLoc));
        }
    }

    static class NetworkTank {
        AbstractEnderLiquidConduit con;
        ForgeDirection conDir;
        IFluidHandler externalTank;
        ForgeDirection tankDir;
        BlockCoord conduitLoc;
        boolean acceptsOuput;

        public NetworkTank(AbstractEnderLiquidConduit con, ForgeDirection conDir) {
            this.con = con;
            this.conDir = conDir;
            this.conduitLoc = con.getLocation();
            this.tankDir = conDir.getOpposite();
            this.externalTank = AbstractLiquidConduit.getExternalFluidHandler((IBlockAccess)con.getBundle().getWorld(), this.conduitLoc.getLocation(conDir));
            this.acceptsOuput = con.getConnectionMode(conDir).acceptsOutput();
        }

        public boolean isValid() {
            return this.externalTank != null && this.con.getConnectionMode(this.conDir) != ConnectionMode.DISABLED;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.conDir == null ? 0 : this.conDir.hashCode());
            result = 31 * result + (this.conduitLoc == null ? 0 : this.conduitLoc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NetworkTank other = (NetworkTank)obj;
            if (this.conDir != other.conDir) {
                return false;
            }
            return !(this.conduitLoc == null ? other.conduitLoc != null : !this.conduitLoc.equals((Object)other.conduitLoc));
        }
    }

    private class TankIterator
    implements Iterator<NetworkTank> {
        private int index = -1;
        private int currentCount = 0;

        private TankIterator() {
        }

        public TankIterator start() {
            this.currentCount = 0;
            return this;
        }

        @Override
        public boolean hasNext() {
            return !EnderLiquidConduitNetwork.this.tanks.isEmpty() && this.currentCount < EnderLiquidConduitNetwork.this.tanks.size();
        }

        @Override
        public NetworkTank next() {
            if (EnderLiquidConduitNetwork.this.tanks.isEmpty()) {
                return null;
            }
            ++this.currentCount;
            ++this.index;
            if (this.index >= EnderLiquidConduitNetwork.this.tanks.size()) {
                this.index = 0;
            }
            return EnderLiquidConduitNetwork.this.tanks.get(this.index);
        }

        @Override
        public void remove() {
        }

        public void rewind() {
            this.index = this.index == 0 ? EnderLiquidConduitNetwork.this.tanks.size() - 1 : --this.index;
            --this.currentCount;
        }
    }
}

