/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.render;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vertex;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.render.ConduitBundleRenderer;
import crazypants.enderio.conduit.render.ConduitRenderer;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class DefaultConduitRenderer
implements ConduitRenderer {
    public static final ThreadLocal<ConduitRenderer> instance = ThreadLocal.withInitial(DefaultConduitRenderer::new);
    protected float transmissionScaleFactor;

    @Override
    public void renderEntity(ConduitBundleRenderer conduitBundleRenderer, IConduitBundle te, IConduit conduit, double x, double y, double z, float partialTick, float worldLight, RenderBlocks rb) {
        Collection<CollidableComponent> components = conduit.getCollidableComponents();
        Tessellator tessellator = Tessellator.field_78398_a;
        this.transmissionScaleFactor = conduit.getTransmitionGeometryScale();
        if (!rb.func_147744_b()) {
            for (CollidableComponent component : components) {
                IIcon tex;
                if (!this.renderComponent(component)) continue;
                float selfIllum = Math.max(worldLight, conduit.getSelfIlluminationForState(component));
                if (this.isNSEWUD(component.dir) && conduit.getTransmitionTextureForState(component) != null) {
                    tessellator.func_78380_c((int)worldLight);
                    tex = conduit.getTransmitionTextureForState(component);
                    this.renderTransmission(conduit, tex, component, selfIllum);
                }
                if ((tex = conduit.getTextureForState(component)) == null) continue;
                tessellator.func_78380_c((int)worldLight);
                this.renderConduit(tex, conduit, component, selfIllum);
            }
        }
    }

    protected void renderConduit(IIcon tex, IConduit conduit, CollidableComponent component, float brightness) {
        CubeRenderer cr = CubeRenderer.get();
        if (this.isNSEWUD(component.dir)) {
            float scaleFactor = 0.75f;
            float xLen = Math.abs(component.dir.offsetX) == 1 ? 1.0f : scaleFactor;
            float yLen = Math.abs(component.dir.offsetY) == 1 ? 1.0f : scaleFactor;
            float zLen = Math.abs(component.dir.offsetZ) == 1 ? 1.0f : scaleFactor;
            BoundingBox cube = component.bound;
            BoundingBox bb = cube.scale(xLen, yLen, zLen);
            this.drawSection(bb, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h(), component.dir, false, conduit.shouldMirrorTexture());
            if (conduit.getConnectionMode(component.dir) == ConnectionMode.DISABLED) {
                tex = EnderIO.blockConduitBundle.getConnectorIcon(component.data);
                List corners = component.bound.getCornersWithUvForFace(component.dir, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h());
                for (Vertex c : corners) {
                    cr.addVecWithUV(c.xyz, (double)c.uv.x, (double)c.uv.y);
                }
            }
        } else {
            this.drawSection(component.bound, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h(), component.dir, true);
        }
    }

    protected void renderTransmission(IConduit conduit, IIcon tex, CollidableComponent component, float selfIllum) {
        float scaleFactor = 0.6f;
        float xLen = Math.abs(component.dir.offsetX) == 1 ? 1.0f : scaleFactor;
        float yLen = Math.abs(component.dir.offsetY) == 1 ? 1.0f : scaleFactor;
        float zLen = Math.abs(component.dir.offsetZ) == 1 ? 1.0f : scaleFactor;
        BoundingBox cube = component.bound;
        BoundingBox bb = cube.scale(xLen, yLen, zLen);
        this.drawSection(bb, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h(), component.dir, false);
    }

    protected boolean renderComponent(CollidableComponent component) {
        return true;
    }

    protected boolean isNSEWUD(ForgeDirection dir) {
        return dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH || dir == ForgeDirection.EAST || dir == ForgeDirection.WEST || dir == ForgeDirection.UP || dir == ForgeDirection.DOWN;
    }

    protected void drawSection(BoundingBox bound, float minU, float maxU, float minV, float maxV, ForgeDirection dir, boolean isTransmission) {
        this.drawSection(bound, minU, maxU, minV, maxV, dir, isTransmission, true);
    }

    protected void drawSection(BoundingBox bound, float minU, float maxU, float minV, float maxV, ForgeDirection dir, boolean isTransmission, boolean mirrorTexture) {
        float cm;
        boolean rotateTopBottom;
        Tessellator tessellator = Tessellator.field_78398_a;
        CubeRenderer cr = CubeRenderer.get();
        if (isTransmission) {
            this.setVerticesForTransmission(bound, dir);
        } else {
            cr.setupVertices(bound);
        }
        if (mirrorTexture && (dir == ForgeDirection.NORTH || dir == ForgeDirection.UP || dir == ForgeDirection.EAST)) {
            float tmp = minU;
            minU = maxU;
            maxU = tmp;
        }
        boolean rotateSides = dir == ForgeDirection.UP || dir == ForgeDirection.DOWN;
        boolean bl = rotateTopBottom = dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH;
        if (dir != ForgeDirection.NORTH && dir != ForgeDirection.SOUTH) {
            float tmp;
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            if (!isTransmission) {
                cm = RenderUtil.getColorMultiplierForFace((ForgeDirection)ForgeDirection.NORTH);
                tessellator.func_78386_a(cm, cm, cm);
            }
            if (rotateSides) {
                cr.addVecWithUV(cr.verts[1], (double)maxU, (double)maxV);
                cr.addVecWithUV(cr.verts[0], (double)maxU, (double)minV);
                cr.addVecWithUV(cr.verts[3], (double)minU, (double)minV);
                cr.addVecWithUV(cr.verts[2], (double)minU, (double)maxV);
            } else {
                cr.addVecWithUV(cr.verts[1], (double)minU, (double)minV);
                cr.addVecWithUV(cr.verts[0], (double)maxU, (double)minV);
                cr.addVecWithUV(cr.verts[3], (double)maxU, (double)maxV);
                cr.addVecWithUV(cr.verts[2], (double)minU, (double)maxV);
            }
            if (dir == ForgeDirection.WEST || dir == ForgeDirection.EAST) {
                tmp = minU;
                minU = maxU;
                maxU = tmp;
            }
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            if (!isTransmission) {
                cm = RenderUtil.getColorMultiplierForFace((ForgeDirection)ForgeDirection.SOUTH);
                tessellator.func_78386_a(cm, cm, cm);
            }
            if (rotateSides) {
                cr.addVecWithUV(cr.verts[4], (double)maxU, (double)maxV);
                cr.addVecWithUV(cr.verts[5], (double)maxU, (double)minV);
                cr.addVecWithUV(cr.verts[6], (double)minU, (double)minV);
                cr.addVecWithUV(cr.verts[7], (double)minU, (double)maxV);
            } else {
                cr.addVecWithUV(cr.verts[4], (double)minU, (double)minV);
                cr.addVecWithUV(cr.verts[5], (double)maxU, (double)minV);
                cr.addVecWithUV(cr.verts[6], (double)maxU, (double)maxV);
                cr.addVecWithUV(cr.verts[7], (double)minU, (double)maxV);
            }
            if (dir == ForgeDirection.WEST || dir == ForgeDirection.EAST) {
                tmp = minU;
                minU = maxU;
                maxU = tmp;
            }
        }
        if (dir != ForgeDirection.UP && dir != ForgeDirection.DOWN) {
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            if (!isTransmission) {
                cm = RenderUtil.getColorMultiplierForFace((ForgeDirection)ForgeDirection.UP);
                tessellator.func_78386_a(cm, cm, cm);
            }
            if (rotateTopBottom) {
                cr.addVecWithUV(cr.verts[6], (double)maxU, (double)maxV);
                cr.addVecWithUV(cr.verts[2], (double)minU, (double)maxV);
                cr.addVecWithUV(cr.verts[3], (double)minU, (double)minV);
                cr.addVecWithUV(cr.verts[7], (double)maxU, (double)minV);
            } else {
                cr.addVecWithUV(cr.verts[6], (double)minU, (double)minV);
                cr.addVecWithUV(cr.verts[2], (double)minU, (double)maxV);
                cr.addVecWithUV(cr.verts[3], (double)maxU, (double)maxV);
                cr.addVecWithUV(cr.verts[7], (double)maxU, (double)minV);
            }
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            if (!isTransmission) {
                cm = RenderUtil.getColorMultiplierForFace((ForgeDirection)ForgeDirection.DOWN);
                tessellator.func_78386_a(cm, cm, cm);
            }
            if (rotateTopBottom) {
                cr.addVecWithUV(cr.verts[0], (double)minU, (double)minV);
                cr.addVecWithUV(cr.verts[1], (double)minU, (double)maxV);
                cr.addVecWithUV(cr.verts[5], (double)maxU, (double)maxV);
                cr.addVecWithUV(cr.verts[4], (double)maxU, (double)minV);
            } else {
                cr.addVecWithUV(cr.verts[0], (double)maxU, (double)maxV);
                cr.addVecWithUV(cr.verts[1], (double)minU, (double)maxV);
                cr.addVecWithUV(cr.verts[5], (double)minU, (double)minV);
                cr.addVecWithUV(cr.verts[4], (double)maxU, (double)minV);
            }
        }
        if (dir != ForgeDirection.EAST && dir != ForgeDirection.WEST) {
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            if (!isTransmission) {
                cm = RenderUtil.getColorMultiplierForFace((ForgeDirection)ForgeDirection.EAST);
                tessellator.func_78386_a(cm, cm, cm);
            }
            if (rotateSides) {
                cr.addVecWithUV(cr.verts[2], (double)minU, (double)maxV);
                cr.addVecWithUV(cr.verts[6], (double)minU, (double)minV);
                cr.addVecWithUV(cr.verts[5], (double)maxU, (double)minV);
                cr.addVecWithUV(cr.verts[1], (double)maxU, (double)maxV);
            } else {
                cr.addVecWithUV(cr.verts[2], (double)minU, (double)maxV);
                cr.addVecWithUV(cr.verts[6], (double)maxU, (double)maxV);
                cr.addVecWithUV(cr.verts[5], (double)maxU, (double)minV);
                cr.addVecWithUV(cr.verts[1], (double)minU, (double)minV);
            }
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            if (!isTransmission) {
                cm = RenderUtil.getColorMultiplierForFace((ForgeDirection)ForgeDirection.WEST);
                tessellator.func_78386_a(cm, cm, cm);
            }
            if (rotateSides) {
                cr.addVecWithUV(cr.verts[0], (double)maxU, (double)maxV);
                cr.addVecWithUV(cr.verts[4], (double)maxU, (double)minV);
                cr.addVecWithUV(cr.verts[7], (double)minU, (double)minV);
                cr.addVecWithUV(cr.verts[3], (double)minU, (double)maxV);
            } else {
                cr.addVecWithUV(cr.verts[0], (double)minU, (double)minV);
                cr.addVecWithUV(cr.verts[4], (double)maxU, (double)minV);
                cr.addVecWithUV(cr.verts[7], (double)maxU, (double)maxV);
                cr.addVecWithUV(cr.verts[3], (double)minU, (double)maxV);
            }
        }
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
    }

    protected void setVerticesForTransmission(BoundingBox bound, ForgeDirection dir) {
        float xs = dir.offsetX == 0 ? this.transmissionScaleFactor : 1.0f;
        float ys = dir.offsetY == 0 ? this.transmissionScaleFactor : 1.0f;
        float zs = dir.offsetZ == 0 ? this.transmissionScaleFactor : 1.0f;
        CubeRenderer.get().setupVertices(bound.scale(xs, ys, zs));
    }

    public BoundingBox[] toCubes(BoundingBox bb) {
        float width = bb.maxX - bb.minX;
        float height = bb.maxY - bb.minY;
        float depth = bb.maxZ - bb.minZ;
        if (width > 0.0f && height > 0.0f && depth > 0.0f) {
            if (width / depth > 1.5f || depth / width > 1.5f) {
                if (width > depth) {
                    int numSplits = Math.round(width / depth);
                    float newWidth = width / (float)numSplits;
                    BoundingBox[] result = new BoundingBox[numSplits];
                    float lastMax = bb.minX;
                    for (int i = 0; i < numSplits; ++i) {
                        float max = lastMax + newWidth;
                        result[i] = new BoundingBox(lastMax, bb.minY, bb.minZ, max, bb.maxY, bb.maxZ);
                        lastMax = max;
                    }
                    return result;
                }
                int numSplits = Math.round(depth / width);
                float newWidth = depth / (float)numSplits;
                BoundingBox[] result = new BoundingBox[numSplits];
                float lastMax = bb.minZ;
                for (int i = 0; i < numSplits; ++i) {
                    float max = lastMax + newWidth;
                    result[i] = new BoundingBox(bb.minX, bb.minY, lastMax, bb.maxX, bb.maxY, max);
                    lastMax = max;
                }
                return result;
            }
            if ((double)(height / width) > 1.5) {
                int numSplits = Math.round(height / width);
                float newWidth = height / (float)numSplits;
                BoundingBox[] result = new BoundingBox[numSplits];
                float lastMax = bb.minY;
                for (int i = 0; i < numSplits; ++i) {
                    float max = lastMax + newWidth;
                    result[i] = new BoundingBox(bb.minX, lastMax, bb.minZ, bb.maxX, max, bb.maxZ);
                    lastMax = max;
                }
                return result;
            }
        }
        return new BoundingBox[]{bb};
    }
}

