/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelController;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.upgrade.ApiaristArmorUpgrade;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.IDarkSteelUpgrade;
import crazypants.enderio.item.darksteel.upgrade.NaturalistEyeUpgrade;
import crazypants.enderio.item.darksteel.upgrade.TrackmanGogglesUpgrade;
import crazypants.enderio.thaumcraft.GogglesOfRevealingUpgrade;
import forestry.api.apiculture.IArmorApiarist;
import forestry.api.core.IArmorNaturalist;
import java.util.Iterator;
import java.util.List;
import mods.railcraft.api.core.items.IToolGoggles;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemGoggles;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import thaumcraft.api.IGoggles;
import thaumcraft.api.IVisDiscountGear;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.nodes.IRevealer;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.IGoggles", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.IVisDiscountGear", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.nodes.IRevealer", modid="Thaumcraft"), @Optional.Interface(iface="mods.railcraft.api.core.items.IToolGoggles", modid="Railcraft"), @Optional.Interface(iface="forestry.api.apiculture.IArmorApiarist", modid="Forestry"), @Optional.Interface(iface="forestry.api.core.IArmorNaturalist", modid="Forestry")})
public class ItemDarkSteelArmor
extends ItemArmor
implements IEnergyContainerItem,
ISpecialArmor,
IAdvancedTooltipProvider,
IDarkSteelItem,
IGoggles,
IRevealer,
IVisDiscountGear,
IArmorApiarist,
IArmorNaturalist,
IToolGoggles {
    public static final ItemArmor.ArmorMaterial MATERIAL = EnumHelper.addArmorMaterial((String)"darkSteel", (int)35, (int[])new int[]{2, 6, 5, 2}, (int)15);
    public static final int[] CAPACITY = new int[]{Config.darkSteelPowerStorageBase, Config.darkSteelPowerStorageBase, Config.darkSteelPowerStorageBase * 2, Config.darkSteelPowerStorageBase * 2};
    public static final int[] RF_PER_DAMAGE_POINT = new int[]{Config.darkSteelPowerStorageBase, Config.darkSteelPowerStorageBase, Config.darkSteelPowerStorageBase * 2, Config.darkSteelPowerStorageBase * 2};
    public static final String[] NAMES = new String[]{"helmet", "chestplate", "leggings", "boots"};
    boolean gogglesUgradeActive = true;
    protected int powerPerDamagePoint;
    protected String name;

    public static ItemDarkSteelArmor forArmorType(int armorType) {
        switch (armorType) {
            case 0: {
                return DarkSteelItems.itemDarkSteelHelmet;
            }
            case 1: {
                return DarkSteelItems.itemDarkSteelChestplate;
            }
            case 2: {
                return DarkSteelItems.itemDarkSteelLeggings;
            }
            case 3: {
                return DarkSteelItems.itemDarkSteelBoots;
            }
        }
        return null;
    }

    public static int getPoweredProtectionIncrease(int armorType) {
        switch (armorType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public static ItemDarkSteelArmor create(int armorType) {
        ItemDarkSteelArmor res = new ItemDarkSteelArmor(armorType);
        res.init();
        return res;
    }

    public ItemDarkSteelArmor(int armorType) {
        this(MATERIAL, "darkSteel", armorType);
        this.powerPerDamagePoint = Config.darkSteelPowerStorageBase / MATERIAL.func_78046_a(armorType);
    }

    public ItemDarkSteelArmor(ItemArmor.ArmorMaterial mat, String name, int armorType) {
        super(mat, 0, armorType);
        this.name = name;
        this.func_77637_a(EnderIOTab.tabEnderIO);
        String str = name + "_" + NAMES[armorType];
        this.func_77655_b(str);
        this.func_111206_d(EnderIO.DOMAIN + ":" + str);
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        Iterator<IDarkSteelUpgrade> iter = DarkSteelRecipeManager.instance.recipeIterator();
        while (iter.hasNext()) {
            IDarkSteelUpgrade upgrade = iter.next();
            if (upgrade instanceof EnergyUpgrade || !upgrade.canAddToItem(is)) continue;
            upgrade.writeToItem(is);
        }
        par3List.add(is);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        switch (this.field_77881_a) {
            case 0: {
                return 5;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 7;
            }
            case 3: {
                return 4;
            }
        }
        return 4;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgrade.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(EnumChatFormatting.WHITE + EnderIO.lang.localize("item." + this.name + "_armor.tooltip.line1"));
            list.add(EnumChatFormatting.WHITE + EnderIO.lang.localize("item." + this.name + "_armor.tooltip.line2"));
            if (DarkSteelItems.isArmorPart(itemstack.func_77973_b(), 3)) {
                list.add(EnumChatFormatting.WHITE + EnderIO.lang.localize("item." + this.name + "_boots.tooltip.line1"));
                list.add(EnumChatFormatting.WHITE + EnderIO.lang.localize("item." + this.name + "_boots.tooltip.line2"));
            }
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public String getArmorTexture(ItemStack itemStack, Entity entity, int slot, String layer) {
        if (this.field_77881_a == 2) {
            return "enderio:textures/models/armor/" + this.name + "_layer_2.png";
        }
        return "enderio:textures/models/armor/" + this.name + "_layer_1.png";
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, armor.func_77958_k() + 1 - armor.func_77960_j());
        }
        double damageRatio = this.field_77879_b + (this.getEnergyStored(armor) > 0 ? ItemDarkSteelArmor.getPoweredProtectionIncrease(3 - slot) : 0);
        ISpecialArmor.ArmorProperties ap = new ISpecialArmor.ArmorProperties(0, damageRatio /= 25.0, armor.func_77958_k() + 1 - armor.func_77960_j());
        return ap;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        ItemDarkSteelArmor arm = ItemDarkSteelArmor.forArmorType(3 - slot);
        int powerBonus = this.getEnergyStored(armor) > 0 ? ItemDarkSteelArmor.getPoweredProtectionIncrease(3 - slot) : 0;
        return arm.func_82812_d().func_78044_b(3 - slot) + powerBonus;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower(stack) && eu.getEnergy() > 0) {
            eu.extractEnergy(damage * this.powerPerDamagePoint, false);
        } else {
            stack.func_77972_a(damage, entity);
        }
        if (eu != null) {
            eu.writeToItem(stack);
        }
    }

    public boolean func_82789_a(ItemStack i1, ItemStack i2) {
        return false;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return EnergyUpgrade.receiveEnergy(container, maxReceive, simulate);
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return EnergyUpgrade.extractEnergy(container, maxExtract, simulate);
    }

    public int getEnergyStored(ItemStack container) {
        return EnergyUpgrade.getEnergyStored(container);
    }

    public int getMaxEnergyStored(ItemStack container) {
        return EnergyUpgrade.getMaxEnergyStored(container);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showNodes(ItemStack itemstack, EntityLivingBase player) {
        if (itemstack == null || itemstack.func_77973_b() == null || !this.gogglesUgradeActive) {
            return false;
        }
        return GogglesOfRevealingUpgrade.loadFromItem(itemstack) != null;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        if (itemstack == null || itemstack.func_77973_b() == null || !this.gogglesUgradeActive) {
            return false;
        }
        return GogglesOfRevealingUpgrade.loadFromItem(itemstack) != null;
    }

    @Optional.Method(modid="Thaumcraft")
    public int getVisDiscount(ItemStack stack, EntityPlayer player, Aspect aspect) {
        if (stack == null || !DarkSteelItems.isArmorPart(stack.func_77973_b(), 0)) {
            return 0;
        }
        return GogglesOfRevealingUpgrade.isUpgradeEquipped(player) ? 5 : 0;
    }

    public boolean isGogglesUgradeActive() {
        return this.gogglesUgradeActive;
    }

    public void setGogglesUgradeActive(boolean gogglesUgradeActive) {
        this.gogglesUgradeActive = gogglesUgradeActive;
    }

    public boolean protectEntity(EntityLivingBase entity, ItemStack armor, String cause, boolean doProtect) {
        return ApiaristArmorUpgrade.loadFromItem(armor) != null;
    }

    @Optional.Method(modid="Forestry")
    public boolean protectPlayer(EntityPlayer player, ItemStack armor, String cause, boolean doProtect) {
        return ApiaristArmorUpgrade.loadFromItem(armor) != null;
    }

    @Optional.Method(modid="Forestry")
    public boolean canSeePollination(EntityPlayer player, ItemStack armor, boolean doSee) {
        if (armor == null || !DarkSteelItems.isArmorPart(armor.func_77973_b(), 0)) {
            return false;
        }
        return NaturalistEyeUpgrade.isUpgradeEquipped(player);
    }

    public void incrementAura(ItemStack goggles) {
        if (goggles != null && goggles.func_77973_b() instanceof ItemDarkSteelArmor && DarkSteelItems.isArmorPart(goggles.func_77973_b(), 0)) {
            NBTTagCompound data = goggles.func_77978_p();
            if (data == null) {
                data = new NBTTagCompound();
                goggles.func_77982_d(data);
            }
            byte aura = data.func_74771_c("aura");
            if ((aura = (byte)(aura + 1)) >= ItemGoggles.GoggleAura.VALUES.length) {
                aura = 0;
            }
            data.func_74774_a("aura", aura);
            if (this.getCurrentAura(goggles) == ItemGoggles.GoggleAura.TRACKING && !RailcraftConfig.isTrackingAuraEnabled()) {
                this.incrementAura(goggles);
            }
        }
    }

    @Optional.Method(modid="Railcraft")
    public ItemGoggles.GoggleAura getCurrentAura(ItemStack goggles) {
        if (TrackmanGogglesUpgrade.loadFromItem(goggles) != null) {
            NBTTagCompound data = goggles.func_77978_p();
            if (data != null) {
                return ItemGoggles.GoggleAura.VALUES[data.func_74771_c("aura")];
            }
            return ItemGoggles.GoggleAura.NONE;
        }
        return ItemGoggles.GoggleAura.NONE;
    }

    static {
        FMLCommonHandler.instance().bus().register((Object)DarkSteelController.instance);
        MinecraftForge.EVENT_BUS.register((Object)DarkSteelController.instance);
        MinecraftForge.EVENT_BUS.register((Object)DarkSteelRecipeManager.instance);
    }
}

