/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityPhantomLight
extends TileEntity {
    protected ArrayList<int[]> sources = new ArrayList();
    protected boolean update = true;
    protected boolean removeLightOnUpdate = true;

    public void addSource(int x, int y, int z) {
        for (int[] source : this.sources) {
            if (source[0] != x || source[1] != y || source[2] != z) continue;
            return;
        }
        this.sources.add(new int[]{x, y, z});
        this.removeLightOnUpdate = false;
        this.update = false;
    }

    public void removeSource(int x, int y, int z) {
        for (int[] source : this.sources) {
            if (source[0] != x || source[1] != y || source[2] != z) continue;
            this.sources.remove(source);
            break;
        }
        if (this.sources.isEmpty()) {
            if (!this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.update = true;
            } else {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public void updateAllSources() {
        ArrayList<int[]> sourcesCopy = new ArrayList<int[]>(this.sources);
        for (int[] source : sourcesCopy) {
            TileEntity te = this.field_145850_b.func_147438_o(source[0], source[1], source[2]);
            if (te != null && te instanceof TileEntityMetaFloodlight) {
                ((TileEntityMetaFloodlight)te).toggleUpdateRun();
                continue;
            }
            this.removeSource(source[0], source[1], source[2]);
        }
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("sources")) {
            NBTTagList list = nbtTagCompound.func_150295_c("sources", 11);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.sources.add(list.func_150306_c(i));
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        if (!this.sources.isEmpty()) {
            NBTTagList SourceList = new NBTTagList();
            for (int[] source : this.sources) {
                SourceList.func_74742_a((NBTBase)new NBTTagIntArray(source));
            }
            nbtTagCompound.func_74782_a("sources", (NBTBase)SourceList);
        }
    }

    public boolean canUpdate() {
        return this.update;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_72820_D() % 20L == 11L) {
            if (this.removeLightOnUpdate && this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
            if (this.sources.isEmpty()) {
                if (this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.update = false;
                }
            } else {
                this.update = false;
            }
        }
    }
}

