/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.coremod;

import com.dreammaster.coremod.DownloadProgressConsole;
import com.dreammaster.coremod.DownloadProgressDialog;
import com.dreammaster.coremod.DreamCoreMod;
import com.dreammaster.coremod.IDownloadProgress;
import com.dreammaster.coremod.LetsEncryptAdder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import cpw.mods.fml.relauncher.IFMLCallHook;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DepLoader
implements IFMLCallHook {
    private File mcLocation;
    static final Logger LOGGER = LogManager.getLogger(DepLoader.class);
    private IDownloadProgress dialog = null;

    public void injectData(Map<String, Object> data) {
        this.mcLocation = (File)data.get("mcLocation");
    }

    public Void call() throws Exception {
        boolean downloaded;
        block35: {
            List deps;
            Gson g = new GsonBuilder().disableHtmlEscaping().create();
            File config = new File(this.mcLocation, "config" + File.separator + "dependencies.json");
            if (!config.exists()) {
                LOGGER.info("No dependencies found.");
                return null;
            }
            try (FileReader fr = new FileReader(config);){
                deps = (List)g.fromJson((Reader)fr, new TypeToken<List<Dependency>>(){}.getType());
            }
            if (deps.size() == 0) {
                LOGGER.info("No dependencies found.");
                return null;
            }
            long disabledDepCount = deps.stream().filter(Dependency::isDisabled).count();
            long foundDepCount = deps.stream().filter(Dependency::isFound).count();
            LOGGER.info("Found {} dependencies. {} are disabled, {} are found.", new Object[]{deps.size(), disabledDepCount, foundDepCount});
            downloaded = false;
            Thread netThread = null;
            try {
                this.dialog = DepLoader.createDownloadProgress();
                Thread mainThread = Thread.currentThread();
                this.dialog.setMainThread(mainThread);
                this.precheck(deps);
                int count = 0;
                for (Dependency d : deps) {
                    if (d.isDisabled() || d.isFound()) continue;
                    ++count;
                }
                if (count <= 0) break block35;
                LOGGER.info("{} dependencies to download.", new Object[]{count});
                try {
                    LetsEncryptAdder.addLetsEncryptCertificates();
                }
                catch (Exception e) {
                    LOGGER.warn("Could not ensure Let's Encrypt root certificates are present, downloads might fail on older Java versions.");
                }
                downloaded = true;
                this.dialog.setJobCount(count);
                Downloader downloader = new Downloader(deps);
                netThread = new Thread(downloader);
                netThread.setDaemon(true);
                netThread.start();
                netThread.join();
                if (downloader.e != null) {
                    throw new Exception("Download error", downloader.e);
                }
            }
            catch (InterruptedException e) {
                try {
                    Files.delete(new File(this.mcLocation, ".__gtnh_download_temp__").toPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.dialog != null) {
                    this.dialog.dispose();
                }
                netThread.interrupt();
                netThread.join(500L);
                throw new RuntimeException("Launch cancelled by user");
            }
            catch (Exception e) {
                if (this.dialog != null) {
                    this.dialog.dispose();
                }
                JOptionPane.showMessageDialog(null, "Download of additional files failed. Please refer to log for more info.", "GT: New Horizons", 0);
                throw new RuntimeException("Download of additional files failed. Please refer to log for more info.", e);
            }
            finally {
                if (DreamCoreMod.downloadOnlyOnce) {
                    try (FileWriter fw = new FileWriter(config);){
                        g.toJson((Object)deps, (Appendable)fw);
                    }
                }
            }
        }
        this.dialog.dispose();
        if (downloaded) {
            if (GraphicsEnvironment.isHeadless()) {
                LOGGER.error("Download complete! Please close this dialog now and launch the game from your launcher again to enjoy the pack.");
            } else {
                JOptionPane.showMessageDialog(null, "Download complete! Please close this dialog now and launch the game from your launcher again to enjoy the pack.", "GT: New Horizons", 1);
            }
            throw new RuntimeException("Restart the game please.");
        }
        return null;
    }

    @NotNull
    private static IDownloadProgress createDownloadProgress() {
        if (GraphicsEnvironment.isHeadless()) {
            return new DownloadProgressConsole();
        }
        return new DownloadProgressDialog();
    }

    private void precheck(List<Dependency> deps) {
        for (Dependency dep : deps) {
            File location;
            if (dep.isDisabled() || dep.isFound() || !(location = new File(this.mcLocation, dep.getPath())).exists()) continue;
            if (location.isDirectory()) {
                LOGGER.warn("Directory {} will be removed as it should be a mod jar!", new Object[]{dep.getPath()});
                try {
                    Files.delete(location.toPath());
                    continue;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, String.format("Path %s is expected to be a mod jar, but it is a directory! Please check what's inside manually and move it. This pack cannot continue without that directory removed!", location));
                    throw new RuntimeException(e);
                }
            }
            LOGGER.debug("Dependency {} found locally", new Object[]{dep.getPath()});
            try {
                DepLoader.checkZipFile(location);
            }
            catch (IOException ex) {
                LOGGER.warn("Dependency {} is corrupted. It will be redownloaded", new Object[]{dep.getPath(), ex});
                continue;
            }
            dep.setFound(true);
        }
    }

    private static void checkZipFile(File location) throws IOException {
        String fname = location.getName();
        if (!fname.endsWith(".zip") && !fname.endsWith(".jar")) {
            return;
        }
        try (ZipFile zf = new ZipFile(location);){
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                CheckedInputStream is;
                long len;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || (len = IOUtils.skip((InputStream)(is = new CheckedInputStream(zf.getInputStream(entry), new CRC32())), (long)Long.MAX_VALUE)) == entry.getSize() && is.getChecksum().getValue() == entry.getCrc()) continue;
                throw new IOException("Invalid entry: " + entry);
            }
        }
    }

    private void download(Dependency dep) throws IOException {
        Path downloadTemp = new File(this.mcLocation, ".__gtnh_download_temp__").toPath();
        boolean ok = false;
        for (int i = 0; i < 3; ++i) {
            LOGGER.info("Downloading {} to {} Attempt {}", new Object[]{dep.getUrl(), dep.getPath(), i});
            try (FileChannel fc = FileChannel.open(downloadTemp, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                 ReadableByteChannel net = Channels.newChannel(new URL(dep.getUrl()).openStream());){
                fc.transferFrom(net, 0L, Long.MAX_VALUE);
            }
            try {
                DepLoader.checkZipFile(downloadTemp.toFile());
            }
            catch (IOException e) {
                LOGGER.warn("Downloaded file looks like corrupted.");
                continue;
            }
            ok = true;
            break;
        }
        if (!ok) {
            throw new IOException("Could not download frm " + dep.getUrl() + " to " + dep.getPath());
        }
        Path target = new File(this.mcLocation, dep.getPath()).toPath();
        Path dir = target.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        Files.move(downloadTemp, target, StandardCopyOption.REPLACE_EXISTING);
        this.dialog.progress();
    }

    public static class Dependency {
        private String url;
        private String path;
        private boolean disabled;
        private transient boolean found;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        public boolean isFound() {
            return this.found;
        }

        public void setFound(boolean found) {
            this.found = found;
        }
    }

    private class Downloader
    implements Runnable {
        List<Dependency> deps;
        Exception e = null;

        Downloader(List<Dependency> deps) {
            this.deps = deps;
        }

        @Override
        public void run() {
            try {
                if (this.deps.size() > 0) {
                    for (Dependency dep : this.deps) {
                        if (!dep.isDisabled() && !dep.isFound()) {
                            DepLoader.this.download(dep);
                        }
                        if (!DreamCoreMod.downloadOnlyOnce) continue;
                        dep.setDisabled(true);
                    }
                }
            }
            catch (Exception ex) {
                this.e = ex;
            }
        }
    }
}

