/*
 * Decompiled with CFR 0.152.
 */
package gravisuite;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviSuite;
import gravisuite.Helpers;
import gravisuite.ServerProxy;
import gravisuite.blockCoord;
import gravisuite.keyboard.Keyboard;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemAdvDDrill
extends ItemTool
implements IElectricItem {
    private int maxCharge;
    private int tier;
    private float effPower;
    private float bigHolePower;
    private float normalPower;
    private float lowPower;
    private float ultraLowPower;
    private int maxWorkRange;
    private int energyPerOperation;
    private int energyPerLowOperation;
    private int energyPerUltraLowOperation;
    private int transferLimit;
    public Set mineableBlocks = new HashSet();
    public int soundTicker;
    public int field_77865_bY;
    private static Material[] materials = new Material[]{Material.field_151576_e, Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151571_B};
    public static List<blockCoord> workMatrix = new ArrayList<blockCoord>();

    protected ItemAdvDDrill(Item.ToolMaterial toolMaterial) {
        super(0.0f, toolMaterial, new HashSet());
        this.func_77656_e(27);
        this.maxCharge = 45000;
        this.transferLimit = 500;
        this.tier = 2;
        this.field_77864_a = this.normalPower = 35.0f;
        this.effPower = 35.0f;
        this.bigHolePower = 16.0f;
        this.lowPower = 16.0f;
        this.ultraLowPower = 10.0f;
        this.energyPerOperation = 160;
        this.energyPerLowOperation = 80;
        this.energyPerUltraLowOperation = 50;
        this.field_77865_bY = 1;
        this.maxWorkRange = 1;
        this.func_77637_a(GraviSuite.ic2Tab);
        this.init();
    }

    public boolean createWorkMatrix(World world, EntityPlayer player, int startXPos, int startYPos, int startZPos) {
        MovingObjectPosition clickPos = ItemAdvDDrill.raytraceFromEntity(world, (Entity)player, true, 4.5);
        if (clickPos == null) {
            return false;
        }
        boolean xRange = true;
        boolean yRange = true;
        boolean zRange = true;
        switch (clickPos.field_72310_e) {
            case 0: 
            case 1: {
                yRange = false;
                break;
            }
            case 2: 
            case 3: {
                zRange = false;
                break;
            }
            case 4: 
            case 5: {
                xRange = false;
            }
        }
        workMatrix.clear();
        int xPos = xRange ? startXPos - this.maxWorkRange : startXPos;
        int yPos = yRange ? startYPos - this.maxWorkRange : startYPos;
        int zPos = zRange ? startZPos - this.maxWorkRange : startZPos;
        int blocksCount = this.maxWorkRange * 2 + 1;
        for (int i = 1; i <= blocksCount; ++i) {
            for (int j = 1; j <= blocksCount; ++j) {
                blockCoord newBlockCoord = new blockCoord();
                if (!xRange) {
                    newBlockCoord.X = xPos;
                    newBlockCoord.Y = yPos + i;
                    newBlockCoord.Z = zPos + j;
                }
                if (!yRange) {
                    newBlockCoord.X = xPos + i;
                    newBlockCoord.Y = yPos;
                    newBlockCoord.Z = zPos + j;
                }
                if (!zRange) {
                    newBlockCoord.X = xPos + i;
                    newBlockCoord.Y = yPos + j;
                    newBlockCoord.Z = zPos;
                }
                System.out.println("X: " + newBlockCoord.X + " Y: " + newBlockCoord.Y + " Z: " + newBlockCoord.Z);
                workMatrix.add(newBlockCoord);
            }
        }
        return true;
    }

    public void init() {
        this.mineableBlocks.add(Blocks.field_150349_c);
        this.mineableBlocks.add(Blocks.field_150346_d);
        this.mineableBlocks.add(Blocks.field_150391_bh);
        this.mineableBlocks.add(Blocks.field_150354_m);
        this.mineableBlocks.add(Blocks.field_150351_n);
        this.mineableBlocks.add(Blocks.field_150433_aE);
        this.mineableBlocks.add(Blocks.field_150431_aC);
        this.mineableBlocks.add(Blocks.field_150435_aG);
        this.mineableBlocks.add(Blocks.field_150425_aM);
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel");
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return Items.field_151046_w.canHarvestBlock(block, stack) || Items.field_151046_w.func_150893_a(stack, block) > 1.0f || Items.field_151047_v.canHarvestBlock(block, stack) || Items.field_151047_v.func_150893_a(stack, block) > 1.0f || this.mineableBlocks.contains(block);
    }

    public float getDigSpeed(ItemStack tool, Block block, int meta) {
        if (!ElectricItem.manager.canUse(tool, (double)this.energyPerOperation)) {
            return 1.0f;
        }
        if (this.canHarvestBlock(block, tool)) {
            return this.field_77864_a;
        }
        return 1.0f;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (toolClass.equals("pickaxe") || toolClass.equals("shovel")) {
            return this.field_77862_b.func_77996_d();
        }
        return super.getHarvestLevel(stack, toolClass);
    }

    public boolean hitEntity(ItemStack var1, EntityLiving var2, EntityLiving var3) {
        return true;
    }

    public int getDamageVsEntity(Entity par1Entity) {
        return this.field_77865_bY;
    }

    public boolean isRepairable() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("gravisuite:itemAdvancedDDrill");
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        Integer toolMode = ItemAdvDDrill.readToolMode(stack);
        if (toolMode == 3) {
            MovingObjectPosition mop;
            World world = player.field_70170_p;
            Block block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            Boolean lowPower = false;
            if (block == null) {
                return super.onBlockStartBreak(stack, x, y, z, player);
            }
            float blockHardness = block.func_149712_f(world, x, y, z);
            boolean validStart = false;
            for (int iter = 0; iter < materials.length; ++iter) {
                if (materials[iter] != block.func_149688_o()) continue;
                validStart = true;
                break;
            }
            if (block == Blocks.field_150418_aU) {
                validStart = true;
            }
            if ((mop = ItemAdvDDrill.raytraceFromEntity(world, (Entity)player, true, 4.5)) == null || !validStart) {
                return super.onBlockStartBreak(stack, x, y, z, player);
            }
            int xRange = 1;
            int yRange = 1;
            int zRange = 1;
            switch (mop.field_72310_e) {
                case 0: 
                case 1: {
                    yRange = 0;
                    break;
                }
                case 2: 
                case 3: {
                    zRange = 0;
                    break;
                }
                case 4: 
                case 5: {
                    xRange = 0;
                }
            }
            int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
            for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
                for (int yPos = y - yRange; yPos <= y + yRange; ++yPos) {
                    for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                        if (ElectricItem.manager.canUse(stack, (double)this.energyPerOperation)) {
                            boolean cancelHarvest;
                            float localHardness;
                            Block localBlock = world.func_147439_a(xPos, yPos, zPos);
                            int localMeta = world.func_72805_g(xPos, yPos, zPos);
                            boolean canHarvest = this.canHarvestBlock(block, stack);
                            float f = localHardness = localBlock == null ? Float.MAX_VALUE : localBlock.func_149712_f(world, xPos, yPos, zPos);
                            if (!canHarvest || (cancelHarvest = false) || localBlock == null || localHardness < 0.0f) continue;
                            for (int iter = 0; iter < materials.length; ++iter) {
                                if (materials[iter] != localBlock.func_149688_o() && localBlock != Blocks.field_150418_aU) continue;
                                if (!player.field_71075_bZ.field_75098_d) {
                                    if (localBlock.removedByPlayer(world, player, xPos, yPos, zPos)) {
                                        localBlock.func_149664_b(world, xPos, yPos, zPos, localMeta);
                                    }
                                    int exp = localBlock.getExpDrop((IBlockAccess)world, localMeta, fortune);
                                    localBlock.func_149657_c(world, xPos, yPos, zPos, exp);
                                    localBlock.func_149636_a(world, player, xPos, yPos, zPos, localMeta);
                                    localBlock.func_149681_a(world, xPos, yPos, zPos, localMeta, player);
                                    if (blockHardness > 0.0f) {
                                        this.func_150894_a(stack, world, localBlock, xPos, yPos, zPos, (EntityLivingBase)player);
                                    }
                                    world.func_147479_m(x, y, z);
                                    ElectricItem.manager.use(stack, (double)this.energyPerOperation, (EntityLivingBase)player);
                                    continue;
                                }
                                Helpers.setBlockToAir(world, xPos, yPos, zPos);
                                world.func_147479_m(x, y, z);
                            }
                            continue;
                        }
                        lowPower = true;
                    }
                }
            }
            if (!GraviSuite.isSimulating()) {
                world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
            }
            if (lowPower.booleanValue()) {
                ServerProxy.sendPlayerMessage(player, "Not enough energy to complete this operation !");
            }
            return true;
        }
        return false;
    }

    public boolean func_150894_a(ItemStack itemstack, World world, Block block, int xPos, int yPos, int zPos, EntityLivingBase entityliving) {
        if (!GraviSuite.isSimulating()) {
            return true;
        }
        if (block == null) {
            return false;
        }
        Integer toolMode = ItemAdvDDrill.readToolMode(itemstack);
        if (toolMode == 0) {
            if ((double)block.func_149712_f(world, xPos, yPos, zPos) != 0.0 && entityliving != null) {
                ElectricItem.manager.use(itemstack, (double)this.energyPerOperation, entityliving);
            }
            return true;
        }
        if (toolMode == 1) {
            if ((double)block.func_149712_f(world, xPos, yPos, zPos) != 0.0 && entityliving != null) {
                ElectricItem.manager.use(itemstack, (double)this.energyPerLowOperation, entityliving);
            }
            return true;
        }
        if (toolMode == 2) {
            if ((double)block.func_149712_f(world, xPos, yPos, zPos) != 0.0 && entityliving != null) {
                ElectricItem.manager.use(itemstack, (double)this.energyPerUltraLowOperation, entityliving);
            }
            return true;
        }
        if (toolMode == 3) {
            // empty if block
        }
        return true;
    }

    public static Integer readToolMode(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        Integer toolMode = nbttagcompound.func_74762_e("toolMode");
        if (toolMode < 0 || toolMode > 3) {
            toolMode = 0;
        }
        return toolMode;
    }

    public void saveToolMode(ItemStack itemstack, Integer toolMode) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74768_a("toolMode", toolMode.intValue());
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            Item item;
            ItemStack torchStack = player.field_71071_by.field_70462_a[i];
            if (torchStack == null || !torchStack.func_77977_a().toLowerCase().contains("torch") || !((item = torchStack.func_77973_b()) instanceof ItemBlock)) continue;
            int oldMeta = torchStack.func_77960_j();
            int oldSize = torchStack.field_77994_a;
            boolean result = torchStack.func_77943_a(player, world, x, y, z, side, xOffset, yOffset, zOffset);
            if (player.field_71075_bZ.field_75098_d) {
                torchStack.func_77964_b(oldMeta);
                torchStack.field_77994_a = oldSize;
            } else if (torchStack.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)torchStack);
                player.field_71071_by.field_70462_a[i] = null;
            }
            if (!result) continue;
            return true;
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, xOffset, yOffset, zOffset);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (Keyboard.isModeKeyDown(player)) {
            Integer toolMode = ItemAdvDDrill.readToolMode(itemStack);
            if ((toolMode = Integer.valueOf(toolMode + 1)) > 3) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            if (toolMode == 0) {
                ServerProxy.sendPlayerMessage(player, EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.advDDrill.mode.normal"));
                this.field_77864_a = this.normalPower;
            }
            if (toolMode == 1) {
                ServerProxy.sendPlayerMessage(player, EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.advDDrill.mode.lowPower"));
                this.field_77864_a = this.lowPower;
            }
            if (toolMode == 2) {
                ServerProxy.sendPlayerMessage(player, EnumChatFormatting.AQUA + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.advDDrill.mode.fine"));
                this.field_77864_a = this.ultraLowPower;
            }
            if (toolMode == 3) {
                this.field_77864_a = this.bigHolePower;
                ServerProxy.sendPlayerMessage(player, EnumChatFormatting.LIGHT_PURPLE + Helpers.formatMessage("message.text.mode") + ": " + Helpers.formatMessage("message.advDDrill.mode.bigHoles"));
            }
        }
        return itemStack;
    }

    public static MovingObjectPosition raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += 1.62;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        if (player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, par3, !par3, par3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        Integer toolMode = ItemAdvDDrill.readToolMode(par1ItemStack);
        if (toolMode == 0) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.advDDrill.mode.normal"));
        }
        if (toolMode == 1) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.advDDrill.mode.lowPower"));
        }
        if (toolMode == 2) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.advDDrill.mode.fine"));
        }
        if (toolMode == 3) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.mode") + ": " + EnumChatFormatting.WHITE + Helpers.formatMessage("message.advDDrill.mode.bigHoles"));
        }
    }

    public String getRandomDrillSound() {
        switch (GraviSuite.random.nextInt(4)) {
            case 1: {
                return "drillOne";
            }
            case 2: {
                return "drillTwo";
            }
            case 3: {
                return "drillThree";
            }
        }
        return "drill";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.uncommon;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }
}

