/*
 * Decompiled with CFR 0.152.
 */
package com.github.wohaopa.MyCTMLib;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.util.IIcon;

public class CTMIconManager {
    public IIcon[] icons = new CTMIcon[25];
    public IIcon icon;
    public IIcon iconSmall;
    public IIcon iconAlt;
    private boolean inited = false;

    public CTMIconManager(IIcon iconSmall, IIcon icon, IIcon iconAlt) {
        this.icon = icon;
        this.iconSmall = iconSmall;
        this.iconAlt = iconAlt;
    }

    public CTMIconManager(IIcon iconSmall, IIcon icon) {
        this.icon = icon;
        this.iconSmall = iconSmall;
    }

    public void init() {
        int j;
        int i;
        for (i = 1; i <= 4; ++i) {
            for (j = 0; j < 4; ++j) {
                this.icons[i + j * 4] = new CTMIcon(this.icon, 4, 4, i - 1, j);
            }
        }
        for (i = 1; i <= 2; ++i) {
            for (j = 0; j < 2; ++j) {
                this.icons[i + j * 2 + 16] = new CTMIcon(this.iconSmall, 2, 2, i - 1, j);
            }
        }
        if (this.iconAlt != null) {
            for (i = 1; i <= 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    this.icons[i + j * 2 + 20] = new CTMIcon(this.iconAlt, 2, 2, i - 1, j);
                }
            }
        }
        this.inited = true;
    }

    public IIcon getIcon(int index) {
        if (index > 0 && index < 25) {
            return this.icons[index];
        }
        throw new RuntimeException("Invalid index: " + index);
    }

    public boolean hasInited() {
        return this.inited;
    }

    private static class CTMIcon
    implements IIcon {
        private final int totalWidth;
        private final int totalHeight;
        private final int subTextureX;
        private final int subTextureY;
        private final int gridWidth;
        private final int gridHeight;
        private final IIcon parentIcon;

        private CTMIcon(IIcon parent, int w, int h, int x, int y) {
            this.parentIcon = parent;
            this.gridWidth = w;
            this.gridHeight = h;
            this.subTextureX = x;
            this.subTextureY = y;
            this.totalWidth = this.parentIcon.func_94211_a();
            this.totalHeight = this.parentIcon.func_94216_b();
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94209_e() {
            float parentMinU = this.parentIcon.func_94209_e();
            float parentMaxU = this.parentIcon.func_94212_f();
            return parentMinU + (parentMaxU - parentMinU) * (float)this.subTextureX / (float)this.gridWidth;
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94212_f() {
            float parentMinU = this.parentIcon.func_94209_e();
            float parentMaxU = this.parentIcon.func_94212_f();
            return parentMinU + (parentMaxU - parentMinU) * (float)(this.subTextureX + 1) / (float)this.gridWidth;
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94214_a(double d0) {
            float subUmin = this.func_94209_e();
            float subUmax = this.func_94212_f();
            return (float)((double)subUmin + (double)(subUmax - subUmin) * d0 / 16.0);
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94206_g() {
            float parentMinV = this.parentIcon.func_94206_g();
            float parentMaxV = this.parentIcon.func_94210_h();
            return parentMinV + (parentMaxV - parentMinV) * (float)this.subTextureY / (float)this.gridHeight;
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94210_h() {
            float parentMinV = this.parentIcon.func_94206_g();
            float parentMaxV = this.parentIcon.func_94210_h();
            return parentMinV + (parentMaxV - parentMinV) * (float)(this.subTextureY + 1) / (float)this.gridHeight;
        }

        @SideOnly(value=Side.CLIENT)
        public float func_94207_b(double d0) {
            float subVmin = this.func_94206_g();
            float subVmax = this.func_94210_h();
            return (float)((double)subVmin + (double)(subVmax - subVmin) * d0 / 16.0);
        }

        @SideOnly(value=Side.CLIENT)
        public String func_94215_i() {
            return this.parentIcon.func_94215_i();
        }

        @SideOnly(value=Side.CLIENT)
        public int func_94211_a() {
            return this.totalWidth / this.gridWidth;
        }

        @SideOnly(value=Side.CLIENT)
        public int func_94216_b() {
            return this.totalHeight / this.gridHeight;
        }
    }
}

