/*
 * Decompiled with CFR 0.152.
 */
package com.github.wohaopa.MyCTMLib.mixins;

import com.github.wohaopa.MyCTMLib.MyCTMLib;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;

public class EarlyMixinLoader {
    private static final Map<String, BooleanSupplier> MIXIN_CONFIGS = new LinkedHashMap<String, BooleanSupplier>();
    public static final String LOG_PREFIX = "[MyCTMLib] ";

    public static List<String> getMixinConfigs() {
        return new ArrayList<String>(MIXIN_CONFIGS.keySet());
    }

    public static boolean shouldMixinConfigQueue(String mixinConfig) {
        BooleanSupplier supplier = MIXIN_CONFIGS.get(mixinConfig);
        if (supplier == null) {
            MyCTMLib.LOG.warn("[MyCTMLib] Mixin config {} is not found in config map! It will never be loaded.", new Object[]{mixinConfig});
            return false;
        }
        return supplier.getAsBoolean();
    }

    private static void addMixinCFG(String mixinConfig) {
        MIXIN_CONFIGS.put(mixinConfig, () -> true);
    }

    private static void addMixinCFG(String mixinConfig, BooleanSupplier conditions) {
        MIXIN_CONFIGS.put(mixinConfig, conditions);
    }

    static {
        EarlyMixinLoader.addMixinCFG("mixins.MyCTMLib.early.json");
    }
}

