/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.container;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerNull;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.SlotDisabled;
import appeng.container.slot.SlotRestrictedInput;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import com.github.vfyjxf.nee.block.tile.TilePatternInterface;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerPatternInterface
extends AEBaseContainer
implements IAEAppEngInventory {
    private final AppEngInternalInventory recipeInv;
    private final AppEngInternalInventory patterns;
    private final SlotRestrictedInput[] patternSlots = new SlotRestrictedInput[9];
    private final AppEngSlot[] recipeSlots = new AppEngSlot[10];
    @GuiSync(value=0)
    private int selectedSlotIndex = -1;

    public ContainerPatternInterface(InventoryPlayer playerInventory, TilePatternInterface tile) {
        super(playerInventory, (Object)tile);
        this.recipeInv = tile.getGirdInventory();
        this.patterns = tile.getPatternInventory();
        for (int i = 0; i < this.patterns.func_70302_i_(); ++i) {
            this.patternSlots[i] = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, (IInventory)this.patterns, i, 8 + 18 * i, 95, playerInventory){

                public boolean func_75214_a(ItemStack i) {
                    return false;
                }

                public boolean func_82869_a(EntityPlayer par1EntityPlayer) {
                    return false;
                }
            };
            this.func_75146_a((Slot)this.patternSlots[i]);
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                SlotDisabled slotDisabled = new SlotDisabled((IInventory)this.recipeInv, x + y * 3, 29 + x * 18, 30 + y * 18);
                this.recipeSlots[x + y * 3] = slotDisabled;
                this.func_75146_a((Slot)slotDisabled);
            }
        }
        this.recipeSlots[9] = new SlotDisabled((IInventory)this.recipeInv, 9, 126, 48);
        this.func_75146_a((Slot)this.recipeSlots[9]);
        this.bindPlayerInventory(playerInventory, 0, 115);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.clearRecipe();
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.isValidContainer();
    }

    public Slot getSelectedSlot() {
        return this.selectedSlotIndex >= 0 && this.selectedSlotIndex <= 9 ? this.patternSlots[this.selectedSlotIndex] : null;
    }

    public AppEngInternalInventory getRecipeInventory() {
        return this.recipeInv;
    }

    public int getSelectedSlotIndex() {
        return this.selectedSlotIndex;
    }

    public void setSelectedSlotIndex(int index) {
        ICraftingPatternDetails details;
        ItemStack maybePattern;
        Slot slot;
        this.selectedSlotIndex = index;
        if (Platform.isServer() && (slot = this.getSelectedSlot()) instanceof SlotRestrictedInput && slot.func_75216_d() && (maybePattern = slot.func_75211_c()).func_77973_b() instanceof ICraftingPatternItem && (details = ((ICraftingPatternItem)maybePattern.func_77973_b()).getPatternForItem(maybePattern, this.getTileEntity().func_145831_w())).getInputs().length == 9 && details.getOutputs().length > 0) {
            InventoryCrafting ic = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
            for (int i = 0; i < details.getInputs().length; ++i) {
                IAEItemStack stack = details.getInputs()[i];
                Slot currentSlot = this.func_75147_a((IInventory)this.getRecipeInventory(), i);
                if (currentSlot == null) continue;
                if (stack != null) {
                    ItemStack is = stack.getItemStack();
                    currentSlot.func_75215_d(is);
                    ic.func_70299_a(i, is);
                    continue;
                }
                currentSlot.func_75215_d(null);
            }
            Slot outSlot = this.func_75147_a((IInventory)this.getRecipeInventory(), 9);
            if (outSlot != null) {
                outSlot.func_75215_d(details.getOutput(ic, this.getTileEntity().func_145831_w()));
            }
        }
        this.func_75142_b();
    }

    public void removeCurrentRecipe() {
        Slot patternSlot = this.getSelectedSlot();
        if (patternSlot != null && patternSlot.func_75216_d()) {
            patternSlot.func_75215_d(null);
            this.clearRecipe();
        }
        this.func_75142_b();
    }

    private void clearRecipe() {
        for (AppEngSlot slot : this.recipeSlots) {
            slot.func_75215_d(null);
        }
    }

    public void saveChanges() {
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }
}

