/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.container.implementations.ContainerMEMonitorable;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.github.vfyjxf.nee.utils.ItemUtils;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.ReflectionHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.common.container.ContainerPartArcaneCraftingTerminal;

public class PacketNEIBookmark
implements IMessage {
    private NBTTagCompound bookmarkItems;

    public PacketNEIBookmark() {
    }

    public PacketNEIBookmark(NBTTagCompound bookmarkItems) {
        this.bookmarkItems = bookmarkItems;
    }

    public void fromBytes(ByteBuf buf) {
        this.bookmarkItems = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.bookmarkItems);
    }

    public static final class Handler
    implements IMessageHandler<PacketNEIBookmark, IMessage> {
        public IMessage onMessage(PacketNEIBookmark message, MessageContext ctx) {
            block6: {
                Container container;
                EntityPlayerMP player;
                block5: {
                    player = ctx.getServerHandler().field_147369_b;
                    container = player.field_71070_bA;
                    if (message.bookmarkItems == null) {
                        return null;
                    }
                    if (!(container instanceof ContainerMEMonitorable)) break block5;
                    ContainerMEMonitorable monitorable = (ContainerMEMonitorable)container;
                    IMEMonitor monitor = monitorable.getMonitor();
                    if (monitor == null) break block6;
                    IEnergySource energy = monitorable.getPowerSource();
                    BaseActionSource actionSource = monitorable.getActionSource();
                    for (Object key : message.bookmarkItems.func_150296_c()) {
                        AEItemStack requestStack;
                        IAEItemStack extractedStack;
                        ItemStack bookmarkItem = ItemUtils.loadItemStackFromNBT(message.bookmarkItems.func_74775_l((String)key));
                        bookmarkItem.field_77994_a = this.getFreeStackSize((EntityPlayer)player, bookmarkItem);
                        if (bookmarkItem.field_77994_a <= 0 || (extractedStack = (IAEItemStack)Platform.poweredExtraction((IEnergySource)energy, (IMEInventory)monitor, (IAEStack)(requestStack = AEItemStack.create((ItemStack)bookmarkItem)), (BaseActionSource)actionSource)) == null) continue;
                        InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN).addItems(extractedStack.getItemStack());
                    }
                    break block6;
                }
                if (Loader.isModLoaded((String)"thaumicenergistics") && container instanceof ContainerPartArcaneCraftingTerminal) {
                    ContainerPartArcaneCraftingTerminal act = (ContainerPartArcaneCraftingTerminal)container;
                    IMEMonitor<IAEItemStack> monitor = this.getMonitor(container);
                    IGrid grid = act.getHostGrid();
                    if (grid == null || monitor == null) {
                        return null;
                    }
                    IEnergyGrid energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
                    PlayerSource actionSource = new PlayerSource((EntityPlayer)player, (IActionHost)act.terminal);
                    for (Object key : message.bookmarkItems.func_150296_c()) {
                        AEItemStack requestStack;
                        IAEItemStack extractedStack;
                        ItemStack bookmarkItem = ItemUtils.loadItemStackFromNBT(message.bookmarkItems.func_74775_l((String)key));
                        bookmarkItem.field_77994_a = this.getFreeStackSize((EntityPlayer)player, bookmarkItem);
                        if (bookmarkItem.field_77994_a <= 0 || (extractedStack = (IAEItemStack)Platform.poweredExtraction((IEnergySource)energy, monitor, (IAEStack)(requestStack = AEItemStack.create((ItemStack)bookmarkItem)), (BaseActionSource)actionSource)) == null) continue;
                        InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN).addItems(extractedStack.getItemStack());
                    }
                }
            }
            return null;
        }

        private int getFreeStackSize(EntityPlayer player, ItemStack itemStack) {
            int freeStackSize = 0;
            for (ItemStack slotStack : player.field_71071_by.field_70462_a) {
                if (slotStack == null) {
                    freeStackSize += itemStack.func_77976_d();
                    continue;
                }
                if (!slotStack.func_77969_a(itemStack)) continue;
                freeStackSize += itemStack.func_77976_d() - slotStack.field_77994_a;
            }
            return Math.min(itemStack.field_77994_a, freeStackSize);
        }

        private IMEMonitor<IAEItemStack> getMonitor(Container container) {
            try {
                return (IMEMonitor)ReflectionHelper.findField(container.getClass(), (String[])new String[]{"monitor"}).get(container);
            }
            catch (ReflectionHelper.UnableToFindFieldException | IllegalAccessException throwable) {
                return null;
            }
        }
    }
}

