/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.network.packet;

import com.bymarcin.openglasses.network.Packet;
import com.bymarcin.openglasses.surface.ServerSurface;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class KeyboardInteractOverlayPacket
extends Packet<KeyboardInteractOverlayPacket, IMessage> {
    private UUID playerUUID;
    private int key;
    private char character;

    public KeyboardInteractOverlayPacket(EntityPlayer player, char character, int key) {
        this.playerUUID = player.func_146103_bH().getId();
        this.character = character;
        this.key = key;
    }

    public KeyboardInteractOverlayPacket() {
    }

    @Override
    protected void read() throws IOException {
        this.playerUUID = new UUID(this.readLong(), this.readLong());
        this.key = this.readInt();
        this.character = (char)this.readInt();
    }

    @Override
    protected void write() throws IOException {
        this.writeLong(this.playerUUID.getMostSignificantBits());
        this.writeLong(this.playerUUID.getLeastSignificantBits());
        this.writeInt(this.key);
        this.writeInt(this.character);
    }

    @Override
    protected IMessage executeOnClient() {
        return null;
    }

    @Override
    protected IMessage executeOnServer() {
        ServerSurface.instance.playerHudKeyboardInteract(this.playerUUID, this.character, this.key);
        return null;
    }
}

