/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.surface.widgets.component.world;

import com.bymarcin.openglasses.surface.IRenderableWidget;
import com.bymarcin.openglasses.surface.RenderType;
import com.bymarcin.openglasses.surface.Widget;
import com.bymarcin.openglasses.surface.WidgetType;
import com.bymarcin.openglasses.surface.widgets.core.attribute.I3DPositionable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IAlpha;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IColorizable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IScalable;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IThroughVisibility;
import com.bymarcin.openglasses.surface.widgets.core.attribute.IViewDistance;
import com.bymarcin.openglasses.utils.OGUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class Dot3D
extends Widget
implements IAlpha,
IScalable,
IColorizable,
I3DPositionable,
IThroughVisibility,
IViewDistance {
    float x;
    float y;
    float z;
    int distance = 100;
    float r;
    float g;
    float b;
    boolean isThroughVisibility = true;
    float size = 0.2f;
    float alpha = 0.5f;

    @Override
    public void writeData(ByteBuf buff) {
        buff.writeFloat(this.x);
        buff.writeFloat(this.y);
        buff.writeFloat(this.z);
        buff.writeFloat(this.alpha);
        buff.writeFloat(this.r);
        buff.writeFloat(this.g);
        buff.writeFloat(this.b);
        buff.writeBoolean(this.isThroughVisibility);
        buff.writeInt(this.distance);
        buff.writeFloat(this.size);
    }

    @Override
    public void readData(ByteBuf buff) {
        this.x = buff.readFloat();
        this.y = buff.readFloat();
        this.z = buff.readFloat();
        this.alpha = buff.readFloat();
        this.r = buff.readFloat();
        this.g = buff.readFloat();
        this.b = buff.readFloat();
        this.isThroughVisibility = buff.readBoolean();
        this.distance = buff.readInt();
        this.size = buff.readFloat();
    }

    @Override
    public WidgetType getType() {
        return WidgetType.DOT3D;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderableWidget getRenderable() {
        return new RenderDot3D();
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        this.alpha = (float)alpha;
    }

    @Override
    public void setScale(double scale) {
        this.size = (float)scale;
    }

    @Override
    public double getScale() {
        return this.size;
    }

    @Override
    public void setColor(double d, double e, double f) {
        this.r = (float)d;
        this.g = (float)e;
        this.b = (float)f;
    }

    @Override
    public float getColorR() {
        return this.r;
    }

    @Override
    public float getColorG() {
        return this.g;
    }

    @Override
    public float getColorB() {
        return this.b;
    }

    @Override
    public double getPosX() {
        return this.x;
    }

    @Override
    public double getPosY() {
        return this.y;
    }

    @Override
    public double getPosZ() {
        return this.z;
    }

    @Override
    public void setPos(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
    }

    @Override
    public boolean isVisibleThroughObjects() {
        return this.isThroughVisibility;
    }

    @Override
    public void setVisibleThroughObjects(boolean visible) {
        this.isThroughVisibility = visible;
    }

    @Override
    public int getDistanceView() {
        return this.distance;
    }

    @Override
    public void setDistanceView(int distance) {
        this.distance = distance;
    }

    @SideOnly(value=Side.CLIENT)
    class RenderDot3D
    implements IRenderableWidget {
        final EntityPlayer player;

        RenderDot3D() {
            this.player = Minecraft.func_71410_x().field_71439_g;
        }

        @Override
        public void render(EntityPlayer player, double playerX, double playerY, double playerZ) {
            if (!OGUtils.inRange(playerX, playerY, playerZ, Dot3D.this.x, Dot3D.this.y, Dot3D.this.z, Dot3D.this.distance)) {
                return;
            }
            GL11.glPushMatrix();
            if (Dot3D.this.isThroughVisibility) {
                GL11.glDisable((int)2929);
            } else {
                GL11.glEnable((int)2929);
            }
            GL11.glDisable((int)3553);
            GL11.glTranslated((double)Dot3D.this.x, (double)Dot3D.this.y, (double)Dot3D.this.z);
            GL11.glRotated((double)(-player.field_70177_z), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)player.field_70125_A, (double)1.0, (double)0.0, (double)0.0);
            GL11.glBegin((int)7);
            GL11.glColor4f((float)Dot3D.this.r, (float)Dot3D.this.g, (float)Dot3D.this.b, (float)Dot3D.this.alpha);
            GL11.glVertex3f((float)(Dot3D.this.size / 2.0f), (float)(Dot3D.this.size / 2.0f), (float)0.0f);
            GL11.glVertex3f((float)(Dot3D.this.size / 2.0f), (float)(-Dot3D.this.size / 2.0f), (float)0.0f);
            GL11.glVertex3f((float)(-Dot3D.this.size / 2.0f), (float)(-Dot3D.this.size / 2.0f), (float)0.0f);
            GL11.glVertex3f((float)(-Dot3D.this.size / 2.0f), (float)(Dot3D.this.size / 2.0f), (float)0.0f);
            GL11.glEnd();
            GL11.glPopMatrix();
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2929);
        }

        @Override
        public RenderType getRenderType() {
            return RenderType.WorldLocated;
        }

        @Override
        public boolean shouldWidgetBeRendered() {
            return Dot3D.this.isVisible();
        }
    }
}

