/*
 * Decompiled with CFR 0.152.
 */
package api.player.server;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ServerPlayerBaseSorter {
    private Map<String, Set<String>> explicitInferiors;
    private Map<String, Set<String>> explicitSuperiors;
    private Map<String, Set<String>> directInferiorsMap;
    private Map<String, Set<String>> allInferiors;
    private List<String> withoutSuperiors;
    private final List<String> list;
    private final Map<String, String[]> allBaseSuperiors;
    private final Map<String, String[]> allBaseInferiors;
    private final String methodName;
    private static final Set<String> Empty = new HashSet<String>();

    public ServerPlayerBaseSorter(List<String> list, Map<String, String[]> allBaseSuperiors, Map<String, String[]> allBaseInferiors, String methodName) {
        this.list = list;
        this.allBaseSuperiors = allBaseSuperiors;
        this.allBaseInferiors = allBaseInferiors;
        this.methodName = methodName;
    }

    public void Sort() {
        int i;
        if (this.list.size() <= 1) {
            return;
        }
        if (this.explicitInferiors != null) {
            this.explicitInferiors.clear();
        }
        if (this.explicitSuperiors != null) {
            this.explicitSuperiors.clear();
        }
        if (this.directInferiorsMap != null) {
            this.directInferiorsMap.clear();
        }
        if (this.allInferiors != null) {
            this.allInferiors.clear();
        }
        for (i = 0; i < this.list.size(); ++i) {
            boolean hasSuperiors;
            String baseId = this.list.get(i);
            String[] inferiorNames = this.allBaseInferiors.get(baseId);
            boolean hasInferiors = inferiorNames != null && inferiorNames.length > 0;
            String[] superiorNames = this.allBaseSuperiors.get(baseId);
            boolean bl = hasSuperiors = superiorNames != null && superiorNames.length > 0;
            if ((hasInferiors || hasSuperiors) && this.directInferiorsMap == null) {
                this.directInferiorsMap = new Hashtable<String, Set<String>>();
            }
            if (hasInferiors) {
                this.explicitInferiors = ServerPlayerBaseSorter.build(baseId, this.explicitInferiors, this.directInferiorsMap, null, inferiorNames);
            }
            if (!hasSuperiors) continue;
            this.explicitSuperiors = ServerPlayerBaseSorter.build(baseId, this.explicitSuperiors, null, this.directInferiorsMap, superiorNames);
        }
        if (this.directInferiorsMap != null) {
            for (i = 0; i < this.list.size() - 1; ++i) {
                for (int n = i + 1; n < this.list.size(); ++n) {
                    boolean rightWantsToBeSuperiorToLeft;
                    String left = this.list.get(i);
                    String right = this.list.get(n);
                    Set<String> leftInferiors = null;
                    Set<String> rightInferiors = null;
                    if (this.explicitInferiors != null) {
                        leftInferiors = this.explicitInferiors.get(left);
                        rightInferiors = this.explicitInferiors.get(right);
                    }
                    Set<String> leftSuperiors = null;
                    Set<String> rightSuperiors = null;
                    if (this.explicitSuperiors != null) {
                        leftSuperiors = this.explicitSuperiors.get(left);
                        rightSuperiors = this.explicitSuperiors.get(right);
                    }
                    boolean leftWantsToBeInferiorToRight = leftSuperiors != null && leftSuperiors.contains(right);
                    boolean leftWantsToBeSuperiorToRight = leftInferiors != null && leftInferiors.contains(right);
                    boolean rightWantsToBeInferiorToLeft = rightSuperiors != null && rightSuperiors.contains(left);
                    boolean bl = rightWantsToBeSuperiorToLeft = rightInferiors != null && rightInferiors.contains(left);
                    if (leftWantsToBeInferiorToRight && rightWantsToBeInferiorToLeft) {
                        throw new UnsupportedOperationException("Can not sort ServerPlayerBase classes for method '" + this.methodName + "'. '" + left + "' wants to be inferior to '" + right + "' and '" + right + "' wants to be inferior to '" + left + "'");
                    }
                    if (leftWantsToBeSuperiorToRight && rightWantsToBeSuperiorToLeft) {
                        throw new UnsupportedOperationException("Can not sort ServerPlayerBase classes for method '" + this.methodName + "'. '" + left + "' wants to be superior to '" + right + "' and '" + right + "' wants to be superior to '" + left + "'");
                    }
                    if (leftWantsToBeInferiorToRight && leftWantsToBeSuperiorToRight) {
                        throw new UnsupportedOperationException("Can not sort ServerPlayerBase classes for method '" + this.methodName + "'. '" + left + "' wants to be superior and inferior to '" + right + "'");
                    }
                    if (!rightWantsToBeInferiorToLeft || !rightWantsToBeSuperiorToLeft) continue;
                    throw new UnsupportedOperationException("Can not sort ServerPlayerBase classes for method '" + this.methodName + "'. '" + right + "' wants to be superior and inferior to '" + left + "'");
                }
            }
            if (this.allInferiors == null) {
                this.allInferiors = new Hashtable<String, Set<String>>();
            }
            for (i = 0; i < this.list.size(); ++i) {
                this.build(this.list.get(i), null);
            }
        }
        if (this.withoutSuperiors == null) {
            this.withoutSuperiors = new LinkedList<String>();
        }
        int offset = 0;
        int size = this.list.size();
        while (size > 1) {
            int i2;
            this.withoutSuperiors.clear();
            for (i2 = offset; i2 < offset + size; ++i2) {
                this.withoutSuperiors.add(this.list.get(i2));
            }
            if (this.allInferiors != null) {
                for (i2 = offset; i2 < offset + size; ++i2) {
                    Set<String> inferiors = this.allInferiors.get(this.list.get(i2));
                    if (inferiors == null) continue;
                    this.withoutSuperiors.removeAll(inferiors);
                }
            }
            boolean initial = true;
            for (int i3 = offset; i3 < offset + size; ++i3) {
                String key = this.list.get(i3);
                if (this.withoutSuperiors.contains(key)) {
                    if (initial) {
                        Set<String> inferiors = null;
                        if (this.allInferiors != null) {
                            inferiors = this.allInferiors.get(key);
                        }
                        if (inferiors == null || inferiors.isEmpty()) {
                            this.withoutSuperiors.remove(key);
                            --size;
                            ++offset;
                            continue;
                        }
                    }
                    this.list.remove(i3--);
                    --size;
                }
                initial = false;
            }
            this.list.addAll(offset + size, this.withoutSuperiors);
        }
    }

    private Set<String> build(String type, String startType) {
        Set<String> inferiors = this.allInferiors.get(type);
        if (inferiors == null) {
            inferiors = this.build(type, null, startType != null ? startType : type);
            if (inferiors == null) {
                inferiors = Empty;
            }
            this.allInferiors.put(type, inferiors);
        }
        return inferiors;
    }

    private Set<String> build(String type, Set<String> inferiors, String startType) {
        Set<String> directInferiors = this.directInferiorsMap.get(type);
        if (directInferiors == null) {
            return inferiors;
        }
        if (inferiors == null) {
            inferiors = new HashSet<String>();
        }
        for (String inferiorType : directInferiors) {
            Set<String> inferiorSet;
            if (inferiorType == startType) {
                throw new UnsupportedOperationException("Can not sort ServerPlayerBase classes for method '" + this.methodName + "'. Circular superiosity found including '" + startType + "'");
            }
            if (this.list.contains(inferiorType)) {
                inferiors.add(inferiorType);
            }
            try {
                inferiorSet = this.build(inferiorType, startType);
            }
            catch (UnsupportedOperationException uoe) {
                throw new UnsupportedOperationException("Can not sort ServerPlayerBase classes for method '" + this.methodName + "'. Circular superiosity found including '" + inferiorType + "'", uoe);
            }
            if (inferiorSet == Empty) continue;
            inferiors.addAll(inferiorSet);
        }
        return inferiors;
    }

    private static Map<String, Set<String>> build(String baseId, Map<String, Set<String>> map, Map<String, Set<String>> directMap, Map<String, Set<String>> otherDirectMap, String[] names) {
        if (map == null) {
            map = new Hashtable<String, Set<String>>();
        }
        HashSet<String> types = new HashSet<String>();
        for (int n = 0; n < names.length; ++n) {
            if (names[n] == null) continue;
            types.add(names[n]);
        }
        if (directMap != null) {
            ServerPlayerBaseSorter.getOrCreateSet(directMap, baseId).addAll(types);
        }
        if (otherDirectMap != null) {
            Iterator iter = types.iterator();
            while (iter.hasNext()) {
                ServerPlayerBaseSorter.getOrCreateSet(otherDirectMap, (String)iter.next()).add(baseId);
            }
        }
        map.put(baseId, types);
        return map;
    }

    private static Set<String> getOrCreateSet(Map<String, Set<String>> map, String key) {
        Set<String> value = map.get(key);
        if (value != null) {
            return value;
        }
        value = new HashSet<String>();
        map.put(key, value);
        return value;
    }
}

