/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.lib.vec.BlockCoord;
import codechicken.microblock.FacePlacementGrid;
import gcewing.projectblue.BaseBlockRenderer;
import gcewing.projectblue.ControlItem;
import gcewing.projectblue.ControlPanelMaterial;
import gcewing.projectblue.ControlPanelPart;
import gcewing.projectblue.Matrix3;
import gcewing.projectblue.PBModel;
import gcewing.projectblue.ProjectBlue;
import gcewing.projectblue.Trans3;
import gcewing.projectblue.Trans3GL;
import gcewing.projectblue.Utils;
import gcewing.projectblue.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class ControlPanelRenderer
extends BaseBlockRenderer<Block> {
    static final double h = 0.0625;
    static final double d1 = 0.001;
    static final double d2 = 0.01;
    static float[] sideShading = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    static double[][] colors = new double[][]{{1.0, 1.0, 1.0}, {1.0, 0.5, 0.0}, {1.0, 0.0, 1.0}, {0.5, 0.5, 1.0}, {1.0, 1.0, 0.0}, {0.5, 1.0, 0.5}, {1.0, 0.5, 0.5}, {0.5, 0.5, 0.5}, {0.75, 0.75, 0.75}, {0.0, 1.0, 1.0}, {0.5, 0.0, 1.0}, {0.0, 0.0, 1.0}, {0.5, 0.25, 0.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}, {0.25, 0.25, 0.25}};
    static AxisAlignedBB panelBox = AxisAlignedBB.func_72330_a((double)-0.5, (double)-0.0635, (double)-0.5, (double)0.5, (double)0.0635, (double)0.5);
    static Matrix3[] leverRotations = new Matrix3[]{Matrix3.rotX(45.0), Matrix3.rotX(-45.0)};
    public static ControlPanelRenderer instance;
    static IIcon frontCutoutIcon;
    static IIcon backCutoutIcon;
    static IIcon lampIcon;
    static PBModel leverBaseModel;
    static PBModel leverHandleModel;
    static PBModel buttonModel;
    static PBModel lampModel;
    static PBModel coverModel;
    ControlPanelPart part;
    Phase phase;
    int globalSide;
    float alpha;
    boolean renderingInInventory;
    boolean debugLightVertex = false;

    public static void init() {
        leverBaseModel = ProjectBlue.getModel("lever_base");
        leverHandleModel = ProjectBlue.getModel("lever_handle");
        buttonModel = ProjectBlue.getModel("button");
        lampModel = ProjectBlue.getModel("lamp");
        coverModel = ProjectBlue.getModel("cover");
        instance = new ControlPanelRenderer();
    }

    public static void registerIcons(IIconRegister reg) {
        frontCutoutIcon = reg.func_94245_a("gcewing_projectblue:controlpanel_cutout_front");
        backCutoutIcon = reg.func_94245_a("gcewing_projectblue:controlpanel_cutout_back");
        lampIcon = reg.func_94245_a("gcewing_projectblue:controlpanel_lamp");
        System.out.printf("ControlPanelRenderer.registerIcons: icons = %s %s %s\n", frontCutoutIcon, backCutoutIcon, lampIcon);
    }

    void bindBlockTextures() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
    }

    public void renderStaticInWorld(ControlPanelPart part, double x, double y, double z) {
        this.renderInWorld(part, x, y, z, Phase.STATIC);
    }

    public void renderDynamicInWorld(ControlPanelPart part, double x, double y, double z, float frame) {
        this.bindBlockTextures();
        this.renderInWorld(part, x, y, z, Phase.DYNAMIC);
    }

    public boolean renderHighlight(ControlPanelPart part, DrawBlockHighlightEvent e, BlockCoord pos) {
        EntityPlayer p = e.player;
        Vec3 h = e.target.field_72307_f;
        int side = e.target.field_72310_e;
        float f = e.partialTicks;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glTranslated((double)(-(p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)f)), (double)(-(p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)f)), (double)(-(p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)f)));
        FacePlacementGrid.render((codechicken.lib.vec.Vector3)Utils.ccVector3(h), (int)side);
        this.setup(part.base);
        this.world = p.field_70170_p;
        this.blockX = pos.x;
        this.blockY = pos.y;
        this.blockZ = pos.z;
        Trans3 t = part.localToGlobalTransformation(pos.x, pos.y, pos.z);
        this.phase = Phase.STATIC;
        this.bindBlockTextures();
        GL11.glEnable((int)3042);
        this.alpha = 0.5f;
        this.tess.func_78382_b();
        this.debugLightVertex = true;
        this.renderPart(t);
        this.debugLightVertex = false;
        this.tess.func_78381_a();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
        return true;
    }

    public void renderStack(ItemStack stack, IItemRenderer.ItemRenderType type) {
        ControlPanelMaterial base = ControlPanelMaterial.forStack(stack);
        this.setup(base);
        int side = 2;
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderingInInventory = true;
            side = 3;
        }
        this.part = new ControlPanelPart(base, side, stack.func_77978_p());
        Trans3 t = new Trans3(0.5, 0.5, 0.5).side(this.part.side);
        this.phase = Phase.STATIC;
        this.tess.func_78382_b();
        this.renderPart(t);
        this.tess.func_78381_a();
        this.phase = Phase.DYNAMIC;
        this.renderPart(t);
    }

    public void renderControlItemStack(ItemStack stack, IItemRenderer.ItemRenderType type) {
        this.setup(ControlPanelMaterial.forStack(stack));
        this.renderControlItem((ControlItem)stack.func_77973_b(), stack.func_77960_j(), type);
    }

    void renderControlItem(ControlItem item, int meta, IItemRenderer.ItemRenderType type) {
        this.renderingInInventory = false;
        this.bindBlockTextures();
        Trans3 t = new Trans3(0.5, 0.5, 0.5);
        switch (type) {
            case INVENTORY: {
                this.renderingInInventory = true;
                t = t.side(3).scale(4.0);
                break;
            }
            case EQUIPPED: {
                t = t.side(3).scale(3.0).translate(0.0, 0.2, 0.05);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                t = t.side(2).translate(0.0, -0.5, 0.15);
                break;
            }
            default: {
                t = t.side(2).scale(2.0);
            }
        }
        this.phase = Phase.STATIC;
        this.tess.func_78382_b();
        this.renderControlType(t, item.type, meta);
        this.tess.func_78381_a();
        this.phase = Phase.DYNAMIC;
        this.renderControlType(t, item.type, meta);
    }

    void renderControlType(Trans3 t, ControlPanelPart.ControlType type, int meta) {
        switch (type) {
            case LEVER: {
                this.renderLever(t, meta, 0);
                break;
            }
            case BUTTON: {
                this.renderButton(t, meta, 0);
                break;
            }
            case LAMP: {
                this.renderLamp(t, meta, 0);
                break;
            }
            case BLANK: {
                this.renderCover(t);
            }
        }
    }

    void setup(ControlPanelMaterial base) {
        if (base != null) {
            this.setup(base.block, base.metadata);
        } else {
            this.setup(Blocks.field_150344_f, 0);
        }
    }

    void setup(Block block, int metadata) {
        this.renderingInInventory = false;
        this.part = null;
        this.world = null;
        this.block = block;
        this.metadata = metadata;
        this.blockX = 0;
        this.blockY = 0;
        this.blockZ = 0;
        this.setUpTextureOverride(null);
        this.blockBrightness = 0xF000F0;
        this.setColorMultiplier(0xFFFFFF);
        this.alpha = 1.0f;
        this.tess = Tessellator.field_78398_a;
    }

    void renderInWorld(ControlPanelPart part, double x, double y, double z, Phase phase) {
        this.renderingInInventory = false;
        this.part = part;
        this.phase = phase;
        this.world = part.world();
        this.block = part.base.block;
        this.metadata = part.base.metadata;
        this.blockX = part.x();
        this.blockY = part.y();
        this.blockZ = part.z();
        this.setUpTextureOverride(null);
        this.blockBrightness = this.block.func_149677_c(this.world, this.blockX, this.blockY, this.blockZ);
        this.setColorMultiplier(this.block.func_149720_d(this.world, this.blockX, this.blockY, this.blockZ));
        this.alpha = 1.0f;
        this.tess = Tessellator.field_78398_a;
        this.tess.func_78386_a(1.0f, 1.0f, 1.0f);
        Trans3 t = part.localToGlobalTransformation(x, y, z);
        this.renderPart(t);
    }

    void renderPart(Trans3 t) {
        this.renderPanel(t);
        this.renderLabels(t);
        this.renderControls(t);
    }

    void renderPanel(Trans3 t) {
        switch (this.phase) {
            case STATIC: {
                this.pbtBox(t, panelBox);
                this.renderBackCutouts(t);
            }
        }
    }

    void renderLabels(Trans3 t) {
        if (this.part != null) {
            switch (this.phase) {
                case DYNAMIC: {
                    FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                    GL11.glPushAttrib((int)262208);
                    GL11.glPushMatrix();
                    Trans3GL.glMultTrans3(t);
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.0645);
                    GL11.glScaled((double)0.00625, (double)0.00625, (double)1.0);
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 4; ++j) {
                            for (int k = 0; k < 2; ++k) {
                                String s = this.part.labels[4 * i + j][k];
                                if (s == null) continue;
                                int w = fr.func_78256_a(s) / 2;
                                fr.func_78276_b(s, j * 40 + 20 - w, 1 + i * 40 + k * 30, 0);
                            }
                        }
                    }
                    GL11.glPopMatrix();
                    GL11.glPopAttrib();
                }
            }
        }
    }

    void renderControls(Trans3 t) {
        this.selectSide(t, 0);
        this.lightVertex(t, 0.0, 0.0, 0.0);
        for (int i = 0; i < 4; ++i) {
            block7: for (int j = 0; j < 4; ++j) {
                Trans3 tij = t.translate(0.375 - (double)j * 0.25, -0.0625, -0.375 + (double)i * 0.25);
                int k = 4 * i + j;
                if (this.part == null) {
                    this.renderFrontCutout(tij);
                    continue;
                }
                int meta = this.part.getControlMeta(k);
                int state = this.part.getControlState(k);
                switch (this.part.getControlType(k)) {
                    case NONE: {
                        this.renderFrontCutout(tij);
                        continue block7;
                    }
                    case LEVER: {
                        this.renderLever(tij, meta, state);
                        continue block7;
                    }
                    case BUTTON: {
                        this.renderButton(tij, meta, state);
                        continue block7;
                    }
                    case LAMP: {
                        this.renderLamp(tij, meta, state);
                    }
                }
            }
        }
    }

    void renderBackCutouts(Trans3 t) {
        this.selectSideAndTile(t, 1, backCutoutIcon);
        this.lightVertex(t, 0.0, 0.0625, 0.0);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.face(t, -0.5 + (double)i * 0.25, 0.0725, -0.5 + (double)j * 0.25, 0.0, 0.0, 0.25, 0.25, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            }
        }
    }

    void renderFrontCutout(Trans3 t) {
        switch (this.phase) {
            case STATIC: {
                this.selectSideAndTile(t, 0, this.renderingInInventory ? backCutoutIcon : frontCutoutIcon);
                this.lightVertex(t, 0.0, -0.0625, 0.0);
                this.face(t, -0.125, -0.01, 0.125, 0.0, 0.0, -0.25, 0.25, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            }
        }
    }

    void renderLever(Trans3 t, int meta, int state) {
        switch (this.phase) {
            case STATIC: {
                IIcon icon = meta == 16 ? Blocks.field_150347_e.func_149691_a(0, 0) : Blocks.field_150325_L.func_149691_a(0, meta & 0xF);
                leverBaseModel.tessellate(t, icon);
                break;
            }
            case DYNAMIC: {
                Trans3 tl = t.translate(0.0, -0.0625, 0.0).rotate(leverRotations[state]);
                GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
                leverHandleModel.draw(tl, Blocks.field_150442_at.func_149691_a(0, 0));
            }
        }
    }

    void renderButton(Trans3 t, int meta, int state) {
        switch (this.phase) {
            case DYNAMIC: {
                IIcon icon = meta == 16 ? Blocks.field_150348_b.func_149691_a(0, 0) : (meta == 17 ? Blocks.field_150344_f.func_149691_a(0, 0) : Blocks.field_150325_L.func_149691_a(0, meta & 0xF));
                Trans3 tb = t.translate(0.0, 0.03125 * (double)state, 0.0);
                GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
                buttonModel.draw(tb, icon);
            }
        }
    }

    void renderLamp(Trans3 t, int meta, int state) {
        switch (this.phase) {
            case DYNAMIC: {
                GL11.glPushAttrib((int)64);
                this.setLightingDisabled(state != 0);
                double b = 0.25 + (double)state * 0.75;
                double[] c = colors[meta & 0xF];
                GL11.glColor3d((double)(b * c[0]), (double)(b * c[1]), (double)(b * c[2]));
                lampModel.draw(t, lampIcon);
                this.setLightingDisabled(false);
                GL11.glPopAttrib();
            }
        }
    }

    void renderCover(Trans3 t) {
        switch (this.phase) {
            case DYNAMIC: {
                GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
                coverModel.draw(t, this.block.func_149691_a(0, 0));
            }
        }
    }

    void pbtBox(Trans3 t, AxisAlignedBB box) {
        this.pbtBox(t, box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d - box.field_72340_a, box.field_72337_e - box.field_72338_b, box.field_72334_f - box.field_72339_c);
    }

    void pbtBox(Trans3 t, double x0, double y0, double z0, double dx, double dy, double dz) {
        double x1 = x0 + dx;
        double y1 = y0 + dy;
        double z1 = z0 + dz;
        this.pbtBoxFace(t, 0, x0, y0, z1, 0.0, 0.0, -dz, dx, 0.0, 0.0);
        this.pbtBoxFace(t, 1, x0, y1, z0, 0.0, 0.0, dz, dx, 0.0, 0.0);
        this.pbtBoxFace(t, 2, x1, y1, z0, 0.0, -dy, 0.0, -dx, 0.0, 0.0);
        this.pbtBoxFace(t, 3, x0, y1, z1, 0.0, -dy, 0.0, dx, 0.0, 0.0);
        this.pbtBoxFace(t, 4, x0, y1, z0, 0.0, -dy, 0.0, 0.0, 0.0, dz);
        this.pbtBoxFace(t, 5, x1, y1, z1, 0.0, -dy, 0.0, 0.0, 0.0, -dz);
    }

    void pbtBoxFace(Trans3 t, int side, double x, double y, double z, double dx1, double dy1, double dz1, double dx2, double dy2, double dz2) {
        this.selectSideAndTile(t, side, this.block.func_149691_a(side, this.metadata));
        this.ptRect(t, x, y, z, dx1, dy1, dz1, dx2, dy2, dz2);
    }

    void ptRect(Trans3 t, double x, double y, double z, double dx1, double dy1, double dz1, double dx2, double dy2, double dz2) {
        this.lightVertex(t, x + 0.5 * (dx1 + dx2), y + 0.5 * (dy1 + dy2), z + 0.5 * (dz1 + dz2));
        this.ptVertex(t, x, y, z);
        this.ptVertex(t, x + dx1, y + dy1, z + dz1);
        this.ptVertex(t, x + dx1 + dx2, y + dy1 + dy2, z + dz1 + dz2);
        this.ptVertex(t, x + dx2, y + dy2, z + dz2);
    }

    void ptVertex(Trans3 t, double x, double y, double z) {
        Vector3 p = t.p(x, y, z);
        double u = 0.0;
        double v = 0.0;
        switch (this.globalSide) {
            case 0: 
            case 1: {
                u = p.x - (double)this.blockX;
                v = p.z - (double)this.blockZ;
                break;
            }
            case 2: 
            case 3: {
                u = p.x - (double)this.blockX;
                v = -p.y + (double)this.blockY + 1.0;
                break;
            }
            case 4: 
            case 5: {
                u = p.z - (double)this.blockZ;
                v = -p.y + (double)this.blockY + 1.0;
            }
        }
        this.tess.func_78374_a(p.x, p.y, p.z, this.u0 + u * this.us, this.v0 + v * this.vs);
    }

    void selectSideAndTile(Trans3 t, int i, IIcon icon) {
        this.selectSide(t, i);
        this.selectTile(icon, 1.0, 1.0);
    }

    void selectSide(Trans3 t, int i) {
        ForgeDirection ld = ForgeDirection.getOrientation((int)i);
        ForgeDirection gd = t.t(ld);
        this.globalSide = gd.ordinal();
        this.tess.func_78375_b((float)gd.offsetX, (float)gd.offsetY, (float)gd.offsetZ);
    }

    void lightVertex(Trans3 t, double x, double y, double z) {
        if (this.world != null) {
            Vector3 p = t.p(x, y, z);
            ForgeDirection gd = ForgeDirection.getOrientation((int)this.globalSide);
            int br = this.block.func_149677_c(this.world, (int)Math.floor(p.x + 0.01 * (double)gd.offsetX), (int)Math.floor(p.y + 0.01 * (double)gd.offsetY), (int)Math.floor(p.z + 0.01 * (double)gd.offsetZ));
            this.tess.func_78380_c(br);
            float bm = sideShading[this.globalSide];
            this.tess.func_78369_a(bm * this.cmr, bm * this.cmg, bm * this.cmb, this.alpha);
        } else {
            this.tess.func_78386_a(1.0f, 1.0f, 1.0f);
            this.tess.func_78380_c(this.blockBrightness);
        }
    }

    public void setLightingDisabled(boolean off) {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        if (off) {
            GL11.glDisable((int)2896);
            if (!this.renderingInInventory) {
                GL11.glDisable((int)3553);
            }
        } else {
            GL11.glEnable((int)2896);
            if (!this.renderingInInventory) {
                GL11.glEnable((int)3553);
            }
        }
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static enum Phase {
        STATIC,
        DYNAMIC,
        BREAKING;

    }
}

