/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.blocks;

import gcewing.sg.BaseConfiguration;
import gcewing.sg.SGCraft;
import gcewing.sg.SGState;
import gcewing.sg.blocks.SGBlock;
import gcewing.sg.blocks.SGRingBlock;
import gcewing.sg.blocks.orientation.Orient4WaysByState;
import gcewing.sg.guis.SGGui;
import gcewing.sg.interfaces.IBlockState;
import gcewing.sg.interfaces.ICustomRenderer;
import gcewing.sg.interfaces.IOrientationHandler;
import gcewing.sg.renderers.SGRingBlockRenderer;
import gcewing.sg.tileentities.SGBaseTE;
import gcewing.sg.utils.BaseBlockUtils;
import gcewing.sg.utils.EnumWorldBlockLayer;
import gcewing.sg.utils.ModelSpec;
import gcewing.sg.utils.Trans3;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class SGBaseBlock
extends SGBlock<SGBaseTE> {
    protected static IOrientationHandler orient4WaysByState = new Orient4WaysByState();
    public static boolean debugMerge = false;
    static int explosionRadius = 10;
    static boolean fieryExplosion = true;
    static boolean smokyExplosion = true;
    static int[][] pattern = new int[][]{{2, 1, 2, 1, 2}, {1, 0, 0, 0, 1}, {2, 0, 0, 0, 2}, {1, 0, 0, 0, 1}, {2, 1, 0, 1, 2}};
    protected static String[] textures = new String[]{"stargateBlock", "stargateRing", "stargateBase_front"};
    protected static ModelSpec model = new ModelSpec("block/sg_base_block.smeg", textures);

    public static void configure(BaseConfiguration config) {
        explosionRadius = config.getInteger("stargate", "explosionRadius", explosionRadius);
        fieryExplosion = config.getBoolean("stargate", "explosionFlame", fieryExplosion);
        smokyExplosion = config.getBoolean("stargate", "explosionSmoke", smokyExplosion);
    }

    public SGBaseBlock() {
        super(Material.field_151576_e, SGBaseTE.class);
        this.func_149711_c(1.5f);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    @Override
    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return true;
    }

    @Override
    public IOrientationHandler getOrientationHandler() {
        return orient4WaysByState;
    }

    @Override
    public String[] getTextureNames() {
        return textures;
    }

    @Override
    public ModelSpec getModelSpec(IBlockState state) {
        return model;
    }

    @Override
    public SGBaseTE getBaseTE(IBlockAccess world, Vector3i pos) {
        TileEntity te = this.getTileEntity(world, pos);
        if (te instanceof SGBaseTE) {
            return (SGBaseTE)te;
        }
        return null;
    }

    @Override
    protected String getRendererClassName() {
        return "SGRingBlockRenderer";
    }

    @Override
    public ICustomRenderer getCustomRenderer() {
        if (this.RENDERER_INSTANCE == null) {
            this.RENDERER_INSTANCE = new SGRingBlockRenderer();
        }
        return this.RENDERER_INSTANCE;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, Vector3i pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean canHarvestBlock(IBlockState state, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean isMerged(IBlockAccess world, Vector3i pos) {
        SGBaseTE te = this.getSGBaseTE(world, pos);
        return te != null && te.isMerged;
    }

    @Override
    public void onBlockAdded(World world, Vector3i pos, IBlockState state) {
        if (debugMerge) {
            SGCraft.log.debug(String.format("SGBaseBlock.onBlockAdded: at %s", pos));
        }
        this.checkForMerge(world, pos);
    }

    @Override
    public boolean onBlockActivated(World world, Vector3i pos, IBlockState state, EntityPlayer player, EnumFacing side, float cx, float cy, float cz) {
        if (!world.field_72995_K) {
            SGCraft.log.debug(String.format("SGBaseBlock: at %s meta %s state %s", pos, world.func_72805_g(pos.x, pos.y, pos.z), state));
        }
        String Side2 = world.field_72995_K ? "Client" : "Server";
        SGBaseTE te = this.getSGBaseTE((IBlockAccess)world, pos);
        if (te != null) {
            if (debugMerge) {
                SGCraft.log.debug(String.format("SGBaseBlock.onBlockActivated: %s: isMerged = %s", Side2, te.isMerged));
            }
            if (te.isMerged) {
                SGCraft.mod.openGui(player, (Enum)SGGui.SGBase, world, pos);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean getWeakChanges(IBlockAccess world, Vector3i pos) {
        return true;
    }

    @Override
    public void onNeighborBlockChange(World world, Vector3i pos, IBlockState state, Block block) {
        SGBaseTE te = this.getSGBaseTE((IBlockAccess)world, pos);
        if (te != null) {
            te.onNeighborBlockChange();
        }
    }

    void checkForMerge(World world, Vector3i pos) {
        if (debugMerge) {
            SGCraft.log.debug(String.format("SGBaseBlock.checkForMerge at %s", pos));
        }
        if (this.isMerged((IBlockAccess)world, pos)) {
            return;
        }
        Trans3 t = this.localToGlobalTransformation((IBlockAccess)world, pos);
        for (int i = -2; i <= 2; ++i) {
            for (int j = 0; j <= 4; ++j) {
                if (i == 0 && j == 0) continue;
                Vector3i rp = Trans3.intVector(t.p(new Vector3d((double)i, (double)j, 0.0)));
                int type = this.getRingBlockType(world, rp);
                int pat = pattern[4 - j][2 + i];
                if (pat == 0 || type == pat) continue;
                if (debugMerge) {
                    SGCraft.log.debug(String.format("SGBaseBlock: world %d != pattern %d at %s", type, pattern[j][2 + i], rp));
                }
                return;
            }
        }
        if (debugMerge) {
            SGCraft.log.debug("SGBaseBlock: Merging");
        }
        SGBaseTE te = this.getSGBaseTE((IBlockAccess)world, pos);
        te.setMerged(true);
        BaseBlockUtils.markWorldBlockForUpdate(world, pos);
        for (int i = -2; i <= 2; ++i) {
            for (int j = 0; j <= 4; ++j) {
                Vector3i rp;
                Block block;
                if (i == 0 && j == 0 || !((block = BaseBlockUtils.getWorldBlock((IBlockAccess)world, rp = Trans3.intVector(t.p(new Vector3d((double)i, (double)j, 0.0))))) instanceof SGRingBlock)) continue;
                ((SGRingBlock)block).mergeWith(world, rp, pos);
            }
        }
        te.checkForLink();
    }

    int getRingBlockType(World world, Vector3i pos) {
        Block block = BaseBlockUtils.getWorldBlock((IBlockAccess)world, pos);
        if (block == Blocks.field_150350_a) {
            return 0;
        }
        if (block == SGCraft.sgRingBlock && !SGCraft.sgRingBlock.isMerged((IBlockAccess)world, pos)) {
            IBlockState state = BaseBlockUtils.getWorldBlockState((IBlockAccess)world, pos);
            switch (state.getValue(SGRingBlock.VARIANT)) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
        }
        return -1;
    }

    @Override
    public void breakBlock(World world, Vector3i pos, IBlockState state) {
        this.unmerge(world, pos);
        this.dropUpgrades(world, pos);
        super.breakBlock(world, pos, state);
    }

    void dropUpgrades(World world, Vector3i pos) {
        SGBaseTE te = this.getSGBaseTE((IBlockAccess)world, pos);
        if (te != null) {
            if (te.hasChevronUpgrade) {
                this.spawnAsEntity(world, pos, new ItemStack(SGCraft.sgChevronUpgrade));
            }
            if (te.hasIrisUpgrade) {
                this.spawnAsEntity(world, pos, new ItemStack(SGCraft.sgIrisUpgrade));
            }
        }
    }

    public void unmerge(World world, Vector3i pos) {
        SGBaseTE te = this.getSGBaseTE((IBlockAccess)world, pos);
        boolean goBang = false;
        if (te != null) {
            if (te.isMerged && te.state == SGState.Connected) {
                te.state = SGState.Idle;
                goBang = true;
            }
            te.disconnect();
            te.unlinkFromController();
            te.setMerged(false);
            BaseBlockUtils.markWorldBlockForUpdate(world, pos);
            this.unmergeRing(world, pos);
        }
        if (goBang && explosionRadius > 0) {
            this.explode(world, new Vector3d(0.5 + (double)pos.x, 2.5 + (double)pos.y, 0.5 + (double)pos.z), explosionRadius);
        }
    }

    void explode(World world, Vector3d p, double s) {
        world.func_72885_a(null, p.x, p.y, p.z, (float)s, fieryExplosion, smokyExplosion);
    }

    void unmergeRing(World world, Vector3i pos) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = 0; j <= 4; ++j) {
                for (int k = -2; k <= 2; ++k) {
                    this.unmergeRingBlock(world, new Vector3i((Vector3ic)pos), new Vector3i((Vector3ic)pos).add(i, j, k));
                }
            }
        }
    }

    void unmergeRingBlock(World world, Vector3i pos, Vector3i ringPos) {
        Block block = BaseBlockUtils.getWorldBlock((IBlockAccess)world, ringPos);
        if (debugMerge) {
            SGCraft.log.debug(String.format("SGBaseBlock.unmergeRingBlock: found %s at %s", block, ringPos));
        }
        if (block instanceof SGRingBlock) {
            ((SGRingBlock)block).unmergeFrom(world, ringPos, pos);
        }
    }

    public boolean func_149744_f() {
        return true;
    }

    @Override
    public int getStrongPower(IBlockAccess world, Vector3i pos, IBlockState state, EnumFacing side) {
        return this.getWeakPower(world, pos, state, side);
    }

    @Override
    public int getWeakPower(IBlockAccess world, Vector3i pos, IBlockState state, EnumFacing side) {
        SGBaseTE te = this.getSGBaseTE(world, pos);
        return te != null && te.state != SGState.Idle ? 15 : 0;
    }
}

