/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.blocks;

import gcewing.sg.SGCraft;
import gcewing.sg.blocks.SGBaseBlock;
import gcewing.sg.blocks.SGBlock;
import gcewing.sg.interfaces.IBlockState;
import gcewing.sg.interfaces.ICustomRenderer;
import gcewing.sg.interfaces.IProperty;
import gcewing.sg.renderers.SGRingBlockRenderer;
import gcewing.sg.tileentities.SGBaseTE;
import gcewing.sg.tileentities.SGRingTE;
import gcewing.sg.utils.BaseBlockUtils;
import gcewing.sg.utils.EnumWorldBlockLayer;
import gcewing.sg.utils.ModelSpec;
import gcewing.sg.utils.PropertyInteger;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class SGRingBlock
extends SGBlock<SGRingTE> {
    static final int numSubBlocks = 2;
    public static IProperty<Integer> VARIANT = PropertyInteger.create("variant", 0, 1);
    static String[] textures = new String[]{"stargateBlock", "stargateRing", "stargateChevron"};
    static ModelSpec[] models = new ModelSpec[]{new ModelSpec("block/sg_ring_block.smeg", "stargateBlock", "stargateRing"), new ModelSpec("block/sg_ring_block.smeg", "stargateBlock", "stargateChevron")};
    static String[] subBlockTitles = new String[]{"Stargate Ring Block", "Stargate Chevron Block"};

    public SGRingBlock() {
        super(Material.field_151576_e, SGRingTE.class);
        this.func_149711_c(1.5f);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    @Override
    protected void defineProperties() {
        super.defineProperties();
        this.addProperty(VARIANT);
    }

    @Override
    public String[] getTextureNames() {
        return textures;
    }

    @Override
    public ModelSpec getModelSpec(IBlockState state) {
        return models[state.getValue(VARIANT)];
    }

    @Override
    protected String getRendererClassName() {
        return "SGRingBlockRenderer";
    }

    @Override
    public ICustomRenderer getCustomRenderer() {
        if (this.RENDERER_INSTANCE == null) {
            this.RENDERER_INSTANCE = new SGRingBlockRenderer();
        }
        return this.RENDERER_INSTANCE;
    }

    @Override
    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return true;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean shouldCheckWeakPower(IBlockAccess world, Vector3i pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, Vector3i pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean canHarvestBlock(IBlockState state, EntityPlayer player) {
        return true;
    }

    @Override
    public int damageDropped(IBlockState state) {
        return this.getMetaFromState(state);
    }

    @Override
    public boolean onBlockActivated(World world, Vector3i pos, IBlockState state, EntityPlayer player, EnumFacing side, float cx, float cy, float cz) {
        SGRingTE te = this.getRingTE((IBlockAccess)world, pos);
        if (te.isMerged) {
            IBlockState baseState = BaseBlockUtils.getWorldBlockState((IBlockAccess)world, te.basePos);
            Block block = baseState.getBlock();
            if (block instanceof SGBaseBlock) {
                ((SGBaseBlock)block).onBlockActivated(world, te.basePos, baseState, player, side, cx, cy, cz);
            }
            return true;
        }
        return false;
    }

    @Override
    public SGBaseTE getBaseTE(IBlockAccess world, Vector3i pos) {
        SGRingTE rte = this.getRingTE(world, pos);
        if (rte != null) {
            return rte.getBaseTE();
        }
        return null;
    }

    public SGRingTE getRingTE(IBlockAccess world, Vector3i pos) {
        TileEntity te = this.getTileEntity(world, pos);
        if (te instanceof SGRingTE) {
            return (SGRingTE)te;
        }
        return null;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 2; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public boolean isMerged(IBlockAccess world, Vector3i pos) {
        SGRingTE te = this.getRingTE(world, pos);
        return te != null && te.isMerged;
    }

    public void mergeWith(World world, Vector3i pos, Vector3i basePos) {
        SGRingTE te = this.getRingTE((IBlockAccess)world, pos);
        te.isMerged = true;
        te.basePos = basePos;
        BaseBlockUtils.markWorldBlockForUpdate(world, pos);
    }

    public void unmergeFrom(World world, Vector3i pos, Vector3i basePos) {
        SGRingTE te = this.getRingTE((IBlockAccess)world, pos);
        if (SGBaseBlock.debugMerge) {
            SGCraft.log.debug(String.format("SGRingBlock.unmergeFrom: ring at %s base at %s te.isMerged = %s te.basePos = %s", pos, basePos, te.isMerged, te.basePos));
        }
        if (te.isMerged && te.basePos.equals((Object)basePos)) {
            if (SGBaseBlock.debugMerge) {
                SGCraft.log.debug("SGRingBlock.unmergeFrom: unmerging");
            }
            te.isMerged = false;
            te.markBlockChanged();
        }
    }

    @Override
    public void onBlockAdded(World world, Vector3i pos, IBlockState state) {
        if (SGBaseBlock.debugMerge) {
            SGCraft.log.debug(String.format("SGRingBlock.onBlockAdded: at %s", pos));
        }
        SGRingTE te = this.getRingTE((IBlockAccess)world, pos);
        this.updateBaseBlocks(world, pos, te);
    }

    @Override
    public void breakBlock(World world, Vector3i pos, IBlockState state) {
        SGRingTE te = this.getRingTE((IBlockAccess)world, pos);
        super.breakBlock(world, pos, state);
        if (te != null && te.isMerged) {
            this.updateBaseBlocks(world, pos, te);
        }
    }

    void updateBaseBlocks(World world, Vector3i pos, SGRingTE te) {
        if (SGBaseBlock.debugMerge) {
            SGCraft.log.debug(String.format("SGRingBlock.updateBaseBlocks: merged = %s, base = %s", te.isMerged, te.basePos));
        }
        for (int i = -2; i <= 2; ++i) {
            for (int j = -4; j <= 0; ++j) {
                for (int k = -2; k <= 2; ++k) {
                    Vector3i blockPos = new Vector3i((Vector3ic)pos).add(i, j, k);
                    Block block = BaseBlockUtils.getWorldBlock((IBlockAccess)world, blockPos);
                    if (!(block instanceof SGBaseBlock)) continue;
                    if (SGBaseBlock.debugMerge) {
                        SGCraft.log.debug(String.format("SGRingBlock.updateBaseBlocks: found base at %s", blockPos));
                    }
                    SGBaseBlock base = (SGBaseBlock)block;
                    if (!te.isMerged) {
                        base.checkForMerge(world, blockPos);
                        continue;
                    }
                    if (!te.basePos.equals((Object)blockPos)) continue;
                    base.unmerge(world, blockPos);
                }
            }
        }
    }

    public boolean isBeaconBase(IBlockAccess worldObj, int x, int y, int z, int beaconX, int beaconY, int beaconZ) {
        return true;
    }
}

