/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client;

import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesCommon;
import serverutils.ServerUtilitiesConfig;
import serverutils.client.NotificationHandler;
import serverutils.client.ServerUtilitiesClientConfig;
import serverutils.client.gui.BuiltinChunkMap;
import serverutils.client.gui.SidebarButtonManager;
import serverutils.command.client.CommandClientConfig;
import serverutils.command.client.CommandKaomoji;
import serverutils.command.client.CommandPing;
import serverutils.command.client.CommandPrintItem;
import serverutils.command.client.CommandPrintState;
import serverutils.command.client.CommandSimulateButton;
import serverutils.handlers.ServerUtilitiesClientEventHandler;
import serverutils.integration.navigator.NavigatorIntegration;
import serverutils.lib.OtherMods;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.client.IncompatibleModException;
import serverutils.lib.gui.misc.ChunkSelectorMap;
import serverutils.lib.icon.PlayerHeadIcon;
import serverutils.lib.net.MessageToClient;

public class ServerUtilitiesClient
extends ServerUtilitiesCommon {
    public static KeyBinding KEY_NBT;
    public static KeyBinding KEY_TRASH;
    public static final String KEY_CATEGORY = "key.categories.serverutilities";
    public static final String CLIENT_FOLDER = "serverutilities/client/";

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ClientUtils.localPlayerHead = new PlayerHeadIcon(Minecraft.func_71410_x().func_110432_I().func_148256_e().getId());
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)SidebarButtonManager.INSTANCE);
        ChunkSelectorMap.setMap(new BuiltinChunkMap());
        MinecraftForge.EVENT_BUS.register((Object)ServerUtilitiesClientEventHandler.INST);
        FMLCommonHandler.instance().bus().register((Object)ServerUtilitiesClientEventHandler.INST);
        KEY_NBT = new KeyBinding("key.serverutilities.nbt", 0, KEY_CATEGORY);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_NBT);
        KEY_TRASH = new KeyBinding("key.serverutilities.trash", 0, KEY_CATEGORY);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_TRASH);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        NotificationHandler.loadNotifications();
        for (Map.Entry<String, String> entry : ServerUtilitiesCommon.KAOMOJIS.entrySet()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandKaomoji(entry.getKey(), entry.getValue()));
        }
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandClientConfig());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandSimulateButton());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandPrintItem());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandPrintState());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandPing());
        if (OtherMods.isNavigatorLoaded()) {
            NavigatorIntegration.init();
        }
        if (Loader.isModLoaded((String)"FTBU") || Loader.isModLoaded((String)"FTBL")) {
            throw new IncompatibleModException();
        }
    }

    @Override
    public void handleClientMessage(MessageToClient message) {
        if (ServerUtilitiesConfig.debugging.log_network) {
            ServerUtilities.LOGGER.info("Net RX: {}", new Object[]{message.getClass().getName()});
        }
        message.onMessage();
    }

    @Override
    public long getWorldTime() {
        return Minecraft.func_71410_x().field_71441_e == null ? super.getWorldTime() : Minecraft.func_71410_x().field_71441_e.func_82737_E();
    }

    static {
        try {
            ConfigurationManager.registerConfig(ServerUtilitiesClientConfig.class);
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
    }
}

