/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesCommon;
import serverutils.data.NodeEntry;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.config.ConfigBoolean;
import serverutils.lib.config.ConfigDouble;
import serverutils.lib.config.ConfigInt;
import serverutils.lib.config.ConfigTimer;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.config.RankConfigValueInfo;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.permission.DefaultPermissionHandler;
import serverutils.lib.util.permission.DefaultPermissionLevel;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.ranks.ICommandWithPermission;

public class CmdDumpPermissions
extends CmdBase {
    private static final String[] EMPTY_ROW = new String[]{"", "", "", "", "", ""};

    public CmdDumpPermissions() {
        super("dump_permissions", CmdBase.Level.OP_OR_SP);
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        File permFile = MinecraftServer.func_71276_C().func_71209_f("serverutilities/server/all_permissions.txt");
        ArrayList<NodeEntry> permNodes = new ArrayList<NodeEntry>(ServerUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY);
        FileUtils.delete(permFile);
        int nodeCount = 0;
        for (String string : PermissionAPI.getPermissionHandler().getRegisteredNodes()) {
            DefaultPermissionLevel level = DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(string);
            String desc = PermissionAPI.getPermissionHandler().getNodeDescription(string);
            boolean printNode = true;
            for (NodeEntry cprefix : ServerUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY) {
                if (!string.startsWith(cprefix.getNode())) continue;
                if (cprefix.level == null || level != cprefix.level || !desc.isEmpty()) break;
                printNode = false;
                break;
            }
            if (!printNode) continue;
            permNodes.add(new NodeEntry(string, level, desc));
        }
        for (RankConfigValueInfo rankConfigValueInfo : RankConfigAPI.getHandler().getRegisteredConfigs()) {
            String desc = new ChatComponentTranslation("permission." + rankConfigValueInfo.node, new Object[0]).func_150260_c();
            permNodes.add(new NodeEntry(rankConfigValueInfo.node, rankConfigValueInfo.defaultValue, rankConfigValueInfo.defaultOPValue, desc.equals(rankConfigValueInfo.node) ? "" : desc, null));
        }
        ArrayList<List<String>> export = new ArrayList<List<String>>();
        export.add(Arrays.asList("Node", "Description", "Type", "Player default", "OP default", "Variants"));
        export.add(Arrays.asList(EMPTY_ROW));
        for (NodeEntry entry : permNodes) {
            ArrayList<Object> variants = new ArrayList<String>();
            if (entry.player instanceof ConfigBoolean) {
                variants.add("true");
                variants.add("false");
            } else {
                ConfigValue configValue = entry.player;
                if (configValue instanceof ConfigInt) {
                    ConfigInt configInt = (ConfigInt)configValue;
                    int min = configInt.getMin();
                    int n = configInt.getMax();
                    variants.add(String.format("%s to %s", min == Integer.MIN_VALUE ? "\u221e" : String.valueOf(min), n == Integer.MAX_VALUE ? "\u221e" : String.valueOf(n)));
                } else {
                    ConfigValue min = entry.player;
                    if (min instanceof ConfigDouble) {
                        ConfigDouble configDouble = (ConfigDouble)min;
                        double min2 = configDouble.getMin();
                        double max = configDouble.getMax();
                        variants.add(String.format("%s to %s", min2 == Double.NEGATIVE_INFINITY ? "\u221e" : StringUtils.formatDouble(min2), max == Double.POSITIVE_INFINITY ? Character.valueOf('\u221e') : StringUtils.formatDouble(max)));
                    } else {
                        ConfigValue min2 = entry.player;
                        if (min2 instanceof ConfigTimer) {
                            ConfigTimer configTimer = (ConfigTimer)min2;
                            Ticks max = configTimer.getMax();
                            variants.add(String.format("0s to %s", !max.hasTicks() ? "\u221e" : max.toString()));
                        } else {
                            variants = new ArrayList<String>(entry.player.getVariants());
                            variants.sort(StringUtils.IGNORE_CASE_COMPARATOR);
                        }
                    }
                }
            }
            export.add(Arrays.asList(entry.getNode(), entry.desc, entry.player.getId(), entry.player.getStringForGUI().func_150260_c(), entry.op.getStringForGUI().func_150260_c(), ((Object)variants).toString()));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int[] maxLength = new int[6];
        for (List list : export) {
            for (int i = 0; i < maxLength.length; ++i) {
                maxLength[i] = Math.max(maxLength[i], ((String)list.get(i)).length());
            }
        }
        for (List list : export) {
            builder.setLength(0);
            ++nodeCount;
            for (int i = 0; i < maxLength.length; ++i) {
                if (i > 0) {
                    builder.append(" | ");
                }
                builder.append(StringUtils.fillString((CharSequence)list.get(i), ' ', maxLength[i]));
            }
            arrayList.add(builder.toString());
        }
        arrayList.subList(2, arrayList.size()).sort(StringUtils.IGNORE_CASE_COMPARATOR);
        arrayList.add("\nCommand Permissions");
        int preSize = arrayList.size();
        ArrayList<List<String>> arrayList2 = new ArrayList<List<String>>();
        arrayList2.add(Arrays.asList("Node", "Command", "Default Permission", "Usage"));
        arrayList2.add(Arrays.asList(EMPTY_ROW));
        for (ICommand command : CommandUtils.getAllCommands(sender)) {
            if (!(command instanceof ICommandWithPermission)) continue;
            ICommandWithPermission iCommandWithPermission = (ICommandWithPermission)command;
            String node = iCommandWithPermission.serverutilities$getPermissionNode();
            DefaultPermissionLevel defaultPermissionLevel = DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(node);
            IChatComponent usage = CommandUtils.getTranslatedUsage(command, sender);
            arrayList2.add(Arrays.asList(node, "/" + command.func_71517_b(), defaultPermissionLevel.name(), usage.func_150260_c()));
        }
        int[] cmdMaxLength = new int[4];
        for (List list : arrayList2) {
            for (int i = 0; i < cmdMaxLength.length; ++i) {
                cmdMaxLength[i] = Math.max(cmdMaxLength[i], ((String)list.get(i)).length());
            }
        }
        for (List list : arrayList2) {
            builder.setLength(0);
            ++nodeCount;
            for (int i = 0; i < cmdMaxLength.length; ++i) {
                if (i > 0) {
                    builder.append(" | ");
                }
                builder.append(StringUtils.fillString((CharSequence)list.get(i), ' ', cmdMaxLength[i]));
            }
            if (((String)list.get(0)).equals("command")) continue;
            arrayList.add(builder.toString());
        }
        arrayList.subList(preSize + 2, arrayList.size()).sort(StringUtils.IGNORE_CASE_COMPARATOR);
        FileUtils.saveSafe(permFile, arrayList);
        sender.func_145747_a(ServerUtilities.lang(sender, "serverutilities.lang.permissions_dumped", nodeCount, permFile.getPath()));
    }
}

