/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import serverutils.ServerUtilities;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.permission.PermissionAPI;

public class CmdRepair
extends CmdBase {
    private static final Map<UUID, Long> lastRepairTime = new HashMap<UUID, Long>();

    public CmdRepair() {
        super("repair", CmdBase.Level.OP);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = CommandUtils.getSelfOrOther(sender, args, 0, "serverutilities.repair.other").getCommandPlayer(sender);
        RepairLevel repairLevel = this.getRepairLevel(player);
        if (repairLevel == null) {
            throw ServerUtilities.error(sender, "serverutilities.lang.repair.no_permission", new Object[0]);
        }
        this.checkCooldown(sender, player);
        int repairedCount = this.repairItems(player, repairLevel);
        lastRepairTime.put(player.func_110124_au(), System.currentTimeMillis());
        String name = player.getDisplayName();
        if (repairedCount > 0) {
            sender.func_145747_a(ServerUtilities.lang(sender, "serverutilities.lang.repair.success", name, repairedCount));
        } else {
            sender.func_145747_a(ServerUtilities.lang(sender, "serverutilities.lang.repair.nothing", name));
        }
    }

    private RepairLevel getRepairLevel(EntityPlayerMP player) {
        if (PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.repair.full")) {
            return RepairLevel.FULL;
        }
        if (PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.repair.armor")) {
            return RepairLevel.ARMOR;
        }
        if (PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.repair.hotbar")) {
            return RepairLevel.HOTBAR;
        }
        return null;
    }

    private void checkCooldown(ICommandSender sender, EntityPlayerMP player) throws CommandException {
        long elapsed;
        Long lastTime = lastRepairTime.get(player.func_110124_au());
        if (lastTime == null) {
            return;
        }
        long cooldownMs = RankConfigAPI.get(player, "serverutilities.repair.cooldown").getTimer().millis();
        long remaining = cooldownMs - (elapsed = System.currentTimeMillis() - lastTime);
        if (remaining > 0L) {
            throw ServerUtilities.error(sender, "cant_use_now_cooldown", StringUtils.getTimeString(remaining));
        }
    }

    private int repairItems(EntityPlayerMP player, RepairLevel level) {
        int i;
        InventoryPlayer inv = player.field_71071_by;
        int repaired = 0;
        for (i = 0; i < 9; ++i) {
            if (!this.repairItem(inv.field_70462_a[i])) continue;
            ++repaired;
        }
        if (level == RepairLevel.ARMOR || level == RepairLevel.FULL) {
            for (i = 0; i < inv.field_70460_b.length; ++i) {
                if (!this.repairItem(inv.field_70460_b[i])) continue;
                ++repaired;
            }
        }
        if (level == RepairLevel.FULL) {
            for (i = 9; i < inv.field_70462_a.length; ++i) {
                if (!this.repairItem(inv.field_70462_a[i])) continue;
                ++repaired;
            }
        }
        player.field_71069_bz.func_75142_b();
        return repaired;
    }

    private boolean repairItem(ItemStack stack) {
        if (stack == null || !stack.func_77951_h()) {
            return false;
        }
        stack.func_77964_b(0);
        return true;
    }

    private static enum RepairLevel {
        HOTBAR,
        ARMOR,
        FULL;

    }
}

