/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.gui.misc;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IChatComponent;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.config.ConfigList;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.PanelScrollBar;
import serverutils.lib.gui.SimpleButton;
import serverutils.lib.gui.Theme;
import serverutils.lib.gui.Widget;
import serverutils.lib.gui.WidgetLayout;
import serverutils.lib.gui.misc.GuiEditConfig;
import serverutils.lib.icon.Color4I;
import serverutils.lib.icon.MutableColor4I;
import serverutils.lib.util.misc.MouseButton;

public class GuiEditConfigList
extends GuiBase {
    private final ConfigValueInstance originalConfigList;
    private final Runnable callback;
    private final ConfigList<ConfigValue> configList;
    private final String title;
    private final Panel configPanel;
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final PanelScrollBar scroll;

    public GuiEditConfigList(ConfigValueInstance c, Runnable cb) {
        this.originalConfigList = c;
        this.callback = cb;
        this.configList = (ConfigList)this.originalConfigList.getValue().copy();
        IChatComponent title0 = this.originalConfigList.getDisplayName().func_150259_f();
        title0.func_150256_b().func_150227_a(Boolean.valueOf(true));
        this.title = title0.func_150254_d();
        this.configPanel = new Panel(this){

            @Override
            public void addWidgets() {
                for (int i = 0; i < ((GuiEditConfigList)GuiEditConfigList.this).configList.list.size(); ++i) {
                    this.add(new ButtonConfigValue(this, i, new ConfigValueInstance(Integer.toString(i), ConfigGroup.DEFAULT, (ConfigValue)((GuiEditConfigList)GuiEditConfigList.this).configList.list.get(i))));
                }
                if (GuiEditConfigList.this.originalConfigList.getCanEdit()) {
                    this.add(new ButtonAddValue(this));
                }
            }

            @Override
            public void alignWidgets() {
                for (Widget w : this.widgets) {
                    w.setWidth(this.width - 16);
                }
                GuiEditConfigList.this.scroll.setMaxValue(this.align(WidgetLayout.VERTICAL));
            }
        };
        this.scroll = new PanelScrollBar(this, this.configPanel);
        this.buttonAccept = new SimpleButton(this, I18n.func_135052_a((String)"gui.accept", (Object[])new Object[0]), GuiIcons.ACCEPT, (widget, button) -> {
            widget.getGui().closeGui();
            this.originalConfigList.getValue().setValueFromOtherValue(this.configList);
            this.callback.run();
        });
        this.buttonCancel = new SimpleButton(this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), GuiIcons.CANCEL, (widget, button) -> widget.getGui().closeGui());
    }

    @Override
    public boolean onInit() {
        for (Widget widget : this.configPanel.widgets) {
            if (!(widget instanceof ButtonConfigValue)) continue;
            ButtonConfigValue value = (ButtonConfigValue)widget;
            value.valueString = null;
        }
        return this.setFullscreen();
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        this.add(this.configPanel);
        this.add(this.scroll);
    }

    @Override
    public void alignWidgets() {
        this.configPanel.setPosAndSize(0, 20, this.width, this.height - 20);
        this.configPanel.alignWidgets();
        this.scroll.setPosAndSize(this.width - 16, 20, 16, this.height - 20);
        this.buttonAccept.setPos(this.width - 18, 2);
        this.buttonCancel.setPos(this.width - 38, 2);
    }

    @Override
    public boolean onClosedByKey(int key) {
        if (super.onClosedByKey(key)) {
            this.buttonCancel.onClicked(MouseButton.LEFT);
        }
        return false;
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        GuiEditConfig.COLOR_BACKGROUND.draw(0, 0, w, 20);
        theme.drawString(this.getTitle(), 6, 6, 2);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Theme getTheme() {
        return GuiEditConfig.THEME;
    }

    public class ButtonConfigValue
    extends Button {
        public final int index;
        public final ConfigValueInstance inst;
        private String valueString;

        public ButtonConfigValue(Panel panel, int i, ConfigValueInstance v) {
            super(panel);
            this.valueString = null;
            this.index = i;
            this.setHeight(12);
            this.inst = v;
        }

        public String getValueString() {
            if (this.valueString == null) {
                this.valueString = this.getGui().getTheme().trimStringToWidth(this.inst.getValue().getStringForGUI().func_150254_d(), this.width);
            }
            return this.valueString;
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            boolean mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            MutableColor4I textCol = this.inst.getValue().getColor().mutable();
            textCol.setAlpha(255);
            if (mouseOver) {
                textCol.addBrightness(60);
                Color4I.WHITE.withAlpha(33).draw(x, y, w, h);
                if (this.getMouseX() >= x + w - 19) {
                    Color4I.WHITE.withAlpha(33).draw(x + w - 19, y, 19, h);
                }
            }
            theme.drawString(this.getValueString(), x + 4, y + 2, textCol, 0);
            if (mouseOver) {
                theme.drawString("[-]", x + w - 16, y + 2, Color4I.WHITE, 0);
            }
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            if (this.getMouseX() >= this.getX() + this.width - 19) {
                if (GuiEditConfigList.this.originalConfigList.getCanEdit()) {
                    ((GuiEditConfigList)GuiEditConfigList.this).configList.list.remove(this.index);
                    this.parent.refreshWidgets();
                }
            } else {
                this.inst.getValue().onClicked(this.getGui(), this.inst, button, () -> {});
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            if (this.getMouseX() >= this.getX() + this.width - 19) {
                list.add(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]));
            } else {
                this.inst.getValue().addInfo(this.inst, list);
            }
        }
    }

    public class ButtonAddValue
    extends Button {
        public ButtonAddValue(Panel panel) {
            super(panel);
            this.setHeight(12);
            this.setTitle("+ " + I18n.func_135052_a((String)"gui.add", (Object[])new Object[0]));
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            boolean mouseOver;
            boolean bl = mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            if (mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(x, y, w, h);
            }
            theme.drawString(this.getTitle(), x + 4, y + 2, theme.getContentColor(this.getWidgetType()), 2);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            GuiEditConfigList.this.configList.add((ConfigValue)((GuiEditConfigList)GuiEditConfigList.this).configList.type);
            this.parent.refreshWidgets();
        }

        @Override
        public void addMouseOverText(List<String> list) {
        }
    }
}

