/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util.permission;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import serverutils.lib.util.permission.DefaultPermissionHandler;
import serverutils.lib.util.permission.DefaultPermissionLevel;
import serverutils.lib.util.permission.IPermissionHandler;
import serverutils.lib.util.permission.context.IContext;
import serverutils.lib.util.permission.context.PlayerContext;

public class PermissionAPI {
    private static IPermissionHandler permissionHandler = DefaultPermissionHandler.INSTANCE;

    public static void setPermissionHandler(IPermissionHandler handler) {
        Preconditions.checkNotNull((Object)handler, (Object)"Permission handler can't be null!");
        Preconditions.checkState((Loader.instance().getLoaderState().ordinal() <= LoaderState.PREINITIALIZATION.ordinal() ? 1 : 0) != 0, (Object)"Can't register after IPermissionHandler PreInit!");
        FMLLog.warning((String)"Replacing {} with {}", (Object[])new Object[]{permissionHandler.getClass().getName(), handler.getClass().getName()});
        permissionHandler = handler;
    }

    public static IPermissionHandler getPermissionHandler() {
        return permissionHandler;
    }

    public static String registerNode(String node, DefaultPermissionLevel level, String desc) {
        Preconditions.checkNotNull((Object)node, (Object)"Permission node can't be null!");
        Preconditions.checkNotNull((Object)((Object)level), (Object)"Permission level can't be null!");
        Preconditions.checkNotNull((Object)desc, (Object)"Permission description can't be null!");
        Preconditions.checkArgument((!node.isEmpty() ? 1 : 0) != 0, (Object)"Permission node can't be empty!");
        Preconditions.checkState((Loader.instance().getLoaderState().ordinal() > LoaderState.PREINITIALIZATION.ordinal() ? 1 : 0) != 0, (Object)"Can't register permission nodes before Init!");
        permissionHandler.registerNode(node, level, desc);
        return node;
    }

    public static boolean hasPermission(GameProfile profile, String node, @Nullable IContext context) {
        Preconditions.checkNotNull((Object)profile, (Object)"GameProfile can't be null!");
        Preconditions.checkNotNull((Object)node, (Object)"Permission node can't be null!");
        Preconditions.checkArgument((!node.isEmpty() ? 1 : 0) != 0, (Object)"Permission node can't be empty!");
        return permissionHandler.hasPermission(profile, node, context);
    }

    public static boolean hasPermission(EntityPlayer player, String node) {
        Preconditions.checkNotNull((Object)player, (Object)"Player can't be null!");
        return PermissionAPI.hasPermission(player.func_146103_bH(), node, new PlayerContext(player));
    }
}

