/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilitiesConfig;
import serverutils.client.gui.misc.GuiPlayerInfoWrapper;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageUpdateTabName
extends MessageToClient {
    private Collection<TabNameEntry> entries = new ArrayList<TabNameEntry>();

    public MessageUpdateTabName() {
    }

    public MessageUpdateTabName(Collection<ForgePlayer> players) {
        for (ForgePlayer player : players) {
            ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(player);
            boolean afk = data.afkTime >= ServerUtilitiesConfig.afk.getNotificationTimer();
            this.entries.add(new TabNameEntry(player.getName(), data.getNameForChat(), afk));
        }
    }

    public MessageUpdateTabName(ForgePlayer player, IChatComponent displayName) {
        ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(player);
        boolean afk = data.afkTime >= ServerUtilitiesConfig.afk.getNotificationTimer();
        this.entries.add(new TabNameEntry(player.getName(), displayName, afk));
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.GENERAL;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeCollection(this.entries, TabNameEntry.SERIALIZER);
    }

    @Override
    public void readData(DataIn data) {
        this.entries = data.readCollection(TabNameEntry.DESERIALIZER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_71356_B()) {
            return;
        }
        NetHandlerPlayClient handler = mc.func_147114_u();
        Map infoMap = handler.field_147310_i;
        List infoList = handler.field_147303_b;
        for (TabNameEntry entry : this.entries) {
            String name = entry.name;
            GuiPlayerInfo info = (GuiPlayerInfo)infoMap.get(name);
            if (info == null || entry.displayComponent == null) {
                return;
            }
            String displayName = entry.displayComponent.func_150254_d().replaceAll("[<>]", "");
            if (entry.afk) {
                displayName = EnumChatFormatting.GRAY + "[AFK] " + EnumChatFormatting.RESET + displayName;
            }
            if (info instanceof GuiPlayerInfoWrapper) {
                GuiPlayerInfoWrapper wrapper = (GuiPlayerInfoWrapper)info;
                wrapper.displayName = displayName;
                continue;
            }
            infoMap.remove(name);
            infoList.remove(info);
            GuiPlayerInfoWrapper newInfo = new GuiPlayerInfoWrapper(info, displayName);
            infoMap.put(name, newInfo);
            infoList.add(newInfo);
        }
    }

    private static class TabNameEntry {
        private final String name;
        private final IChatComponent displayComponent;
        private final boolean afk;
        public static final DataOut.Serializer<TabNameEntry> SERIALIZER = (data, entry) -> {
            data.writeString(entry.name);
            data.writeTextComponent(entry.displayComponent);
            data.writeBoolean(entry.afk);
        };
        public static final DataIn.Deserializer<TabNameEntry> DESERIALIZER = data -> new TabNameEntry(data.readString(), data.readTextComponent(), data.readBoolean());

        public TabNameEntry(String name, @Nullable IChatComponent displayComponent, boolean afk) {
            this.name = name;
            this.displayComponent = displayComponent;
            this.afk = afk;
        }
    }
}

